/*
 * Decompiled with CFR 0.152.
 */
package com.trs.net.ftp.shell;

import com.trs.net.ftp.protocol.FtpClientPI;
import com.trs.net.ftp.shell.Cftp;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

abstract class Command {
    String m_sName = null;
    String[] m_sAlias = null;
    String m_sUsage;
    String m_sHelpInfo;
    boolean m_zSupported = false;

    public String getName() {
        return this.m_sName;
    }

    void setName(String name) {
        this.setName(name, null);
    }

    void setName(String name, String[] alias) {
        this.m_sName = name;
        if (alias != null && alias.length > 0) {
            this.m_sAlias = alias;
        } else {
            this.m_sAlias = new String[1];
            this.m_sAlias[0] = this.m_sName;
        }
    }

    public String[] getAlias() {
        return this.m_sAlias;
    }

    public boolean getSupported() {
        return this.m_zSupported;
    }

    public void setSupported(boolean zSupported) {
        this.m_zSupported = zSupported;
    }

    public String getHelpInfo() {
        if (this.m_sHelpInfo == null) {
            return "";
        }
        return this.m_sHelpInfo;
    }

    void setHelpInfo(String info) {
        this.m_sHelpInfo = info;
    }

    public String getUsage() {
        return this.m_sUsage;
    }

    void setUsage(String info) {
        this.m_sUsage = info;
    }

    public void outUsage() {
        System.out.println(this.getUsage());
    }

    public FtpClientPI getFtpClient() {
        return Cftp.s_oFtpClient;
    }

    public void outFtpReply() {
        if (Cftp.s_zOutReplys) {
            System.out.print(Cftp.s_oFtpClient.getReplyString());
        }
    }

    Command getCommandByName(String name) {
        return (Command)Cftp.s_oValidCmds.get(name);
    }

    public void exec(String[] args) {
        try {
            if (this.prepare()) {
                this.execute(args);
                this.cleanup();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean prepare() {
        if (Cftp.s_oFtpClient.isConnected()) {
            return true;
        }
        System.out.println("Not connected.");
        return false;
    }

    public void execute(String[] args) throws Exception {
        System.out.println(String.valueOf(this.getName()) + " : Unimplemented command.");
    }

    public void cleanup() {
        if (this.getFtpClient().getReplyCode() == 421) {
            this.getFtpClient().close();
        }
    }

    public ArrayList listNames(String path) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        InputStream is = this.getFtpClient().listNames(path);
        if (is != null) {
            String line = null;
            String enco = this.getFtpClient().getCtrlEncoding();
            InputStreamReader isr = new InputStreamReader(is, enco);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
            br.close();
        }
        return list;
    }
}

