/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.locks;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import com.trs.infra.cluster.ACK;
import com.trs.infra.cluster.ClusterContext;
import com.trs.infra.cluster.ClusterMessage;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.MemberManager;
import com.trs.infra.cluster.Startable;
import com.trs.infra.cluster.Token;
import com.trs.infra.cluster.TokenEvent;
import com.trs.infra.cluster.TokenListener;
import com.trs.infra.cluster.TokenManager;
import com.trs.infra.cluster.ack.ACKMessage;
import com.trs.infra.cluster.impl.ClusterMessageQueue;
import com.trs.infra.cluster.locks.TokenImpl;
import com.trs.infra.cluster.locks.TokenMessage;
import com.trs.infra.cluster.locks.tokenevent.TokenDuplicatedEvent;
import com.trs.infra.cluster.locks.tokenevent.TokenOwnedEvent;
import com.trs.infra.cluster.locks.tokenevent.TokenReceivedEvent;
import com.trs.infra.cluster.locks.tokenevent.TokenSuspectEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TokenManagerImpl
implements TokenManager,
Startable {
    private static final Logger s_logger;
    private Map tokens;
    private Map listeners;
    private ClusterContext context;
    private ClusterMessageQueue tokenCreateMessageQueue;
    private TokenMessageSender tokenCreateMessageSender;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.locks.TokenManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public final ClusterContext getClusterContext() {
        return this.context;
    }

    public final void setClusterContext(ClusterContext clusterContext) {
        this.context = clusterContext;
    }

    public void start() {
        this.tokens = new ConcurrentHashMap(8);
        this.listeners = new ConcurrentHashMap(4);
        this.tokenCreateMessageQueue = new ClusterMessageQueue(64);
        this.tokenCreateMessageSender = new TokenMessageSender();
        this.tokenCreateMessageSender.startup();
    }

    public void close() {
        this.tokens.clear();
        this.listeners.clear();
        this.tokenCreateMessageSender.terminate();
    }

    public void prepare() {
    }

    public int getAcceptedMessage() {
        return 3;
    }

    public void receive(ClusterMessage msg, Member sender) {
        if (msg == null || !(msg instanceof TokenMessage)) {
            return;
        }
        TokenMessage message = (TokenMessage)msg;
        switch (message.getMinorId()) {
            case 1: {
                this.receiveTokenCreate(message, sender);
                break;
            }
            case 2: {
                this.receiveTokenOwned(message, sender);
                break;
            }
            case 3: {
                s_logger.info((Object)"TODO: token pass not implement.");
                break;
            }
            default: {
                s_logger.warn((Object)("Unknown minor message id: " + message.getMinorId()));
            }
        }
    }

    public void memberFailed(Member member) {
        Iterator itr = this.tokens.values().iterator();
        while (itr.hasNext()) {
            TokenImpl token = (TokenImpl)itr.next();
            if (!token.isOwnedBy(member)) continue;
            TokenSuspectEvent event = new TokenSuspectEvent(this.context);
            event.setSource(member);
            event.setToken(token);
            boolean takeOver = this.onEvent(event);
            if (takeOver) {
                s_logger.info((Object)("taking over token: " + token));
                this.tokens.remove(token.getName());
                this.sendTokenCreate(token);
                continue;
            }
            s_logger.warn((Object)(member + " failed arrvied. But it seems alive for service."));
        }
    }

    public void memberJoined(Member member) {
        this.sendOwnedTokens(member);
    }

    public void memberLeft(Member member) {
        this.takeOverTokenIfNeed(member);
    }

    public synchronized void addListener(String tokenName, TokenListener listener) {
        ArrayList<TokenListener> list = (ArrayList<TokenListener>)this.listeners.get(tokenName);
        if (list == null) {
            list = new ArrayList<TokenListener>(4);
            this.listeners.put(tokenName, list);
        }
        list.add(listener);
        TokenImpl token = (TokenImpl)this.tokens.get(tokenName);
        if (token == null) {
            token = new TokenImpl(tokenName);
            this.sendTokenCreate(token);
        } else {
            TokenReceivedEvent event = new TokenReceivedEvent(this.context);
            event.setSource(this.context.getMemberManager().find(token.getOwnerGUID()));
            event.setToken(token);
            listener.actionPerformed(event);
        }
    }

    private void takeOverTokenIfNeed(Member member) {
        Iterator itr = this.tokens.values().iterator();
        while (itr.hasNext()) {
            TokenImpl token = (TokenImpl)itr.next();
            if (!token.isOwnedBy(member)) continue;
            this.tokens.remove(token.getName());
            this.sendTokenCreate(token);
        }
    }

    private void sendTokenCreate(TokenImpl token) {
        TokenMessage message = new TokenMessage();
        message.setMinorId(1);
        message.setTokenName(token.getName());
        this.tokenCreateMessageQueue.put(message);
    }

    private void sendTokenCreate(TokenMessage message) {
        message.setNeedACK(true);
        this.context.send(message);
        ACK ack = message.getWaitACK();
        ack.waitFor();
        Iterator itr = ack.results();
        boolean ok = true;
        Boolean expected = Boolean.TRUE;
        TokenImpl token = new TokenImpl(message.getTokenName());
        while (itr.hasNext() && ok) {
            ACK.Result result = (ACK.Result)itr.next();
            ok = ((Object)expected).equals(result.getValue());
            if (ok || !s_logger.isDebugEnabled()) continue;
            s_logger.debug((Object)(result.getMember() + "said no to your token created. Token=" + token));
        }
        if (ok) {
            Member localMember = this.context.getMemberManager().member();
            TokenOwnedEvent event = new TokenOwnedEvent(this.context);
            event.setSource(localMember);
            event.setToken(token);
            boolean owned = this.onEvent(event);
            if (owned) {
                message.setNeedACK(false);
                message.setMinorId(2);
                this.context.send(message);
                token.setOwnerGUID(localMember._guid());
                this.tokens.put(token.getName(), token);
            }
        } else if (!this.tokens.containsKey(token.getName())) {
            this.tokenCreateMessageQueue.put(message);
        }
    }

    private void receiveTokenCreate(TokenMessage message, Member sender) {
        String tokenName = message.getTokenName();
        Token token = (Token)this.tokens.get(tokenName);
        boolean createAble = false;
        createAble = token == null ? sender._guid().compareTo(this.context.getMemberManager().member()._guid()) > 0 : token.isOwnedBy(sender);
        ACKMessage ack = new ACKMessage();
        ack.setAckFor(message.getSequence());
        ack.setValue(Boolean.valueOf(createAble));
        this.context.send((ClusterMessage)ack, sender);
    }

    private void sendOwnedTokens(Member receiver) {
        Member localMember = this.context.getMemberManager().member();
        Iterator itr = this.tokens.values().iterator();
        while (itr.hasNext()) {
            TokenImpl token = (TokenImpl)itr.next();
            if (!token.isOwnedBy(localMember)) continue;
            TokenMessage message = new TokenMessage();
            message.setMinorId(2);
            message.setTokenName(token.getName());
            this.context.send((ClusterMessage)message, receiver);
        }
    }

    private void receiveTokenOwned(TokenMessage message, Member sender) {
        TokenImpl token = new TokenImpl(message.getTokenName());
        TokenImpl tokenOwned = (TokenImpl)this.tokens.get(token.getName());
        if (tokenOwned != null) {
            Member owner;
            MemberManager memberManager = this.context.getMemberManager();
            if (tokenOwned.isOwnedBy(memberManager.member())) {
                s_logger.fatal((Object)("System error. " + sender + " said he owned the token that I owned. Token=" + token));
                TokenDuplicatedEvent dupEvent = new TokenDuplicatedEvent(this.context);
                dupEvent.setSource(memberManager.member());
                dupEvent.setToken(tokenOwned);
                this.onEvent(dupEvent);
                return;
            }
            String ownerGUID = tokenOwned.getOwnerGUID();
            if (!sender._guid().equals(ownerGUID) && (owner = memberManager.find(ownerGUID)) != null) {
                String msg = "What's up? " + sender + " said he owned the token that owned by " + owner;
                msg = String.valueOf(msg) + ", ignore it anyway. Token=" + token;
                s_logger.warn((Object)msg);
                TokenDuplicatedEvent dupEvent = new TokenDuplicatedEvent(this.context);
                dupEvent.setSource(memberManager.member());
                dupEvent.setToken(tokenOwned);
                this.onEvent(dupEvent);
                return;
            }
            this.tokens.remove(token.getName());
        }
        token.setOwnerGUID(sender._guid());
        this.tokens.put(token.getName(), token);
        TokenReceivedEvent event = new TokenReceivedEvent(this.context);
        event.setSource(sender);
        event.setToken(token);
        this.onEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onEvent(TokenEvent event) {
        List list = (List)this.listeners.get(event.getToken().getName());
        if (list != null) {
            boolean zOk = true;
            List list2 = list;
            synchronized (list2) {
                int i = 0;
                int size = list.size();
                while (i < size && zOk) {
                    zOk = ((TokenListener)list.get(i)).actionPerformed(event);
                    ++i;
                }
            }
            return zOk;
        }
        return true;
    }

    public Token getToken(String tokenName) {
        TokenImpl token = (TokenImpl)this.tokens.get(tokenName);
        return token;
    }

    public Iterator tokens() {
        return this.tokens.values().iterator();
    }

    private class TokenMessageSender
    implements Runnable {
        private boolean zRunning = true;

        private TokenMessageSender() {
        }

        public void startup() {
            Thread t = new Thread((Runnable)this, "TokenCreateMessageSender");
            t.setDaemon(true);
            t.start();
        }

        public void run() {
            while (this.zRunning) {
                TokenMessage msg = (TokenMessage)TokenManagerImpl.this.tokenCreateMessageQueue.get();
                if (msg == null) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                TokenManagerImpl.this.sendTokenCreate(msg);
            }
            if (TokenManagerImpl.this.tokenCreateMessageQueue.size() > 0) {
                s_logger.warn((Object)("Terminating, drop messages:" + TokenManagerImpl.this.tokenCreateMessageQueue.size()));
            }
        }

        private void terminate() {
            this.zRunning = false;
        }
    }
}

