/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster;

import java.net.InetAddress;

public abstract class Address {
    private String _toString_;
    private final InetAddress inetAddress;
    private final int port;

    public boolean equals(Object obj) {
        if (obj instanceof Address) {
            Address other = (Address)obj;
            return this.toString().equals(other.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this._toString_ == null) {
            this._toString_ = this.makeKeyString();
        }
        return this._toString_;
    }

    protected String makeKeyString() {
        return String.valueOf(this.getProtocol()) + ':' + this.getInetAddress().getHostAddress() + ':' + this.getPort();
    }

    public Address(InetAddress inetAddress, int port) {
        this.inetAddress = inetAddress;
        this.port = port;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public int getPort() {
        return this.port;
    }

    public abstract String getProtocol();

    public abstract boolean isMulticastAddress();
}

