/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.socket.impl;

import com.trs.cis4.socket.IRobotSocket;
import com.trs.cis4.socket.config.RobotBean;
import com.trs.cis4.socket.config.RobotConfig;
import com.trs.cis4.socket.config.RobotString;
import com.trs.cis4.socket.impl.SocketConnect;
import com.trs.cis4.socket.impl.SocketUtils;
import com.trs.cis4.util.ExceptionUtil;
import com.trs.cis4.util.FileUtil;
import java.io.File;
import org.apache.log4j.Logger;

public class SocketImpl
extends SocketConnect
implements IRobotSocket {
    private final Logger log = Logger.getLogger(this.getClass());

    public static void main(String[] args) {
        String filename = "\u63a5\u6536\u6570\u636e-301-(2008-12-15 10-23-12).dat";
        String folder = "H:\\Program Files\\MyEclipse 6.0\\eclipse\\datas\\";
        try {
            RobotBean robotBean = new RobotBean();
            byte[] returnAllBytes = FileUtil.getBytesFromFile(new File(String.valueOf(folder) + filename));
            byte[] returnBytes = new byte[returnAllBytes.length - 14];
            int i = 0;
            while (i < returnBytes.length) {
                returnBytes[i] = returnAllBytes[i + 14];
                ++i;
            }
            robotBean.setReturnBytes(returnBytes);
            robotBean.setRobotConfig(new RobotConfig());
            SocketImpl socketImpl = new SocketImpl();
            socketImpl.setRobotBean(robotBean);
            String[] beanStrings = socketImpl.getStrings();
            int i2 = 0;
            while (i2 < beanStrings.length) {
                System.out.print(beanStrings[i2]);
                System.out.print("\t");
                if (i2 % 3 == 2) {
                    System.out.println();
                }
                ++i2;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void setRobotConfig(RobotConfig robotConfig) {
        RobotBean robotBean = this.getRobotBean();
        robotBean.setRobotConfig(robotConfig);
        this.setRobotBean(robotBean);
    }

    public RobotBean getRobotParams() {
        return this.getRobotBean();
    }

    public void setCommand(int sendCode) {
        RobotBean robotBean = this.getRobotBean();
        robotBean.setSendCode(sendCode);
        this.setRobotBean(robotBean);
    }

    public void initData() {
        RobotConfig robotConfig = this.getRobotBean().getRobotConfig();
        if (robotConfig == null) {
            this.log.error((Object)"\u9519\u8bef\uff0c\u91c7\u96c6\u5de5\u5177\u53c2\u6570robotConfig\u4e3a\u7a7a\u503c!");
        }
        RobotBean robotBean = new RobotBean(robotConfig);
        this.setRobotBean(robotBean);
    }

    public void setSendBytes(byte[] sendBytes) {
        RobotBean robotBean = this.getRobotBean();
        robotBean.setSendBytes(sendBytes);
        this.setRobotBean(robotBean);
    }

    public void setString(String string) {
        this.setStringValue(string, 2);
    }

    public void setContent(String content) {
        this.setContentValue(content);
    }

    public void setStream(String stream) {
        this.setStringValue(stream, 4);
    }

    public void setByte(int _byte) {
        this.setIntValue(_byte, 1);
    }

    public void setWord(int word) {
        this.setIntValue(word, 2);
    }

    public void setDWord(int dword) {
        this.setIntValue(dword, 4);
    }

    public void setXWord(long xword) {
        this.setLongValue(xword, 6);
    }

    public void setLWord(long lword) {
        this.setLongValue(lword, 8);
    }

    private void setStringValue(String value, int length) {
        this.addByteValues(SocketUtils.addStringValue(value == null ? "" : value, length, this.getRobotBean().getRobotConfig().getCharset()));
    }

    private void setContentValue(String value) {
        this.addByteValues(SocketUtils.addStringValue(value == null ? "" : value, 0, this.getRobotBean().getRobotConfig().getCharset()));
    }

    private void setIntValue(int value, int length) {
        this.addByteValues(SocketUtils.addLengthByteValue(new Long(value), length));
    }

    private void setLongValue(long value, int length) {
        this.addByteValues(SocketUtils.addLengthByteValue(value, length));
    }

    private void addByteValues(byte[] addBytes) {
        RobotBean robotBean = this.getRobotBean();
        if (robotBean.getSendBytes() == null) {
            robotBean.setSendBytes(new byte[0]);
        }
        byte[] newdata = new byte[robotBean.getSendBytes().length + addBytes.length];
        int i = 0;
        while (i < newdata.length) {
            newdata[i] = i < robotBean.getSendBytes().length ? robotBean.getSendBytes()[i] : addBytes[i - robotBean.getSendBytes().length];
            ++i;
        }
        robotBean.setSendBytes(newdata);
        this.setRobotBean(robotBean);
    }

    public void checkExecute() throws ExceptionUtil {
        if (this.getRobotBean().getReturnBytes() == null) {
            this.socketConnect();
        }
    }

    public byte[] getReceiveBytes() throws ExceptionUtil {
        return this.getRobotBean().getReturnBytes();
    }

    public int getReturnCode() throws ExceptionUtil {
        return this.getRobotBean().getReturnCode();
    }

    public String getReturnLog() throws ExceptionUtil {
        return null;
    }

    public String getString() throws ExceptionUtil {
        return this.getStringValue(2);
    }

    public String getContent() throws ExceptionUtil {
        return this.getContentValue();
    }

    public String getStream() throws ExceptionUtil {
        return this.getStringValue(4);
    }

    public String[] getStrings() throws ExceptionUtil {
        return this.getStringsValue(2);
    }

    public String[] getStreams() throws ExceptionUtil {
        return this.getStringsValue(4);
    }

    public int getByte() throws ExceptionUtil {
        return this.getIntValue(1);
    }

    public int[] getBytes() throws ExceptionUtil {
        return this.getIntsValue(1);
    }

    public int getWord() throws ExceptionUtil {
        return this.getIntValue(2);
    }

    public int[] getWords() throws ExceptionUtil {
        return this.getIntsValue(2);
    }

    public int getDWord() throws ExceptionUtil {
        return this.getIntValue(4);
    }

    public int[] getDWords() throws ExceptionUtil {
        return this.getIntsValue(4);
    }

    public long getXWord() throws ExceptionUtil {
        return this.getLongValue(6);
    }

    public long[] getXWords() throws ExceptionUtil {
        return this.getLongsValue(6);
    }

    public long getLWord() throws ExceptionUtil {
        return this.getLongValue(8);
    }

    public long[] getLWords() throws ExceptionUtil {
        return this.getLongsValue(8);
    }

    public String[] getCustom(int startLength, int[] datasType) throws ExceptionUtil {
        if (startLength < 0 || datasType.length == 0) {
            return new String[0];
        }
        int dataLength = 1;
        if (startLength > 0) {
            dataLength = new Long(this.getLongValue(startLength)).intValue();
        }
        String[] retStrings = new String[dataLength * datasType.length];
        int n = 0;
        while (n < dataLength) {
            int i = 0;
            while (i < datasType.length) {
                String value = "";
                if (datasType[i] > 0) {
                    value = new Long(this.getLongValue(datasType[i])).toString();
                } else if (datasType[i] == -2) {
                    value = this.getString();
                } else if (datasType[i] == -4) {
                    value = this.getStream();
                } else {
                    this.log.error((Object)("\u4f20\u5165\u7684\u83b7\u53d6\u5b57\u8282\u6d41\u53c2\u6570\u4e0d\u6b63\u786e\uff01\u7b2c" + i + "\u4e2a\uff1a" + datasType[i]));
                }
                retStrings[n * datasType.length + i] = value;
                ++i;
            }
            ++n;
        }
        return retStrings;
    }

    private String[] getStringsValue(int length) throws ExceptionUtil {
        RobotBean robotBean = this.getRobotBean();
        String[] receiveStrings = SocketUtils.getStringsValue(robotBean.getReturnBytes(), length, robotBean.getRobotConfig().getCharset());
        int curBytePosition = robotBean.getReturnBytes().length;
        robotBean.setCurBytePosition(curBytePosition);
        this.setRobotBean(robotBean);
        return receiveStrings;
    }

    private int getIntValue(int length) throws ExceptionUtil {
        return new Long(this.getLongValue(length)).intValue();
    }

    private long getLongValue(int length) throws ExceptionUtil {
        RobotBean robotBean = this.getRobotBean();
        long dataInt = SocketUtils.getLongValue(robotBean.getCurBytePosition(), robotBean.getReturnBytes(), length);
        int curBytePosition = robotBean.getCurBytePosition() + length;
        robotBean.setCurBytePosition(curBytePosition);
        this.setRobotBean(robotBean);
        return dataInt;
    }

    private int[] getIntsValue(int length) throws ExceptionUtil {
        long[] dataInt = this.getLongsValue(length);
        int[] retInt = new int[dataInt.length];
        int i = 0;
        while (i < retInt.length) {
            retInt[i] = new Long(dataInt[i]).intValue();
            ++i;
        }
        return retInt;
    }

    private long[] getLongsValue(int length) throws ExceptionUtil {
        RobotBean robotBean = this.getRobotBean();
        long[] dataInt = SocketUtils.getLongsValue(robotBean.getReturnBytes(), length);
        int curBytePosition = robotBean.getReturnBytes().length;
        robotBean.setCurBytePosition(curBytePosition);
        this.setRobotBean(robotBean);
        return dataInt;
    }

    private String getStringValue(int length) throws ExceptionUtil {
        RobotBean robotBean = this.getRobotBean();
        RobotString robotString = SocketUtils.getStringValue(robotBean.getCurBytePosition(), robotBean.getReturnBytes(), length, this.getRobotBean().getRobotConfig().getCharset());
        int curBytePosition = robotBean.getCurBytePosition() + length + robotString.getLength();
        robotBean.setCurBytePosition(curBytePosition);
        this.setRobotBean(robotBean);
        return robotString.getValue();
    }

    private String getContentValue() throws ExceptionUtil {
        RobotBean robotBean = this.getRobotBean();
        String value = SocketUtils.getString(robotBean.getReturnBytes(), this.getRobotBean().getRobotConfig().getCharset());
        int curBytePosition = robotBean.getReturnBytes().length;
        robotBean.setCurBytePosition(curBytePosition);
        this.setRobotBean(robotBean);
        return value;
    }
}

