/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.document;

import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.view.AbstractView;

public abstract class AbstractPdfView
extends AbstractView {
    public AbstractPdfView() {
        this.setContentType("application/pdf");
    }

    protected final void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Document document = this.getDocument();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
        writer.setViewerPreferences(this.getViewerPreferences());
        document.open();
        this.buildPdfDocument(model, document, writer, request, response);
        document.close();
        response.setContentLength(baos.size());
        response.setContentType(this.getContentType());
        ServletOutputStream out = response.getOutputStream();
        baos.writeTo((OutputStream)out);
        out.flush();
    }

    protected Document getDocument() {
        return new Document(PageSize.A4);
    }

    protected int getViewerPreferences() {
        return 2053;
    }

    protected abstract void buildPdfDocument(Map var1, Document var2, PdfWriter var3, HttpServletRequest var4, HttpServletResponse var5) throws Exception;
}

