/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.TypeAccessor;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.Datum;
import oracle.sql.REF;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

class RefTypeAccessor
extends TypeAccessor {
    RefTypeAccessor(OracleStatement oracleStatement, String string, short s, int n, boolean bl) throws SQLException {
        this.init(oracleStatement, 111, 111, s, bl);
        this.initForDataAccess(n, 0, string);
    }

    RefTypeAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s, String string) throws SQLException {
        this.init(oracleStatement, 111, 111, s, false);
        this.initForDescribe(111, n, bl, n2, n3, n4, n5, n6, s, string);
        this.initForDataAccess(0, n, string);
    }

    RefTypeAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s, String string, OracleType oracleType) throws SQLException {
        this.init(oracleStatement, 111, 111, s, false);
        this.describeOtype = oracleType;
        this.initForDescribe(111, n, bl, n2, n3, n4, n5, n6, s, string);
        this.internalOtype = oracleType;
        this.initForDataAccess(0, n, string);
    }

    OracleType otypeFromName(String string) throws SQLException {
        if (!this.outBind) {
            return TypeDescriptor.getTypeDescriptor(string, this.statement.connection).getPickler();
        }
        return StructDescriptor.createDescriptor(string, (Connection)this.statement.connection).getOracleTypeADT();
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        super.initForDataAccess(n, n2, string);
        this.byteLength = this.statement.connection.refTypeAccessorByteLen;
    }

    REF getREF(int n) throws SQLException {
        REF rEF = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            byte[] byArray = this.pickledBytes(n);
            OracleTypeADT oracleTypeADT = (OracleTypeADT)this.internalOtype;
            rEF = new REF(oracleTypeADT.getFullName(), (Connection)this.statement.connection, byArray);
        }
        return rEF;
    }

    Object getObject(int n) throws SQLException {
        return this.getREF(n);
    }

    Datum getOracleObject(int n) throws SQLException {
        return this.getREF(n);
    }

    Object getObject(int n, Map map) throws SQLException {
        return this.getREF(n);
    }
}

