/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CleanTimeValues;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CleanerTransformations;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.DefaultTagProvider;
import org.htmlcleaner.EndTagToken;
import org.htmlcleaner.HtmlCleanerException;
import org.htmlcleaner.HtmlTokenizer;
import org.htmlcleaner.ITagInfoProvider;
import org.htmlcleaner.ProxyTagNode;
import org.htmlcleaner.SimpleXmlSerializer;
import org.htmlcleaner.TagInfo;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;
import org.htmlcleaner.audit.ErrorType;
import org.htmlcleaner.conditional.ITagNodeCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlCleaner {
    private static final String MARKER_ATTRIBUTE = "htmlcleaner_marker";
    private CleanerProperties properties;
    private CleanerTransformations transformations;

    public HtmlCleaner() {
        this(null, null);
    }

    public HtmlCleaner(ITagInfoProvider tagInfoProvider) {
        this(tagInfoProvider, null);
    }

    public HtmlCleaner(CleanerProperties properties) {
        this(null, properties);
    }

    public HtmlCleaner(ITagInfoProvider tagInfoProvider, CleanerProperties properties) {
        this.properties = properties == null ? new CleanerProperties() : properties;
        this.properties.setTagInfoProvider(tagInfoProvider == null ? DefaultTagProvider.INSTANCE : tagInfoProvider);
    }

    public TagNode clean(String htmlContent) {
        try {
            return this.clean(new StringReader(htmlContent), new CleanTimeValues());
        }
        catch (IOException e) {
            throw new HtmlCleanerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TagNode clean(File file, String charset) throws IOException {
        FileInputStream in = new FileInputStream(file);
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)in, charset);
            TagNode tagNode = this.clean(reader, new CleanTimeValues());
            return tagNode;
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {}
            }
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    public TagNode clean(File file) throws IOException {
        return this.clean(file, this.properties.getCharset());
    }

    @Deprecated
    public TagNode clean(URL url, String charset) throws IOException {
        CharSequence content = Utils.readUrl(url, charset);
        StringReader reader = new StringReader(((Object)content).toString());
        return this.clean(reader, new CleanTimeValues());
    }

    public TagNode clean(URL url) throws IOException {
        return this.clean(url, this.properties.getCharset());
    }

    public TagNode clean(InputStream in, String charset) throws IOException {
        return this.clean(new InputStreamReader(in, charset), new CleanTimeValues());
    }

    public TagNode clean(InputStream in) throws IOException {
        return this.clean(in, this.properties.getCharset());
    }

    public TagNode clean(Reader reader, CleanTimeValues cleanTimeValues) throws IOException {
        this.pushNesting(cleanTimeValues);
        cleanTimeValues._headOpened = false;
        cleanTimeValues._bodyOpened = false;
        cleanTimeValues._headTags.clear();
        cleanTimeValues.allTags.clear();
        cleanTimeValues.pruneTagSet = new HashSet<ITagNodeCondition>(this.properties.getPruneTagSet());
        cleanTimeValues.allowTagSet = new HashSet<ITagNodeCondition>(this.properties.getAllowTagSet());
        this.transformations = this.properties.getCleanerTransformations();
        cleanTimeValues.pruneNodeSet.clear();
        cleanTimeValues.htmlNode = this.newTagNode("html");
        cleanTimeValues.bodyNode = this.newTagNode("body");
        cleanTimeValues.headNode = this.newTagNode("head");
        cleanTimeValues.rootNode = null;
        cleanTimeValues.htmlNode.addChild(cleanTimeValues.headNode);
        cleanTimeValues.htmlNode.addChild(cleanTimeValues.bodyNode);
        HtmlTokenizer htmlTokenizer = new HtmlTokenizer(this, reader, cleanTimeValues);
        htmlTokenizer.start();
        List<BaseToken> nodeList = htmlTokenizer.getTokenList();
        this.closeAll(nodeList, cleanTimeValues);
        this.createDocumentNodes(nodeList, cleanTimeValues);
        this.calculateRootNode(cleanTimeValues, htmlTokenizer.getNamespacePrefixes());
        while (this.markNodesToPrune(nodeList, cleanTimeValues)) {
        }
        if (cleanTimeValues.pruneNodeSet != null && !cleanTimeValues.pruneNodeSet.isEmpty()) {
            for (TagNode tagNode : cleanTimeValues.pruneNodeSet) {
                TagNode parent = tagNode.getParent();
                if (parent == null) continue;
                parent.removeChild(tagNode);
            }
        }
        cleanTimeValues.rootNode.setDocType(htmlTokenizer.getDocType());
        this.popNesting(cleanTimeValues);
        return cleanTimeValues.rootNode;
    }

    private boolean markNodesToPrune(List nodeList, CleanTimeValues cleanTimeValues) {
        boolean nodesPruned = false;
        for (Object next : nodeList) {
            if (!(next instanceof TagNode) || cleanTimeValues.pruneNodeSet.contains(next)) continue;
            TagNode node = (TagNode)next;
            if (this.addIfNeededToPruneSet(node, cleanTimeValues)) {
                nodesPruned = true;
                continue;
            }
            if (node.isEmpty()) continue;
            nodesPruned |= this.markNodesToPrune(node.getAllChildren(), cleanTimeValues);
        }
        return nodesPruned;
    }

    private void calculateRootNode(CleanTimeValues cleanTimeValues, Set<String> namespacePrefixes) {
        cleanTimeValues.rootNode = cleanTimeValues.htmlNode;
        if (this.properties.isOmitHtmlEnvelope()) {
            List bodyChildren = cleanTimeValues.bodyNode.getAllChildren();
            cleanTimeValues.rootNode = new TagNode(null);
            if (bodyChildren != null) {
                for (String currChild : bodyChildren) {
                    cleanTimeValues.rootNode.addChild(currChild);
                }
            }
        }
        Map<String, String> atts = cleanTimeValues.rootNode.getAttributes();
        if (this.properties.isNamespacesAware() && namespacePrefixes != null) {
            for (String prefix : namespacePrefixes) {
                String xmlnsAtt = "xmlns:" + prefix;
                if (atts.containsKey(xmlnsAtt) || prefix.equals("xml")) continue;
                cleanTimeValues.rootNode.addAttribute(xmlnsAtt, prefix);
            }
        }
    }

    private void addAttributesToTag(TagNode tag, Map<String, String> attributes) {
        if (attributes != null) {
            Map<String, String> tagAttributes = tag.getAttributes();
            for (Map.Entry<String, String> currEntry : attributes.entrySet()) {
                String attName = currEntry.getKey();
                if (tagAttributes.containsKey(attName)) continue;
                String attValue = currEntry.getValue();
                tag.addAttribute(attName, attValue);
            }
        }
    }

    private boolean isFatalTagSatisfied(TagInfo tag, CleanTimeValues cleanTimeValues) {
        if (tag != null) {
            String fatalTagName = tag.getFatalTag();
            return fatalTagName == null ? true : this.getOpenTags(cleanTimeValues).tagExists(fatalTagName);
        }
        return true;
    }

    private boolean mustAddRequiredParent(TagInfo tag, CleanTimeValues cleanTimeValues) {
        String requiredParent;
        if (tag != null && (requiredParent = tag.getRequiredParent()) != null) {
            TagPos tagPos;
            String fatalTag = tag.getFatalTag();
            int fatalTagPositon = -1;
            if (fatalTag != null && (tagPos = this.getOpenTags(cleanTimeValues).findTag(fatalTag)) != null) {
                fatalTagPositon = tagPos.position;
            }
            ListIterator it = this.getOpenTags(cleanTimeValues).list.listIterator(this.getOpenTags(cleanTimeValues).list.size());
            while (it.hasPrevious()) {
                TagPos currTagPos = (TagPos)it.previous();
                if (!tag.isHigher(currTagPos.name)) continue;
                return currTagPos.position <= fatalTagPositon;
            }
            return true;
        }
        return false;
    }

    private TagNode newTagNode(String tagName) {
        TagNode tagNode = new TagNode(tagName);
        return tagNode;
    }

    private TagNode createTagNode(TagNode startTagToken) {
        startTagToken.setFormed();
        return startTagToken;
    }

    private boolean isAllowedInLastOpenTag(BaseToken token, CleanTimeValues cleanTimeValues) {
        TagPos last = this.getOpenTags(cleanTimeValues).getLastTagPos();
        if (last != null && last.info != null) {
            return last.info.allowsItem(token);
        }
        return true;
    }

    private void saveToLastOpenTag(List nodeList, Object tokenToAdd, CleanTimeValues cleanTimeValues) {
        TagPos last = this.getOpenTags(cleanTimeValues).getLastTagPos();
        if (last != null && last.info != null && last.info.isIgnorePermitted()) {
            return;
        }
        TagPos rubbishPos = this.getOpenTags(cleanTimeValues).findTagToPlaceRubbish();
        if (rubbishPos != null) {
            TagNode startTagToken = (TagNode)nodeList.get(rubbishPos.position);
            startTagToken.addItemForMoving(tokenToAdd);
        }
    }

    private boolean isStartToken(Object o) {
        return o instanceof TagNode && !((TagNode)o).isFormed();
    }

    void makeTree(List nodeList, ListIterator<BaseToken> nodeIterator, CleanTimeValues cleanTimeValues) {
        while (nodeIterator.hasNext()) {
            TagInfo tag;
            String tagName;
            BaseToken token = nodeIterator.next();
            if (token instanceof EndTagToken) {
                EndTagToken endTagToken = (EndTagToken)token;
                tagName = endTagToken.getName();
                tag = this.getTagInfoProvider().getTagInfo(tagName);
                if (tag == null && this.properties.isOmitUnknownTags() || tag != null && tag.isDeprecated() && this.properties.isOmitDeprecatedTags()) {
                    nodeIterator.set(null);
                    continue;
                }
                if (tag != null && !tag.allowsBody()) {
                    nodeIterator.set(null);
                    continue;
                }
                TagPos matchingPosition = this.getOpenTags(cleanTimeValues).findTag(tagName);
                if (matchingPosition == null) continue;
                List<TagNode> closed = this.closeSnippet(nodeList, matchingPosition, endTagToken, cleanTimeValues);
                nodeIterator.set(null);
                for (int i = closed.size() - 1; i >= 0; --i) {
                    TagNode closedTag = closed.get(i);
                    if (i <= 0 || tag == null || !tag.isContinueAfter(closedTag.getName())) continue;
                    TagNode cloned = closedTag.makeCopy();
                    cloned.setAutoGenerated(true);
                    nodeIterator.add(cloned);
                    nodeIterator.previous();
                }
                if (!this.getChildBreaks(cleanTimeValues).isEmpty()) {
                    while (matchingPosition.position < this.getChildBreaks(cleanTimeValues).getLastBreakingTagPosition()) {
                        this.getChildBreaks(cleanTimeValues).pop();
                    }
                }
                while (!this.getChildBreaks(cleanTimeValues).isEmpty() && tagName.equals(this.getChildBreaks(cleanTimeValues).getLastBreakingTag()) && matchingPosition.position == this.getChildBreaks(cleanTimeValues).getLastBreakingTagPosition()) {
                    if (nodeList.get(((TagPos)this.getChildBreaks(cleanTimeValues).closedByChildBreak.peek()).position) != null) {
                        int position = this.getChildBreaks(cleanTimeValues).pop().position;
                        Object toReopen = nodeList.get(position);
                        if (toReopen instanceof TagNode) {
                            this.reopenBrokenNode(nodeIterator, (TagNode)toReopen, cleanTimeValues);
                            continue;
                        }
                        if (!(toReopen instanceof List)) continue;
                        List tagNodes = (List)toReopen;
                        for (TagNode n : tagNodes) {
                            nodeIterator.add(n);
                            this.makeTree(nodeList, nodeList.listIterator(nodeList.size() - 1), cleanTimeValues);
                        }
                        nodeList.set(position, null);
                        continue;
                    }
                    this.getChildBreaks(cleanTimeValues).pop();
                }
                continue;
            }
            if (this.isStartToken(token)) {
                TagNode startTagToken = (TagNode)token;
                tagName = startTagToken.getName();
                tag = this.getTagInfoProvider().getTagInfo(tagName);
                TagPos lastTagPos = this.getOpenTags(cleanTimeValues).isEmpty() ? null : this.getOpenTags(cleanTimeValues).getLastTagPos();
                TagInfo lastTagInfo = lastTagPos == null ? null : this.getTagInfoProvider().getTagInfo(lastTagPos.name);
                cleanTimeValues.allTags.add(tagName);
                if ("html".equals(tagName)) {
                    this.addAttributesToTag(cleanTimeValues.htmlNode, startTagToken.getAttributes());
                    nodeIterator.set(null);
                    continue;
                }
                if ("body".equals(tagName)) {
                    cleanTimeValues._bodyOpened = true;
                    this.addAttributesToTag(cleanTimeValues.bodyNode, startTagToken.getAttributes());
                    nodeIterator.set(null);
                    continue;
                }
                if ("head".equals(tagName)) {
                    cleanTimeValues._headOpened = true;
                    this.addAttributesToTag(cleanTimeValues.headNode, startTagToken.getAttributes());
                    nodeIterator.set(null);
                    continue;
                }
                if (tag == null && this.properties.isOmitUnknownTags()) {
                    nodeIterator.set(null);
                    this.properties.fireUglyHtml(true, startTagToken, ErrorType.Unknown);
                    continue;
                }
                if (tag != null && tag.isDeprecated() && this.properties.isOmitDeprecatedTags()) {
                    nodeIterator.set(null);
                    this.properties.fireUglyHtml(true, startTagToken, ErrorType.Deprecated);
                    continue;
                }
                if (tag == null && lastTagInfo != null && !lastTagInfo.allowsAnything()) {
                    this.closeSnippet(nodeList, lastTagPos, startTagToken, cleanTimeValues);
                    nodeIterator.previous();
                    continue;
                }
                if (tag != null && tag.hasPermittedTags() && this.getOpenTags(cleanTimeValues).someAlreadyOpen(tag.getPermittedTags())) {
                    nodeIterator.set(null);
                    continue;
                }
                if (tag != null && tag.isUnique() && this.getOpenTags(cleanTimeValues).tagEncountered(tagName)) {
                    nodeIterator.set(null);
                    this.properties.fireHtmlError(true, startTagToken, ErrorType.UniqueTagDuplicated);
                    continue;
                }
                if (!this.isFatalTagSatisfied(tag, cleanTimeValues)) {
                    nodeIterator.set(null);
                    this.properties.fireHtmlError(true, startTagToken, ErrorType.FatalTagMissing);
                    continue;
                }
                if (this.mustAddRequiredParent(tag, cleanTimeValues)) {
                    String requiredParent = tag.getRequiredParent();
                    TagNode requiredParentStartToken = this.newTagNode(requiredParent);
                    requiredParentStartToken.setAutoGenerated(true);
                    nodeIterator.previous();
                    nodeIterator.add(requiredParentStartToken);
                    nodeIterator.previous();
                    this.properties.fireHtmlError(true, startTagToken, ErrorType.RequiredParentMissing);
                    continue;
                }
                if (tag != null && lastTagPos != null && tag.isMustCloseTag(lastTagInfo)) {
                    this.getChildBreaks(cleanTimeValues).addBreak(lastTagPos, new TagPos(nodeIterator.previousIndex(), tag.getName()));
                    boolean certainty = !startTagToken.hasAttribute("id");
                    this.properties.fireHtmlError(certainty, (TagNode)nodeList.get(lastTagPos.position), ErrorType.UnpermittedChild);
                    List<TagNode> closed = this.closeSnippet(nodeList, lastTagPos, startTagToken, cleanTimeValues);
                    int closedCount = closed.size();
                    if (tag.hasCopyTags() && closedCount > 0) {
                        TagNode currStartToken;
                        ListIterator<TagNode> closedIt = closed.listIterator(closedCount);
                        ArrayList<TagNode> toBeCopied = new ArrayList<TagNode>();
                        while (closedIt.hasPrevious() && tag.isCopy((currStartToken = closedIt.previous()).getName())) {
                            toBeCopied.add(0, currStartToken);
                        }
                        if (toBeCopied.size() > 0) {
                            for (TagNode currStartToken2 : toBeCopied) {
                                nodeIterator.add(currStartToken2.makeCopy());
                            }
                            for (int i = 0; i < toBeCopied.size(); ++i) {
                                nodeIterator.previous();
                            }
                        }
                    }
                    nodeIterator.previous();
                    continue;
                }
                if (!this.isAllowedInLastOpenTag(token, cleanTimeValues)) {
                    this.saveToLastOpenTag(nodeList, token, cleanTimeValues);
                    nodeIterator.set(null);
                    continue;
                }
                if (tag != null && !tag.allowsBody()) {
                    TagNode newTagNode = this.createTagNode(startTagToken);
                    this.addPossibleHeadCandidate(tag, newTagNode, cleanTimeValues);
                    nodeIterator.set(newTagNode);
                    continue;
                }
                this.getOpenTags(cleanTimeValues).addTag(tagName, nodeIterator.previousIndex());
                continue;
            }
            if (cleanTimeValues._headOpened && !cleanTimeValues._bodyOpened && this.properties.isKeepWhitespaceAndCommentsInHead()) {
                BaseToken lastTok;
                ContentNode contentNode;
                if (token instanceof CommentNode) {
                    if (this.getOpenTags(cleanTimeValues).getLastTagPos() == null) {
                        cleanTimeValues._headTags.add(new ProxyTagNode((CommentNode)token, cleanTimeValues.bodyNode));
                    }
                } else if (token instanceof ContentNode && (contentNode = (ContentNode)token).isBlank() && (lastTok = (BaseToken)nodeList.get(nodeList.size() - 1)) == token) {
                    cleanTimeValues._headTags.add(new ProxyTagNode(contentNode, cleanTimeValues.bodyNode));
                }
            }
            if (this.isAllowedInLastOpenTag(token, cleanTimeValues)) continue;
            this.saveToLastOpenTag(nodeList, token, cleanTimeValues);
            nodeIterator.set(null);
        }
    }

    private void reopenBrokenNode(ListIterator<BaseToken> nodeIterator, TagNode toReopen, CleanTimeValues cleanTimeValues) {
        TagNode closedByPresidence = toReopen;
        TagNode copy = closedByPresidence.makeCopy();
        copy.setAutoGenerated(true);
        copy.removeAttribute("id");
        nodeIterator.add(copy);
        this.getOpenTags(cleanTimeValues).addTag(closedByPresidence.getName(), nodeIterator.previousIndex());
    }

    protected boolean isRemovingNodeReasonablySafe(TagNode startTagToken) {
        return !startTagToken.hasAttribute("id") && !startTagToken.hasAttribute("name") && !startTagToken.hasAttribute("class");
    }

    private void createDocumentNodes(List listNodes, CleanTimeValues cleanTimeValues) {
        for (Object child : listNodes) {
            if (child == null) continue;
            boolean toAdd = true;
            if (child instanceof TagNode) {
                TagNode node = (TagNode)child;
                TagInfo tag = this.getTagInfoProvider().getTagInfo(node.getName());
                this.addPossibleHeadCandidate(tag, node, cleanTimeValues);
            } else if (child instanceof ContentNode) {
                boolean bl = toAdd = !"".equals(child.toString());
            }
            if (!toAdd) continue;
            cleanTimeValues.bodyNode.addChild(child);
        }
        for (TagNode headCandidateNode : cleanTimeValues._headTags) {
            boolean toMove = true;
            for (TagNode parent = headCandidateNode.getParent(); parent != null; parent = parent.getParent()) {
                if (!cleanTimeValues._headTags.contains(parent)) continue;
                toMove = false;
                break;
            }
            if (!toMove) continue;
            headCandidateNode.removeFromTree();
            cleanTimeValues.headNode.addChild(headCandidateNode);
        }
    }

    private List<TagNode> closeSnippet(List nodeList, TagPos tagPos, Object toNode, CleanTimeValues cleanTimeValues) {
        ArrayList<TagNode> closed = new ArrayList<TagNode>();
        ListIterator<Object> it = nodeList.listIterator(tagPos.position);
        TagNode tagNode = null;
        Object item = it.next();
        boolean isListEnd = false;
        while (toNode == null && !isListEnd || toNode != null && item != toNode) {
            if (this.isStartToken(item)) {
                TagNode startTagToken = (TagNode)item;
                closed.add(startTagToken);
                List itemsToMove = startTagToken.getItemsToMove();
                if (itemsToMove != null) {
                    this.pushNesting(cleanTimeValues);
                    this.makeTree(itemsToMove, itemsToMove.listIterator(0), cleanTimeValues);
                    this.closeAll(itemsToMove, cleanTimeValues);
                    startTagToken.setItemsToMove(null);
                    this.popNesting(cleanTimeValues);
                }
                TagNode newTagNode = this.createTagNode(startTagToken);
                TagInfo tag = this.getTagInfoProvider().getTagInfo(newTagNode.getName());
                this.addPossibleHeadCandidate(tag, newTagNode, cleanTimeValues);
                if (tagNode != null) {
                    tagNode.addChildren(itemsToMove);
                    tagNode.addChild(newTagNode);
                    it.set(null);
                } else if (itemsToMove != null) {
                    itemsToMove.add(newTagNode);
                    it.set(itemsToMove);
                } else {
                    it.set(newTagNode);
                }
                this.getOpenTags(cleanTimeValues).removeTag(newTagNode.getName());
                tagNode = newTagNode;
            } else if (tagNode != null) {
                it.set(null);
                if (item != null) {
                    tagNode.addChild(item);
                }
            }
            if (it.hasNext()) {
                item = it.next();
                continue;
            }
            isListEnd = true;
        }
        return closed;
    }

    private void closeAll(List nodeList, CleanTimeValues cleanTimeValues) {
        TagPos firstTagPos = this.getOpenTags(cleanTimeValues).findFirstTagPos();
        for (TagPos pos : this.getOpenTags(cleanTimeValues).list) {
            this.properties.fireHtmlError(true, (TagNode)nodeList.get(pos.position), ErrorType.UnclosedTag);
        }
        if (firstTagPos != null) {
            this.closeSnippet(nodeList, firstTagPos, null, cleanTimeValues);
        }
    }

    private void addPossibleHeadCandidate(TagInfo tagInfo, TagNode tagNode, CleanTimeValues cleanTimeValues) {
        if (tagInfo != null && tagNode != null && (tagInfo.isHeadTag() || tagInfo.isHeadAndBodyTag() && cleanTimeValues._headOpened && !cleanTimeValues._bodyOpened)) {
            cleanTimeValues._headTags.add(tagNode);
        }
    }

    public CleanerProperties getProperties() {
        return this.properties;
    }

    public Set<ITagNodeCondition> getPruneTagSet(CleanTimeValues cleanTimeValues) {
        return cleanTimeValues.pruneTagSet;
    }

    public Set<ITagNodeCondition> getAllowTagSet(CleanTimeValues cleanTimeValues) {
        return cleanTimeValues.allowTagSet;
    }

    public void addPruneNode(TagNode node, CleanTimeValues cleanTimeValues) {
        node.setPruned(true);
        cleanTimeValues.pruneNodeSet.add(node);
    }

    private boolean addIfNeededToPruneSet(TagNode tagNode, CleanTimeValues cleanTimeValues) {
        if (cleanTimeValues.pruneTagSet != null) {
            for (ITagNodeCondition condition : cleanTimeValues.pruneTagSet) {
                if (!condition.satisfy(tagNode)) continue;
                this.addPruneNode(tagNode, cleanTimeValues);
                this.properties.fireConditionModification(condition, tagNode);
                return true;
            }
        }
        if (cleanTimeValues.allowTagSet != null && !cleanTimeValues.allowTagSet.isEmpty()) {
            for (ITagNodeCondition condition : cleanTimeValues.allowTagSet) {
                if (!condition.satisfy(tagNode)) continue;
                return false;
            }
            if (!tagNode.isAutoGenerated()) {
                this.properties.fireUserDefinedModification(true, tagNode, ErrorType.NotAllowedTag);
            }
            this.addPruneNode(tagNode, cleanTimeValues);
            return true;
        }
        return false;
    }

    public Set<String> getAllTags(CleanTimeValues cleanTimeValues) {
        return cleanTimeValues.allTags;
    }

    public ITagInfoProvider getTagInfoProvider() {
        return this.properties.getTagInfoProvider();
    }

    public CleanerTransformations getTransformations() {
        return this.transformations;
    }

    public String getInnerHtml(TagNode node) {
        if (node != null) {
            String content = new SimpleXmlSerializer(this.properties).getAsString(node);
            int index1 = content.indexOf("<" + node.getName());
            index1 = content.indexOf(62, index1 + 1);
            int index2 = content.lastIndexOf(60);
            return index1 >= 0 && index1 <= index2 ? content.substring(index1 + 1, index2) : null;
        }
        throw new HtmlCleanerException("Cannot return inner html of the null node!");
    }

    public void setInnerHtml(TagNode node, String content) {
        if (node != null) {
            String nodeName = node.getName();
            StringBuilder html = new StringBuilder();
            html.append("<").append(nodeName).append(" htmlcleaner_marker=''>").append(content).append("</").append(nodeName).append(">");
            for (TagNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
                String parentName = parent.getName();
                html.insert(0, "<" + parentName + ">");
                html.append("</").append(parentName).append(">");
            }
            TagNode innerRootNode = this.clean(html.toString());
            TagNode cleanedNode = innerRootNode.findElementHavingAttribute(MARKER_ATTRIBUTE, true);
            if (cleanedNode != null) {
                node.setChildren(cleanedNode.getAllChildren());
            }
        }
    }

    public void initCleanerTransformations(Map transInfos) {
        this.transformations = new CleanerTransformations(transInfos);
    }

    private OpenTags getOpenTags(CleanTimeValues cleanTimeValues) {
        return cleanTimeValues.nestingStates.peek().getOpenTags();
    }

    private ChildBreaks getChildBreaks(CleanTimeValues cleanTimeValues) {
        return cleanTimeValues.nestingStates.peek().getChildBreaks();
    }

    private NestingState pushNesting(CleanTimeValues cleanTimeValues) {
        return cleanTimeValues.nestingStates.push(new NestingState());
    }

    private NestingState popNesting(CleanTimeValues cleanTimeValues) {
        return cleanTimeValues.nestingStates.pop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class OpenTags {
        private List<TagPos> list = new ArrayList<TagPos>();
        private TagPos last;
        private Set<String> set = new HashSet<String>();

        OpenTags() {
        }

        private boolean isEmpty() {
            return this.list.isEmpty();
        }

        private void addTag(String tagName, int position) {
            this.last = new TagPos(position, tagName);
            this.list.add(this.last);
            this.set.add(tagName);
        }

        private void removeTag(String tagName) {
            ListIterator<TagPos> it = this.list.listIterator(this.list.size());
            while (it.hasPrevious()) {
                TagPos currTagPos = it.previous();
                if (!tagName.equals(currTagPos.name)) continue;
                it.remove();
                break;
            }
            this.last = this.list.isEmpty() ? null : this.list.get(this.list.size() - 1);
        }

        private TagPos findFirstTagPos() {
            return this.list.isEmpty() ? null : this.list.get(0);
        }

        private TagPos getLastTagPos() {
            return this.last;
        }

        private TagPos findTag(String tagName) {
            if (tagName != null) {
                ListIterator<TagPos> it = this.list.listIterator(this.list.size());
                String fatalTag = null;
                TagInfo fatalInfo = HtmlCleaner.this.getTagInfoProvider().getTagInfo(tagName);
                if (fatalInfo != null) {
                    fatalTag = fatalInfo.getFatalTag();
                }
                while (it.hasPrevious()) {
                    TagPos currTagPos = it.previous();
                    if (tagName.equals(currTagPos.name)) {
                        return currTagPos;
                    }
                    if (fatalTag == null || !fatalTag.equals(currTagPos.name)) continue;
                    return null;
                }
            }
            return null;
        }

        private boolean tagExists(String tagName) {
            TagPos tagPos = this.findTag(tagName);
            return tagPos != null;
        }

        private TagPos findTagToPlaceRubbish() {
            TagPos result = null;
            TagPos prev = null;
            if (!this.isEmpty()) {
                ListIterator<TagPos> it = this.list.listIterator(this.list.size());
                while (it.hasPrevious()) {
                    result = it.previous();
                    if ((result.info == null || result.info.allowsAnything()) && prev != null) {
                        return prev;
                    }
                    prev = result;
                }
            }
            return result;
        }

        private boolean tagEncountered(String tagName) {
            return this.set.contains(tagName);
        }

        private boolean someAlreadyOpen(Set<String> tags) {
            for (TagPos curr : this.list) {
                if (!tags.contains(curr.name)) continue;
                return true;
            }
            return false;
        }
    }

    protected class NestingState {
        private OpenTags openTags;
        private ChildBreaks childBreaks;

        protected NestingState() {
            this.openTags = new OpenTags();
            this.childBreaks = new ChildBreaks();
        }

        public OpenTags getOpenTags() {
            return this.openTags;
        }

        public ChildBreaks getChildBreaks() {
            return this.childBreaks;
        }
    }

    private class ChildBreaks {
        private Stack<TagPos> closedByChildBreak = new Stack();
        private Stack<TagPos> breakingTags = new Stack();

        private ChildBreaks() {
        }

        public void addBreak(TagPos closedPos, TagPos breakPos) {
            this.closedByChildBreak.add(closedPos);
            this.breakingTags.add(breakPos);
        }

        public boolean isEmpty() {
            return this.closedByChildBreak.isEmpty();
        }

        public String getLastBreakingTag() {
            return this.breakingTags.peek().name;
        }

        public TagPos pop() {
            this.breakingTags.pop();
            return this.closedByChildBreak.pop();
        }

        public int getLastBreakingTagPosition() {
            return this.breakingTags.isEmpty() ? -1 : this.breakingTags.peek().position;
        }
    }

    private class TagPos {
        private int position;
        private String name;
        private TagInfo info;

        TagPos(int position, String name) {
            this.position = position;
            this.name = name;
            this.info = HtmlCleaner.this.getTagInfoProvider().getTagInfo(name);
        }
    }
}

