/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.support.spring;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.MappingFastJsonValue;
import com.alibaba.fastjson.util.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractGenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastJsonpHttpMessageConverter4
extends AbstractGenericHttpMessageConverter<Object> {
    private FastJsonConfig fastJsonConfig = new FastJsonConfig();
    private static final byte[] JSONP_FUNCTION_PREFIX_BYTES = "/**/".getBytes(IOUtils.UTF8);
    private static final byte[] JSONP_FUNCTION_SUFFIX_BYTES = ");".getBytes(IOUtils.UTF8);

    public FastJsonConfig getFastJsonConfig() {
        return this.fastJsonConfig;
    }

    public void setFastJsonConfig(FastJsonConfig fastJsonConfig) {
        this.fastJsonConfig = fastJsonConfig;
    }

    public FastJsonpHttpMessageConverter4() {
        super(MediaType.ALL);
    }

    protected boolean supports(Class<?> paramClass) {
        return true;
    }

    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        InputStream in = inputMessage.getBody();
        return JSON.parseObject(in, this.fastJsonConfig.getCharset(), type, this.fastJsonConfig.getFeatures());
    }

    protected Object readInternal(Class<? extends Object> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        InputStream in = inputMessage.getBody();
        return JSON.parseObject(in, this.fastJsonConfig.getCharset(), clazz, this.fastJsonConfig.getFeatures());
    }

    protected void writeInternal(Object obj, Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        HttpHeaders headers = outputMessage.getHeaders();
        ByteArrayOutputStream outnew = new ByteArrayOutputStream();
        int len = this.writePrefix(outnew, obj);
        Object value = obj;
        if (obj instanceof MappingFastJsonValue) {
            MappingFastJsonValue container = (MappingFastJsonValue)obj;
            value = container.getValue();
        }
        len += JSON.writeJSONString((OutputStream)outnew, this.fastJsonConfig.getCharset(), value, this.fastJsonConfig.getSerializeConfig(), this.fastJsonConfig.getSerializeFilters(), this.fastJsonConfig.getDateFormat(), JSON.DEFAULT_GENERATE_FEATURE, this.fastJsonConfig.getSerializerFeatures());
        len += this.writeSuffix(outnew, obj);
        if (this.fastJsonConfig.isWriteContentLength()) {
            headers.setContentLength((long)len);
        }
        OutputStream out = outputMessage.getBody();
        outnew.writeTo(out);
        outnew.close();
    }

    protected int writePrefix(ByteArrayOutputStream out, Object object) throws IOException {
        String jsonpFunction = object instanceof MappingFastJsonValue ? ((MappingFastJsonValue)object).getJsonpFunction() : null;
        int length = 0;
        if (jsonpFunction != null) {
            out.write(JSONP_FUNCTION_PREFIX_BYTES);
            byte[] bytes = (jsonpFunction + "(").getBytes(IOUtils.UTF8);
            out.write(bytes);
            length += JSONP_FUNCTION_PREFIX_BYTES.length + bytes.length;
        }
        return length;
    }

    protected int writeSuffix(ByteArrayOutputStream out, Object object) throws IOException {
        String jsonpFunction = object instanceof MappingFastJsonValue ? ((MappingFastJsonValue)object).getJsonpFunction() : null;
        int length = 0;
        if (jsonpFunction != null) {
            out.write(JSONP_FUNCTION_SUFFIX_BYTES);
            length += JSONP_FUNCTION_SUFFIX_BYTES.length;
        }
        return length;
    }
}

