/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class DB2InputStream
extends InputStream {
    protected int locator;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected int currentPosition;
    protected int docLength;
    protected int lobType;
    protected int marked;
    protected int maxFieldSize;
    protected int bufferPos = 0;
    protected int bufferEnd = 0;
    protected static final int defaultBufferSize = 32000;
    protected byte[] buffer = null;
    protected int numBytesRead = 0;
    protected boolean closed = false;

    public DB2InputStream() {
        this.closed = false;
    }

    public DB2InputStream(DB2Statement dB2Statement, int n, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2InputStream( stmt, " + n + ", " + n2 + " )");
            }
            this.connection = dB2Statement.getDB2Connection();
            this.maxFieldSize = dB2Statement.getMaxFieldSize();
            this.statement = this.connection.getInputStreamStmt();
            this.locator = n;
            this.currentPosition = 1;
            this.marked = 1;
            this.lobType = n2;
            Integer n3 = new Integer(0);
            DB2Statement dB2Statement2 = this.statement;
            synchronized (dB2Statement2) {
                int n4;
                this.docLength = this.SQLGetLength(n3, this.lobType, this.locator, this.statement.statementHandle);
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "docLength", this.docLength);
                }
                if ((n4 = n3.intValue()) != 0) {
                    this.connection.sqlExcptGen.check_return_code(this.statement, n4);
                }
            }
            if (this.maxFieldSize != 0 && this.maxFieldSize < this.docLength) {
                this.docLength = this.maxFieldSize;
            }
            this.closed = false;
        }
        finally {
            Object var5_7 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "DB2InputStream()");
            }
        }
    }

    protected native int SQLGetLength(Integer var1, int var2, int var3, int var4);

    protected native int SQLReadArrayOfByte(byte[] var1, Integer var2, int var3, int var4, int var5, int var6);

    public int available() throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        int n = 0;
        if (this.buffer != null) {
            n = this.bufferEnd - this.bufferPos;
        }
        if (this.currentPosition <= this.docLength) {
            n += this.docLength - this.currentPosition + 1;
        }
        return n;
    }

    public void close() {
        this.closed = true;
    }

    public void finalize() {
        if (!this.closed) {
            this.close();
        }
    }

    final long getLength() throws SQLException {
        Integer n = new Integer(0);
        DB2Statement dB2Statement = this.statement;
        synchronized (dB2Statement) {
            this.docLength = this.SQLGetLength(n, this.lobType, this.locator, this.statement.statementHandle);
            int n2 = n;
            if (n2 != 0) {
                this.connection.sqlExcptGen.check_return_code(this.statement, n2);
            }
        }
        if (this.maxFieldSize != 0 && this.maxFieldSize < this.docLength) {
            this.docLength = this.maxFieldSize;
        }
        return this.docLength;
    }

    protected boolean hasMore() {
        return this.currentPosition <= this.docLength;
    }

    public synchronized void mark(int n) {
        this.marked = n;
    }

    public boolean markSupported() {
        return true;
    }

    void moveTo(int n) {
        this.currentPosition = n < this.docLength ? n : this.docLength;
    }

    public synchronized int read() throws IOException {
        byte[] byArray;
        int n;
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "read()");
        }
        int n2 = (n = this.read(byArray = new byte[1])) == -1 ? n : (byArray[0] < 0 ? byArray[0] + 256 : byArray[0]);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "read()", n2);
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(byte[] byArray) throws IOException {
        int n;
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        int n2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "read( b )");
            }
            if (this.available() == 0) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(5, "No more data available from the database");
                }
                n2 = -1;
            } else {
                int n3;
                int n4 = byArray.length;
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "bytesToRead", n4);
                }
                if (this.buffer != null) {
                    n3 = this.bufferEnd - this.bufferPos;
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "bytesAvailable", n3);
                    }
                    if (n3 != 0) {
                        if (n4 <= n3) {
                            System.arraycopy(this.buffer, this.bufferPos, byArray, 0, n4);
                            this.bufferPos += n4;
                            n2 = n4;
                            n4 = 0;
                        } else {
                            System.arraycopy(this.buffer, this.bufferPos, byArray, 0, n3);
                            this.bufferPos += n3;
                            n2 = n3;
                            n4 -= n3;
                        }
                    }
                }
                if (n4 != 0) {
                    this.buffer = new byte[Math.min(this.docLength - this.currentPosition + 1, Math.max(32000, n4))];
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(30, "currentPosition", this.currentPosition);
                        DB2Trace.data(30, "bytesToRead", n4);
                        DB2Trace.data(30, "buffer.length", this.buffer.length);
                    }
                    n3 = 0;
                    if (this.buffer.length != 0) {
                        Integer n5 = new Integer(0);
                        try {
                            this.numBytesRead = 0;
                            Object object = this.statement;
                            synchronized (object) {
                                n3 = this.SQLReadArrayOfByte(this.buffer, n5, this.lobType, this.locator, this.currentPosition, this.statement.statementHandle);
                                int n6 = n5;
                                if (n6 != 0) {
                                    this.connection.sqlExcptGen.check_return_code(this.statement, n6);
                                }
                            }
                            this.currentPosition += this.numBytesRead;
                            if (this.lobType == -351) {
                                object = new String(this.buffer, 0, n3, "UnicodeBig");
                                this.buffer = ((String)object).getBytes();
                                n3 = this.buffer.length;
                            }
                        }
                        catch (SQLException sQLException) {
                            throw new IOException(sQLException.toString());
                        }
                    }
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(40, "bytesAvailable", n3);
                    }
                    this.bufferPos = 0;
                    this.bufferEnd = n3;
                    if (n3 != 0) {
                        if (n4 <= n3) {
                            System.arraycopy(this.buffer, this.bufferPos, byArray, n2, n4);
                            this.bufferPos += n4;
                            n2 += n4;
                        } else {
                            System.arraycopy(this.buffer, this.bufferPos, byArray, n2, n3);
                            this.bufferPos += n3;
                            n2 += n3;
                        }
                    }
                }
            }
            n = n2;
            Object var5_10 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "read()", n2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "read()", n2);
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        int n4 = -1;
        try {
            byte[] byArray2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "read( b, " + n + ", " + n2 + " )");
            }
            if ((n4 = this.read(byArray2 = new byte[n2])) != -1) {
                System.arraycopy(byArray2, 0, byArray, n, n4);
            }
            n3 = n4;
            Object var7_7 = null;
            if (!DB2Trace.TraceOn) return n3;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "read()", n4);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "read()", n4);
        return n3;
    }

    public synchronized void reset() throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        this.currentPosition = this.marked;
    }

    public synchronized long skip(long l) throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        if (this.buffer != null && l >= (long)(this.bufferEnd - this.bufferPos)) {
            this.buffer = null;
            l -= (long)(this.bufferEnd - this.bufferPos);
        }
        if (this.buffer == null) {
            if (this.currentPosition + (int)l > this.docLength) {
                this.currentPosition = this.docLength + 1;
                l = this.docLength - this.currentPosition;
            } else {
                this.currentPosition += (int)l;
            }
        }
        return l;
    }
}

