/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.mri.DB2Messages;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class DB2Driver
implements Driver {
    private static DB2Driver ourDriver = null;
    public static final int MajorVersion = 7;
    public static final int MinorVersion = 1;
    private static final String libraryName = "libdb2jdbc.so";
    private static final String HPlibraryName = "libdb2jdbc.sl";
    private static final String libpath_unix = "java12";
    private static final String libpath_nt = "bin";
    private static final String libpath_os2 = "dll";
    private static final String DLLName = "db2jdbc";
    private static final String MSDLLName = "db2jms";
    private static String language = "C";
    public static boolean loaded = false;
    protected int traceOn = 0;
    public static final String buildLevel = "n020616";

    static {
        try {
            if (ourDriver == null) {
                ourDriver = new DB2Driver();
                DriverManager.registerDriver(ourDriver);
            }
        }
        catch (SQLException sQLException) {
            String[] stringArray = new String[]{"COM.ibm.db2.jdbc.app.DB2Driver", sQLException.getMessage(), sQLException.getSQLState(), String.valueOf(sQLException.getErrorCode())};
            String string = new DB2Messages().getString("0645", stringArray);
            DriverManager.println(string);
        }
    }

    public DB2Driver() throws SQLException {
        if (!loaded) {
            Object object;
            Object object2;
            this.traceOn = 0;
            String string = null;
            String string2 = null;
            String string3 = null;
            try {
                string2 = System.getProperty("ibm.db2.instance.path");
                if (string2 != null) {
                    object2 = System.getProperty("file.separator");
                    string3 = System.getProperty("os.name");
                    if (object2 != null && object2.equals("/")) {
                        string = String.valueOf(string2) + "/" + libpath_unix + "/";
                        string = string3 != null && string3.startsWith("HP-UX") ? String.valueOf(string) + HPlibraryName : String.valueOf(string) + libraryName;
                        System.load(string);
                    } else {
                        string = String.valueOf(string2) + "\\";
                        if (string3 != null && string3.startsWith("OS/2")) {
                            string = String.valueOf(string) + "dll\\db2jdbc";
                        } else {
                            string = String.valueOf(string) + "bin\\";
                            object = System.getProperty("java.vendor");
                            string = object != null && ((String)object).toLowerCase().indexOf("microsoft") != -1 ? String.valueOf(string) + MSDLLName : String.valueOf(string) + DLLName;
                        }
                        string = String.valueOf(string) + ".dll";
                        System.load(string);
                    }
                } else {
                    object2 = System.getProperty("java.vendor");
                    if (object2 != null && object2.toLowerCase().indexOf("microsoft") != -1) {
                        string = MSDLLName;
                        System.loadLibrary(MSDLLName);
                    } else {
                        string = DLLName;
                        System.loadLibrary(DLLName);
                    }
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                String[] stringArray = new String[]{DLLName};
                String string4 = new DB2Messages().getString("0646", stringArray);
                DriverManager.println(string4);
                DriverManager.println(unsatisfiedLinkError.toString());
                throw new SQLException(unsatisfiedLinkError.toString());
            }
            int n = this.SQLAllocEnv();
            if (n != 0) {
                object2 = new String[]{String.valueOf(n)};
                object = new DB2Messages().getString("0647", (String[])object2);
                DriverManager.println((String)object);
                throw new SQLException((String)object);
            }
            loaded = true;
            if (this.traceOn == 1) {
                object2 = new Integer(0);
                object = new Integer(0);
                Integer n2 = new Integer(0);
                String string5 = this.SQLGetTracePath((Integer)object2, (Integer)object, n2);
                if (n2 != 0) {
                    DB2Trace.setTraceFlush(true);
                }
                if (object2.intValue() == 0 && string5 != null) {
                    DB2Trace.setTracePath(string5);
                }
                if (!DB2Trace.isInitialized()) {
                    DB2Trace dB2Trace = new DB2Trace((Integer)object);
                    DB2Trace.methodEntry(this, "DB2Driver()");
                    if (string2 != null) {
                        dB2Trace.println("OS            : " + string3);
                        dB2Trace.println("Library loaded: " + string);
                    } else {
                        dB2Trace.println("Library loaded: " + string);
                    }
                    dB2Trace.println("DB2Driver: JDBC 2.0,  BuildLevel: n020616");
                    DB2Trace.methodExit(this, "DB2Driver()");
                }
            }
        }
    }

    protected native int SQLAllocEnv();

    protected native int SQLFreeEnv();

    protected native String SQLGetTracePath(Integer var1, Integer var2, Integer var3);

    public boolean acceptsURL(String string) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "acceptsURL (" + string + ")");
        }
        String string2 = new String();
        String string3 = new String();
        String string4 = new String();
        int n = string.indexOf(58);
        string2 = string.substring(0, n);
        int n2 = string.indexOf(58, n + 1);
        string3 = string.substring(n + 1, n2);
        string4 = string.substring(n2 + 1);
        boolean bl = string2.equalsIgnoreCase("JDBC") && string3.equalsIgnoreCase("DB2") && !string4.startsWith("//");
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "acceptsURL", bl);
        }
        return bl;
    }

    public Connection connect() throws SQLException {
        Properties properties = new Properties();
        ((Hashtable)properties).put("language", language);
        if (DB2Trace.TraceOn) {
            DB2Trace.getTraceObj().println("DB2Driver - connect()");
        }
        return new DB2Connection(properties, this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Connection connect(String string, Properties properties) throws SQLException {
        Connection connection;
        block9: {
            DB2Connection dB2Connection;
            block8: {
                Connection connection2;
                block7: {
                    Connection connection3;
                    block6: {
                        try {
                            if (DB2Trace.TraceOn) {
                                DB2Trace.methodEntry(this, "connect( " + string + ",  info )");
                            }
                            String string2 = new String();
                            String string3 = new String();
                            String string4 = new String();
                            int n = string.indexOf(58);
                            if (n == -1) {
                                connection3 = null;
                                Object var5_11 = null;
                                if (!DB2Trace.TraceOn) return connection3;
                                break block6;
                            }
                            string2 = string.substring(0, n);
                            int n2 = string.indexOf(58, n + 1);
                            if (n2 == -1) {
                                connection2 = null;
                                break block7;
                            }
                            string3 = string.substring(n + 1, n2);
                            string4 = string.substring(n2 + 1);
                            if (string2.equalsIgnoreCase("JDBC") && string3.equalsIgnoreCase("DB2") && !string4.startsWith("//")) {
                                ((Hashtable)properties).put("language", language);
                                dB2Connection = new DB2Connection(string4, properties, this);
                                break block8;
                            }
                            connection = null;
                            break block9;
                        }
                        catch (Throwable throwable) {
                            Object var5_15 = null;
                            if (!DB2Trace.TraceOn) throw throwable;
                            DB2Trace.methodExit(this, "connect");
                            throw throwable;
                        }
                    }
                    DB2Trace.methodExit(this, "connect");
                    return connection3;
                }
                Object var5_12 = null;
                if (!DB2Trace.TraceOn) return connection2;
                DB2Trace.methodExit(this, "connect");
                return connection2;
            }
            Object var5_13 = null;
            if (!DB2Trace.TraceOn) return dB2Connection;
            DB2Trace.methodExit(this, "connect");
            return dB2Connection;
        }
        Object var5_14 = null;
        if (!DB2Trace.TraceOn) return connection;
        DB2Trace.methodExit(this, "connect");
        return connection;
    }

    public void finalize() throws SQLException {
        if (this == ourDriver) {
            this.SQLFreeEnv();
            ourDriver = null;
            loaded = false;
            language = "C";
        }
    }

    public native String getDLLVersion();

    public int getMajorVersion() {
        return 7;
    }

    public int getMinorVersion() {
        return 1;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[]{new DriverPropertyInfo("user", null), new DriverPropertyInfo("password", null)};
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equals("user")) {
                driverPropertyInfoArray[0].value = properties.getProperty("user");
                continue;
            }
            if (!string2.equals("password")) continue;
            driverPropertyInfoArray[1].value = properties.getProperty("password");
        }
        return driverPropertyInfoArray;
    }

    public int getRelease() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public static void setLanguage(String string) {
        language = string;
    }

    public String toString() {
        return "DB2Driver: JDBC 2.0 n020616";
    }
}

