/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2CharReader;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2InputStream;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.SQLException;

public class DB2Clob
implements Clob {
    protected int locator;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected int lobType;
    protected boolean closed = false;
    protected DB2CharReader reader;
    protected String data = null;

    public DB2Clob(DB2Statement dB2Statement, int n, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2Clob( stmt, " + n + ", " + n2 + " )");
            }
            this.locator = n;
            this.lobType = n2;
            this.connection = (DB2Connection)dB2Statement.getConnection();
            this.reader = new DB2CharReader(dB2Statement, n2, n);
            this.statement = this.connection.getInputStreamStmt();
        }
        finally {
            Object var5_4 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "DB2Clob()");
            }
        }
    }

    public DB2Clob(String string) {
        this.data = string == null ? new String() : string;
    }

    protected native int SQLGetClobPosition(Integer var1, int var2, int var3, int var4, int var5);

    protected native int SQLGetStrPosition(Integer var1, int var2, String var3, int var4, int var5);

    public void close() {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "close()");
            }
            if (!this.closed && this.reader != null) {
                this.reader.close();
            }
            this.closed = true;
        }
        finally {
            Object var2_1 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "close()");
            }
        }
    }

    public void finalize() {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "finalize()");
            }
            this.close();
        }
        finally {
            Object var2_1 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "finalize()");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getAsciiStream() throws SQLException {
        DB2InputStream dB2InputStream;
        block5: {
            ByteArrayInputStream byteArrayInputStream;
            block4: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getAsciiStream()");
                    }
                    if (this.reader == null) {
                        byteArrayInputStream = new ByteArrayInputStream(this.data.getBytes());
                        Object var3_3 = null;
                        if (!DB2Trace.TraceOn) return byteArrayInputStream;
                        break block4;
                    }
                    dB2InputStream = new DB2InputStream(this.statement, this.locator, this.lobType);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit((Object)this, "getAsciiStream()", "InputStream");
                    throw throwable;
                }
            }
            DB2Trace.methodExit((Object)this, "getAsciiStream()", "InputStream");
            return byteArrayInputStream;
        }
        Object var3_4 = null;
        if (!DB2Trace.TraceOn) return dB2InputStream;
        DB2Trace.methodExit((Object)this, "getAsciiStream()", "InputStream");
        return dB2InputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Reader getCharacterStream() throws SQLException {
        DB2CharReader dB2CharReader;
        block5: {
            StringReader stringReader;
            block4: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getCharacterStream()");
                    }
                    if (this.reader == null) {
                        stringReader = new StringReader(this.data);
                        Object var3_3 = null;
                        if (!DB2Trace.TraceOn) return stringReader;
                        break block4;
                    }
                    dB2CharReader = this.reader;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit((Object)this, "getCharacterStream()", "Reader");
                    throw throwable;
                }
            }
            DB2Trace.methodExit((Object)this, "getCharacterStream()", "Reader");
            return stringReader;
        }
        Object var3_4 = null;
        if (!DB2Trace.TraceOn) return dB2CharReader;
        DB2Trace.methodExit((Object)this, "getCharacterStream()", "Reader");
        return dB2CharReader;
    }

    int getLocator() {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getLocator()");
            DB2Trace.methodExit((Object)this, "getLocator()", this.locator);
        }
        return this.locator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getSubString(long l, int n) throws SQLException {
        String string;
        String string2 = null;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getSubString( " + l + ", " + n + " )");
            }
            if (this.reader == null) {
                if (l > (long)this.data.length() || n == 0) {
                    string2 = new String();
                } else if (l == 1L && n >= this.data.length()) {
                    string2 = this.data;
                } else {
                    n = (int)Math.min((long)this.data.length() - l + 1L, (long)n);
                    string2 = this.data.substring((int)(--l), (int)l + n);
                }
            } else if (this.reader.markSupported()) {
                try {
                    this.reader.moveTo((int)l);
                    char[] cArray = new char[n];
                    int n2 = this.reader.read(cArray);
                    string2 = new String(cArray, 0, n2);
                }
                catch (IOException iOException) {
                    throw new SQLException(iOException.toString());
                }
            } else {
                this.connection.sqlExcptGen.throwNoRandomAccess();
            }
            string = string2;
            Object var7_8 = null;
            if (!DB2Trace.TraceOn) return string;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getSubString()", string2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getSubString()", string2);
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long length() throws SQLException {
        long l;
        long l2 = 0L;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "length()");
            }
            l2 = this.reader == null ? (long)this.data.length() : this.reader.getLength();
            l = l2;
            Object var6_3 = null;
            if (!DB2Trace.TraceOn) return l;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "length()", l2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "length()", l2);
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long position(String string, long l) throws SQLException {
        long l2;
        int n = -1;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "position( " + string + ", " + l + " )");
            }
            if (this.reader == null) {
                n = this.data.indexOf(string, (int)l - 1);
                if (n != -1) {
                    ++n;
                }
            } else {
                Integer n2 = new Integer(0);
                DB2Statement dB2Statement = this.statement;
                synchronized (dB2Statement) {
                    n = this.SQLGetStrPosition(n2, this.statement.statementHandle, string, (int)l, this.connection.connectionHandle);
                    this.connection.sqlExcptGen.check_return_code(this.statement, (int)n2);
                }
            }
            l2 = n;
            Object var8_7 = null;
            if (!DB2Trace.TraceOn) return l2;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "position()", n);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "position()", n);
        return l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long position(Clob clob, long l) throws SQLException {
        long l2;
        long l3 = -1L;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "position( pattern, " + l + " )");
            }
            if (clob instanceof DB2Clob && ((DB2Clob)clob).reader != null && this.reader != null) {
                Integer n = new Integer(0);
                int n2 = 0;
                DB2Statement dB2Statement = this.statement;
                synchronized (dB2Statement) {
                    n2 = this.SQLGetClobPosition(n, this.statement.statementHandle, ((DB2Clob)clob).getLocator(), (int)l, this.connection.connectionHandle);
                    this.connection.sqlExcptGen.check_return_code(this.statement, (int)n);
                }
                l3 = n2;
            } else {
                String string = clob.getSubString(0L, (int)clob.length());
                l3 = this.position(string, l);
            }
            l2 = l3;
            Object var9_9 = null;
            if (!DB2Trace.TraceOn) return l2;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "position()", l3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "position()", l3);
        return l2;
    }
}

