/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app.classloader;

import COM.ibm.db2.app.classloader.ClassLoaderResource;
import COM.ibm.db2.app.classloader.ClassProvider;
import COM.ibm.db2.app.classloader.JarResource;
import COM.ibm.db2.app.util.InvalidationException;
import COM.ibm.db2.app.util.Validatable;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import sun.tools.jar.JarVerifierStream;

public class JarFileClassProvider
implements ClassProvider,
Validatable {
    File jarFile;
    long timeStamp;
    private static char jarSeparatorChar = (char)47;

    public JarFileClassProvider(File file) {
        if (!file.isFile()) {
            throw new IllegalArgumentException(String.valueOf(file.getAbsolutePath()) + " is not a valid jar file");
        }
        this.jarFile = file;
        this.timeStamp = this.jarFile.lastModified();
    }

    public String getClassPath() {
        return this.jarFile.getAbsolutePath();
    }

    public byte[] getClassBytes(String string) {
        FileInputStream fileInputStream = null;
        byte[] byArray = null;
        try {
            fileInputStream = new FileInputStream(this.jarFile);
            JarVerifierStream jarVerifierStream = new JarVerifierStream((InputStream)fileInputStream);
            byArray = this.getClassBytesFromJar(jarVerifierStream, string);
            jarVerifierStream.close();
        }
        catch (Throwable throwable) {}
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {}
        return byArray;
    }

    public ClassLoaderResource getResource(String string) {
        try {
            if (this.hasResource(string)) {
                return new JarResource(this.jarFile, string);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getAbsoluteResourcePath(String string) {
        if (this.hasResource(string)) {
            return this.jarFile.getAbsolutePath();
        }
        return null;
    }

    public boolean hasResource(String string) {
        FileInputStream fileInputStream = null;
        boolean bl = false;
        try {
            if (string.startsWith("/")) {
                string = string.substring(1, string.length());
            }
            ZipEntry zipEntry = null;
            bl = false;
            fileInputStream = new FileInputStream(this.jarFile);
            JarVerifierStream jarVerifierStream = new JarVerifierStream((InputStream)fileInputStream);
            while (!bl && (zipEntry = jarVerifierStream.getNextEntry()) != null) {
                String string2 = zipEntry.getName();
                if (!string2.equals(string)) continue;
                bl = true;
            }
            jarVerifierStream.closeEntry();
        }
        catch (Exception exception) {}
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {}
        return bl;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " " + this.jarFile.getAbsolutePath();
    }

    public void validate() throws InvalidationException {
        if (!this.jarFile.exists()) {
            throw new InvalidationException("JarFileClassProvider is invalid", String.valueOf(this.jarFile.getAbsolutePath()) + " has been deleted");
        }
        if (this.timeStamp != this.jarFile.lastModified()) {
            throw new InvalidationException("JarFileClassProvider is invalid", String.valueOf(this.jarFile.getAbsolutePath()) + " has been updated");
        }
    }

    public boolean isValid() {
        try {
            this.validate();
            return true;
        }
        catch (InvalidationException invalidationException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getClassBytesFromJar(JarVerifierStream jarVerifierStream, String string) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream;
        block13: {
            byte[] byArray2;
            block12: {
                byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    try {
                        String string2 = String.valueOf(string.replace('.', jarSeparatorChar)) + ".class";
                        InputStream inputStream = JarFileClassProvider.getResourceFromJar(jarVerifierStream, string2);
                        if (inputStream == null) {
                            byArray2 = null;
                            Object var6_9 = null;
                            break block12;
                        }
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                        byte[] byArray3 = new byte[4096];
                        int n = 0;
                        while (true) {
                            if ((n = bufferedInputStream.read(byArray3, 0, 4096)) == -1) {
                                byArray3 = byteArrayOutputStream.toByteArray();
                                n = byArray3.length;
                                byArray = byArray3;
                                break block13;
                            }
                            byteArrayOutputStream.write(byArray3, 0, n);
                        }
                    }
                    catch (IOException iOException) {
                        byte[] byArray4 = null;
                        Object var6_11 = null;
                        try {
                            if (byteArrayOutputStream == null) return byArray4;
                            ((OutputStream)byteArrayOutputStream).close();
                            return byArray4;
                        }
                        catch (IOException iOException2) {}
                        return byArray4;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_12 = null;
                    try {}
                    catch (IOException iOException) {
                        throw throwable;
                    }
                    if (byteArrayOutputStream == null) throw throwable;
                    ((OutputStream)byteArrayOutputStream).close();
                    throw throwable;
                }
            }
            try {}
            catch (IOException iOException) {}
            if (byteArrayOutputStream == null) return byArray2;
            ((OutputStream)byteArrayOutputStream).close();
            return byArray2;
        }
        Object var6_10 = null;
        try {}
        catch (IOException iOException) {}
        if (byteArrayOutputStream == null) return byArray;
        ((OutputStream)byteArrayOutputStream).close();
        return byArray;
    }

    static InputStream getResourceFromJar(JarVerifierStream jarVerifierStream, String string) throws IOException {
        if (string.startsWith("/")) {
            string = string.substring(1, string.length());
        }
        ZipEntry zipEntry = null;
        while ((zipEntry = jarVerifierStream.getNextEntry()) != null) {
            String string2 = zipEntry.getName();
            if (string2.equals(string)) {
                return jarVerifierStream;
            }
            jarVerifierStream.closeEntry();
        }
        return null;
    }
}

