/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2CharReader;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2InputStream;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2Statement;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.SQLException;

public class DB2Clob
implements Clob {
    protected int locator;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected int lobType;
    protected boolean closed = false;
    protected DB2CharReader reader;
    protected DB2Request db2req;
    protected String data = null;

    public DB2Clob(DB2Statement dB2Statement, int n, int n2) throws SQLException {
        this.connection = (DB2Connection)dB2Statement.getConnection();
        this.locator = n;
        this.lobType = n2;
        this.reader = new DB2CharReader(dB2Statement, n, n2);
        this.statement = this.connection.getInputStreamStmt();
        this.db2req = this.statement.db2req;
    }

    public DB2Clob(String string) {
        this.data = string == null ? new String() : string;
    }

    protected int SQLGetPosition(String string, int n) throws SQLException {
        int n2 = -1;
        try {
            DB2Statement dB2Statement = this.statement;
            synchronized (dB2Statement) {
                this.db2req.write((short)206);
                this.db2req.write(this.statement.getHandle());
                this.db2req.write(this.locator);
                this.db2req.write(this.lobType);
                this.db2req.write(string);
                this.db2req.write(n);
                this.db2req.sendAndRecv();
                int n3 = this.db2req.readInt();
                this.connection.sqlExcptGen.check_return_code(this.statement, n3);
                n2 = this.db2req.readInt();
            }
        }
        catch (IOException iOException) {
            this.connection.sqlExcptGen.throw_IOException(iOException);
        }
        return n2;
    }

    public void close() {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "close()");
            }
            if (!this.closed && this.reader != null) {
                this.reader.close();
            }
            this.closed = true;
        }
        finally {
            Object var2_1 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "close()");
            }
        }
    }

    public void finalize() {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "finalize()");
            }
            this.close();
        }
        finally {
            Object var2_1 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "finalize()");
            }
        }
    }

    public InputStream getAsciiStream() throws SQLException {
        if (this.reader == null) {
            return new ByteArrayInputStream(this.data.getBytes());
        }
        return new DB2InputStream(this.statement, this.locator, this.lobType, false);
    }

    public Reader getCharacterStream() throws SQLException {
        if (this.reader == null) {
            return new StringReader(this.data);
        }
        return this.reader;
    }

    int getLocator() {
        return this.locator;
    }

    public String getSubString(long l, int n) throws SQLException {
        String string = null;
        if (this.reader == null) {
            if (l > (long)this.data.length() || n == 0) {
                string = new String();
            } else if (l == 1L && n >= this.data.length()) {
                string = this.data;
            } else {
                n = (int)Math.min((long)this.data.length() - l + 1L, (long)n);
                string = this.data.substring((int)(--l), (int)l + n);
            }
        } else {
            this.reader.moveTo((int)l);
            char[] cArray = new char[n];
            int n2 = 0;
            try {
                n2 = this.reader.read(cArray, 0, n);
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString());
            }
            string = new String(cArray, 0, n2);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long length() throws SQLException {
        long l;
        long l2 = 0L;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "length()");
            }
            l2 = this.reader == null ? (long)this.data.length() : this.reader.getLength();
            l = l2;
            Object var6_3 = null;
            if (!DB2Trace.TraceOn) return l;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "length()", l2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "length()", l2);
        return l;
    }

    public long position(String string, long l) throws SQLException {
        int n = -1;
        if (this.reader == null) {
            n = this.data.indexOf(string, (int)l - 1);
            if (n != -1) {
                ++n;
            }
        } else {
            n = this.SQLGetPosition(string, (int)l);
        }
        return n;
    }

    public long position(Clob clob, long l) throws SQLException {
        if (clob instanceof DB2Clob && ((DB2Clob)clob).reader != null && this.reader != null) {
            DB2Clob dB2Clob = (DB2Clob)clob;
            int n = dB2Clob.getLocator();
            int n2 = -1;
            try {
                DB2Statement dB2Statement = this.statement;
                synchronized (dB2Statement) {
                    this.db2req.write((short)208);
                    this.db2req.write(this.statement.getHandle());
                    this.db2req.write(this.locator);
                    this.db2req.write(this.lobType);
                    this.db2req.write(n);
                    this.db2req.write((int)l);
                    this.db2req.sendAndRecv();
                    int n3 = this.db2req.readInt();
                    this.connection.sqlExcptGen.check_return_code(this.statement, n3);
                    n2 = this.db2req.readInt();
                }
            }
            catch (IOException iOException) {
                this.connection.sqlExcptGen.throw_IOException(iOException);
            }
            return n2;
        }
        return this.position(clob.getSubString(0L, (int)clob.length()), l);
    }
}

