/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Driver;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Locale;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class DB2BaseDataSource
implements Referenceable,
Serializable {
    static final long serialVersionUID = -3058333050951489179L;
    private transient PrintWriter log = null;
    private int timeout = 0;
    private static final String DLLName = "db2jdbc";
    private static final String MSDLLName = "db2jms";
    private transient int traceOn = 0;
    private transient int pid = 0;
    private transient int flush = 0;
    private transient String tracePathName = null;
    protected String databaseName = null;
    protected String serverName = null;
    protected int portNumber = 6789;
    protected String description = null;
    protected transient String password = null;
    protected transient String user = null;
    protected String connectionAttribute = null;
    protected String language = null;

    public DB2BaseDataSource() {
        Locale locale = Locale.getDefault();
        String string = locale.getCountry();
        String string2 = locale.getLanguage();
        this.language = String.valueOf(string2.substring(0, 1).toUpperCase()) + string2.substring(1, 2) + "_" + string;
    }

    protected native int SQLAllocEnv();

    protected native int SQLFreeEnv();

    protected native int SQLGetTraceAttributes();

    public String getConnectionAttribute() {
        return this.connectionAttribute;
    }

    public native String getDLLVersion();

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLanguage() {
        return this.language;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.log;
    }

    public int getLoginTimeout() throws SQLException {
        return this.timeout;
    }

    public String getPassword() {
        return "";
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), String.valueOf(this.getClass().getName()) + "Factory", null);
        reference.add(new StringRefAddr("databaseName", this.databaseName));
        reference.add(new StringRefAddr("serverName", this.serverName));
        reference.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
        return reference;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getUser() {
        return this.user;
    }

    protected boolean isLoaded() {
        return DB2Driver.loaded;
    }

    protected void loadDLL() throws SQLException {
        try {
            String string = System.getProperty("java.vendor").toLowerCase();
            if (string == null) {
                System.loadLibrary(DLLName);
            } else if (string.indexOf("microsoft") != -1) {
                System.loadLibrary(MSDLLName);
            } else {
                System.loadLibrary(DLLName);
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new SQLException(unsatisfiedLinkError.toString());
        }
        int n = this.SQLAllocEnv();
        if (n != 0) {
            throw new SQLException("SQLAllocEnv() Error: rc = " + n);
        }
        if (this.traceOn == 1) {
            int n2 = this.SQLGetTraceAttributes();
            if (this.flush == 0) {
                DB2Trace.setTraceFlush(false);
            }
            if (n2 == 0 && this.tracePathName != null) {
                DB2Trace.setTracePath(this.tracePathName);
            }
            if (!DB2Trace.isInitialized()) {
                DB2Trace dB2Trace = new DB2Trace(this.pid);
            }
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "loadDLL()");
        }
        DB2Driver.loaded = true;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "loadDLL()");
        }
    }

    void printToLog(String string) {
        if (this.log != null) {
            this.log.println(string);
        }
    }

    public void setConnectionAttribute(String string) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "setConnectionAttribute( " + string + " )");
        }
        this.connectionAttribute = string;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setConnectionAttribute()");
        }
    }

    public void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setLanguage(String string) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "setLanguage( " + string + " )");
        }
        this.language = string;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setLanguage()");
        }
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.log = printWriter;
    }

    public void setLoginTimeout(int n) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "setLoginTimeout( " + n + " )");
        }
        this.timeout = n;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setLoginTimeout()");
        }
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setPortNumber(int n) {
        this.portNumber = n;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = "class               = " + this.getClass().getName();
        string2 = String.valueOf(string2) + string + "serverName          =";
        if (this.serverName != null) {
            string2 = String.valueOf(string2) + " " + this.serverName;
        }
        string2 = String.valueOf(string2) + string + "portNumber          = " + this.portNumber;
        string2 = String.valueOf(string2) + "\ndatabaseName        =";
        if (this.databaseName != null) {
            string2 = String.valueOf(string2) + " " + this.databaseName;
        }
        string2 = String.valueOf(string2) + string + "user                =";
        if (this.user != null) {
            string2 = String.valueOf(string2) + " " + this.user;
        }
        string2 = String.valueOf(string2) + string + "password            =";
        if (this.password != null) {
            string2 = String.valueOf(string2) + "XXXXXXX";
        }
        string2 = String.valueOf(string2) + string + "connectionAttribute =";
        if (this.connectionAttribute != null) {
            string2 = String.valueOf(string2) + " " + this.connectionAttribute;
        }
        string2 = String.valueOf(string2) + string + "language            =";
        if (this.language != null) {
            string2 = String.valueOf(string2) + " " + this.language;
        }
        return string2;
    }
}

