/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.dbcp.DbcpException;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.jocl.JOCLContentHandler;
import org.apache.commons.pool.ObjectPool;
import org.xml.sax.SAXException;

public class PoolingDriver
implements Driver {
    protected static HashMap _pools;
    protected static String URL_PREFIX;
    protected static int URL_PREFIX_LEN;
    protected static int MAJOR_VERSION;
    protected static int MINOR_VERSION;
    static /* synthetic */ Class class$java$lang$String;

    public synchronized ObjectPool getPool(String name) {
        try {
            return this.getConnectionPool(name);
        }
        catch (Exception e) {
            throw new DbcpException(e);
        }
    }

    protected synchronized ObjectPool getConnectionPool(String name) throws SQLException {
        ObjectPool pool = (ObjectPool)_pools.get(name);
        if (null == pool) {
            InputStream in = this.getClass().getResourceAsStream(String.valueOf(name) + ".jocl");
            if (null != in) {
                JOCLContentHandler jocl = null;
                try {
                    jocl = JOCLContentHandler.parse(in);
                }
                catch (SAXException e) {
                    throw new SQLNestedException("Could not parse configuration file", e);
                }
                catch (IOException e) {
                    throw new SQLNestedException("Could not load configuration file", e);
                }
                if (jocl.getType(0).equals(class$java$lang$String == null ? (class$java$lang$String = PoolingDriver.class$("java.lang.String")) : class$java$lang$String)) {
                    pool = this.getPool((String)jocl.getValue(0));
                    if (null != pool) {
                        this.registerPool(name, pool);
                    }
                } else {
                    pool = ((PoolableConnectionFactory)jocl.getValue(0)).getPool();
                    if (null != pool) {
                        this.registerPool(name, pool);
                    }
                }
            } else {
                throw new SQLException("Configuration file not found");
            }
        }
        return pool;
    }

    public synchronized void registerPool(String name, ObjectPool pool) {
        _pools.put(name, pool);
    }

    public boolean acceptsURL(String url) throws SQLException {
        try {
            return url.startsWith(URL_PREFIX);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (this.acceptsURL(url)) {
            ObjectPool pool = this.getConnectionPool(url.substring(URL_PREFIX_LEN));
            if (null == pool) {
                throw new SQLException("No pool found for " + url + ".");
            }
            try {
                return (Connection)pool.borrowObject();
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new SQLNestedException("Connect failed", e);
            }
        }
        return null;
    }

    public int getMajorVersion() {
        return MAJOR_VERSION;
    }

    public int getMinorVersion() {
        return MINOR_VERSION;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            DriverManager.registerDriver(new PoolingDriver());
        }
        catch (Exception e) {
            // empty catch block
        }
        _pools = new HashMap();
        URL_PREFIX = "jdbc:apache:commons:dbcp:";
        URL_PREFIX_LEN = URL_PREFIX.length();
        MAJOR_VERSION = 1;
        MINOR_VERSION = 0;
    }
}

