/*
 * Decompiled with CFR 0.152.
 */
package com.trs.util;

import com.trs.common.CMyException;
import com.trs.util.CMyFilenameFilter;
import com.trs.util.CMyString;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Timestamp;

public class CMyFile {
    public static boolean fileExists(String _sPathFileName) {
        File file = new File(_sPathFileName);
        return file.exists();
    }

    public static boolean pathExists(String _sPathFileName) {
        String sPath = CMyFile.extractFilePath(_sPathFileName);
        return CMyFile.fileExists(sPath);
    }

    public static String extractFileName(String _sFilePathName) {
        return CMyFile.extractFileName(_sFilePathName, File.separator);
    }

    public static String extractFileName(String _sFilePathName, String _sFileSeparator) {
        int nPos = -1;
        if (_sFileSeparator == null) {
            nPos = _sFilePathName.lastIndexOf(File.separatorChar);
            if (nPos < 0) {
                nPos = _sFilePathName.lastIndexOf(File.separatorChar == '/' ? 92 : 47);
            }
        } else {
            nPos = _sFilePathName.lastIndexOf(_sFileSeparator);
        }
        if (nPos < 0) {
            return _sFilePathName;
        }
        return _sFilePathName.substring(nPos + 1);
    }

    public static String extractHttpFileName(String _sFilePathName) {
        int nPos = _sFilePathName.lastIndexOf("/");
        return _sFilePathName.substring(nPos + 1);
    }

    public static String extractMainFileName(String _sFilePathName) {
        String sFileMame = CMyFile.extractFileName(_sFilePathName);
        int nPos = sFileMame.lastIndexOf(46);
        if (nPos > 0) {
            return sFileMame.substring(0, nPos);
        }
        return sFileMame;
    }

    public static String excludeFileExt(String sFileMame) {
        int nPos = sFileMame.lastIndexOf(46);
        if (nPos > 0) {
            return sFileMame.substring(0, nPos);
        }
        return sFileMame;
    }

    public static String extractFileExt(String _sFilePathName) {
        int nPos = _sFilePathName.lastIndexOf(46);
        return nPos >= 0 ? _sFilePathName.substring(nPos + 1) : "";
    }

    public static String extractFilePath(String _sFilePathName) {
        int nPos = _sFilePathName.lastIndexOf(47);
        if (nPos < 0) {
            nPos = _sFilePathName.lastIndexOf(92);
        }
        return nPos >= 0 ? _sFilePathName.substring(0, nPos + 1) : "";
    }

    public static String toAbsolutePathName(String _sFilePathName) {
        File file = new File(_sFilePathName);
        return file.getAbsolutePath();
    }

    public static String extractFileDrive(String _sFilePathName) {
        int nLen = _sFilePathName.length();
        if (nLen > 2 && _sFilePathName.charAt(1) == ':') {
            return _sFilePathName.substring(0, 2);
        }
        if (nLen > 2 && _sFilePathName.charAt(0) == File.separatorChar && _sFilePathName.charAt(1) == File.separatorChar) {
            int nPos = _sFilePathName.indexOf(File.separatorChar, 2);
            if (nPos >= 0) {
                nPos = _sFilePathName.indexOf(File.separatorChar, nPos + 1);
            }
            return nPos >= 0 ? _sFilePathName.substring(0, nPos) : _sFilePathName;
        }
        return "";
    }

    public static boolean deleteFile(String _sFilePathName) {
        File file = new File(_sFilePathName);
        return file.exists() ? file.delete() : false;
    }

    public static boolean makeDir(String _sDir, boolean _bCreateParentDir) {
        boolean zResult = false;
        File file = new File(_sDir);
        zResult = _bCreateParentDir ? file.mkdirs() : file.mkdir();
        if (!zResult) {
            zResult = file.exists();
        }
        return zResult;
    }

    public static boolean deleteDir(String _sDir, boolean _bDeleteChildren) {
        File file = new File(_sDir);
        if (!file.exists()) {
            return false;
        }
        if (_bDeleteChildren) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                File aFile = files[i];
                if (aFile.isDirectory()) {
                    CMyFile.deleteDir(aFile);
                } else {
                    aFile.delete();
                }
                ++i;
            }
        }
        return file.delete();
    }

    public static boolean deleteDir(String _sPath) {
        File path = new File(_sPath);
        return CMyFile.deleteDir(path);
    }

    public static boolean deleteDir(File _path) {
        if (!_path.exists()) {
            return false;
        }
        if (_path.isDirectory()) {
            File[] files = _path.listFiles();
            int i = 0;
            while (i < files.length) {
                File aFile = files[i];
                if (aFile.isDirectory()) {
                    CMyFile.deleteDir(aFile);
                } else {
                    aFile.delete();
                }
                ++i;
            }
        }
        return _path.delete();
    }

    public static File[] listFiles(String _dir, String _extendName) {
        File fDir = new File(_dir);
        if (_extendName.charAt(0) != '.') {
            _extendName = "." + _extendName;
        }
        File[] Files = fDir.listFiles((FilenameFilter)new CMyFilenameFilter(_extendName));
        return Files;
    }

    public static File[] listSubDirectories(String _dir) {
        File fDir = new File(_dir);
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        File[] files = fDir.listFiles(fileFilter);
        return files;
    }

    public static String readFile(String _sFileName) throws Exception {
        return CMyFile.readFile(_sFileName, CMyString.FILE_WRITING_ENCODING);
    }

    public static String readFile(String _sFileName, String _sEncoding) throws Exception {
        InputStreamReader fileReader = null;
        StringBuffer buffContent = null;
        FileInputStream fis = null;
        BufferedReader buffReader = null;
        if (_sEncoding == null) {
            _sEncoding = "UTF-8";
        }
        try {
            String sLine;
            fis = new FileInputStream(_sFileName);
            buffReader = new BufferedReader(new InputStreamReader((InputStream)fis, _sEncoding));
            while ((sLine = buffReader.readLine()) != null) {
                if (buffContent == null) {
                    buffContent = new StringBuffer();
                } else {
                    buffContent.append("\n");
                }
                buffContent.append(sLine);
            }
            String string = buffContent == null ? "" : buffContent.toString();
            return string;
        }
        catch (FileNotFoundException ex) {
            throw new Exception("\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230(CMyFile.readFile)", ex);
        }
        catch (IOException ex) {
            throw new Exception("\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef(CMyFile.readFile)", ex);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static byte[] readBytesFromFile(String _sFileName) throws Exception {
        FileInputStream fis = null;
        ByteArrayOutputStream bos = null;
        try {
            fis = new FileInputStream(_sFileName);
            byte[] buffer = new byte[1024];
            bos = new ByteArrayOutputStream(2048);
            int nLen = 0;
            while ((nLen = fis.read(buffer)) > 0) {
                bos.write(buffer, 0, nLen);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new Exception("\u8bfb\u53d6\u6587\u4ef6[" + _sFileName + "]\u5931\u8d25\uff01");
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception exception) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean writeFile(String _sFileName, String _sFileContent) throws Exception {
        return CMyFile.writeFile(_sFileName, _sFileContent, CMyString.FILE_WRITING_ENCODING);
    }

    public static boolean writeFile(String _sFileName, String _sFileContent, String _encoding) throws Exception {
        return CMyFile.writeFile(_sFileName, _sFileContent, _encoding, false);
    }

    public static boolean writeFile(String _sFileName, String _sFileContent, String _sFileEncoding, boolean _bWriteUnicodeFlag) throws Exception {
        String sPath = CMyFile.extractFilePath(_sFileName);
        if (!CMyFile.pathExists(sPath)) {
            CMyFile.makeDir(sPath, true);
        }
        String sFileEncoding = CMyString.showNull(_sFileEncoding, CMyString.FILE_WRITING_ENCODING);
        boolean bRet = false;
        FileOutputStream fos = null;
        Writer outWriter = null;
        try {
            try {
                fos = new FileOutputStream(_sFileName);
                outWriter = new OutputStreamWriter((OutputStream)fos, sFileEncoding);
                if (_bWriteUnicodeFlag) {
                    outWriter.write(65279);
                }
                outWriter.write(_sFileContent);
                bRet = true;
            }
            catch (Exception ex) {
                throw new Exception("\u5199\u6587\u4ef6\u9519\u8bef(CMyFile.writeFile)", ex);
            }
        }
        finally {
            try {
                if (outWriter != null) {
                    outWriter.flush();
                    outWriter.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
        return bRet;
    }

    public static boolean writeFile(String _sFileName, InputStream inputStream, String _sFileEncoding) throws Exception {
        String sContent = "";
        StringBuffer buffContent = null;
        BufferedReader buffReader = null;
        try {
            try {
                String sLine;
                buffReader = new BufferedReader(new InputStreamReader(inputStream, CMyString.ENCODING_DEFAULT));
                while ((sLine = buffReader.readLine()) != null) {
                    if (buffContent == null) {
                        buffContent = new StringBuffer();
                    } else {
                        buffContent.append("\n");
                    }
                    buffContent.append(sLine);
                }
                sContent = buffContent == null ? "" : buffContent.toString();
            }
            catch (IOException ex) {
                throw new Exception("\u8bfb\u6570\u636e\u6d41\u65f6\u9519\u8bef", ex);
            }
        }
        finally {
            try {
                if (buffReader != null) {
                    buffReader.close();
                }
            }
            catch (Exception exception) {}
        }
        String sFileEncoding = CMyString.showNull(_sFileEncoding, CMyString.FILE_WRITING_ENCODING);
        FileOutputStream fos = null;
        Writer outWriter = null;
        boolean bRet = false;
        try {
            try {
                fos = new FileOutputStream(_sFileName);
                outWriter = new OutputStreamWriter((OutputStream)fos, sFileEncoding);
                outWriter.write(sContent);
                bRet = true;
            }
            catch (Exception ex) {
                throw new Exception("\u5199\u6587\u4ef6\u9519\u8bef(CMyFile.writeFile)", ex);
            }
        }
        finally {
            try {
                if (outWriter != null) {
                    outWriter.flush();
                    outWriter.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
        return bRet;
    }

    public static boolean appendFile(String _sFileName, String _sAddContent) throws Exception {
        boolean bResult = false;
        RandomAccessFile raf = null;
        try {
            try {
                raf = new RandomAccessFile(_sFileName, "rw");
                raf.seek(raf.length());
                raf.writeBytes(_sAddContent);
                bResult = true;
            }
            catch (Exception ex) {
                throw new Exception("\u5411\u6587\u4ef6\u8ffd\u52a0\u5185\u5bb9\u65f6\u53d1\u751f\u5f02\u5e38(CMyFile.appendFile)", ex);
            }
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception exception) {}
        }
        return bResult;
    }

    public static boolean moveFile(String _sSrcFile, String _sDstFile) throws Exception {
        return CMyFile.moveFile(_sSrcFile, _sDstFile, true);
    }

    public static boolean moveFile(String _sSrcFile, String _sDstFile, boolean _bMakeDirIfNotExists) throws Exception {
        CMyFile.copyFile(_sSrcFile, _sDstFile, _bMakeDirIfNotExists);
        CMyFile.deleteFile(_sSrcFile);
        return false;
    }

    public static boolean copyFile(String _sSrcFile, String _sDstFile) throws Exception {
        return CMyFile.copyFile(_sSrcFile, _sDstFile, true);
    }

    public static boolean copyFile(String _sSrcFile, String _sDstFile, boolean _bMakeDirIfNotExists) throws Exception {
        return CMyFile.copyFile(_sSrcFile, _sDstFile, _bMakeDirIfNotExists, false);
    }

    public static boolean copyFile(String _sSrcFile, String _sDstFile, boolean _bMakeDirIfNotExists, boolean preserveFileDate) throws Exception {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            File srcFile = new File(_sSrcFile);
            File dstFile = new File(_sDstFile);
            if (srcFile.equals(dstFile)) {
                return true;
            }
            try {
                int bytes;
                fis = new FileInputStream(srcFile);
                try {
                    fos = new FileOutputStream(dstFile);
                }
                catch (FileNotFoundException ex) {
                    if (_bMakeDirIfNotExists) {
                        if (!CMyFile.makeDir(CMyFile.extractFilePath(_sDstFile), true)) {
                            throw new Exception("\u4e3a\u76ee\u6807\u6587\u4ef6[" + _sDstFile + "]\u521b\u5efa\u76ee\u5f55\u5931\u8d25\uff01");
                        }
                        fos = new FileOutputStream(_sDstFile);
                    }
                    throw new Exception("\u6307\u5b9a\u76ee\u6807\u6587\u4ef6[" + _sDstFile + "]\u6240\u5728\u76ee\u5f55\u4e0d\u5b58\u5728\uff01", ex);
                }
                byte[] buffer = new byte[4096];
                while ((bytes = fis.read(buffer, 0, 4096)) > 0) {
                    fos.write(buffer, 0, bytes);
                }
                fos.flush();
            }
            catch (FileNotFoundException ex) {
                throw new Exception("\u8981\u590d\u5236\u7684\u539f\u6587\u4ef6[" + _sSrcFile + "]\u6ca1\u6709\u53d1\u73b0(CMyFile.copyFile)", ex);
            }
            catch (IOException ex) {
                throw new Exception("\u590d\u5236\u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38(CMyFile.copyFile)", ex);
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        if (preserveFileDate) {
            new File(_sDstFile).setLastModified(new File(_sSrcFile).lastModified());
        }
        return true;
    }

    public static void copyFileDir(String _fromFileDir, String _toFileDir, boolean _bIncludeCurrDir) throws Exception {
        if (CMyString.isEmpty(_fromFileDir) || CMyString.isEmpty(_toFileDir)) {
            return;
        }
        File fFromFile = new File(_fromFileDir);
        File fToFile = new File(_toFileDir);
        if (fFromFile.isFile() || fToFile.isFile()) {
            throw new CMyException("\u6e90\u76ee\u5f55\u548c\u76ee\u6807\u76ee\u5f55\u90fd\u4e0d\u80fd\u662f\u6587\u4ef6\uff01");
        }
        File[] files = fFromFile.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        _fromFileDir = CMyString.setStrEndWith(_fromFileDir, File.separatorChar);
        _toFileDir = CMyString.setStrEndWith(_toFileDir, File.separatorChar);
        if (_bIncludeCurrDir) {
            File parentFile = new File(String.valueOf(_toFileDir) + fFromFile.getName());
            if (!parentFile.exists()) {
                parentFile.mkdir();
            }
            _toFileDir = String.valueOf(_toFileDir) + fFromFile.getName();
            _toFileDir = String.valueOf(_toFileDir) + File.separatorChar;
        }
        int i = 0;
        while (i < files.length) {
            File aFile = files[i];
            if (aFile != null && !"Thumbs.db".equals(aFile.getName())) {
                if (!aFile.isFile()) {
                    String sToFileDirPath = String.valueOf(_toFileDir) + aFile.getName();
                    if (!CMyFile.fileExists(sToFileDirPath)) {
                        CMyFile.makeDir(sToFileDirPath, true);
                    }
                    CMyFile.copyFileDir(String.valueOf(_fromFileDir) + aFile.getName(), sToFileDirPath, false);
                } else {
                    try {
                        CMyFile.copyFile(String.valueOf(_fromFileDir) + aFile.getName(), String.valueOf(_toFileDir) + aFile.getName(), true);
                    }
                    catch (Exception e) {
                        System.out.println(e.getStackTrace());
                    }
                }
            }
            ++i;
        }
    }

    public static String mapResouceFullPath(String _resource) throws CMyException {
        URL url = Thread.currentThread().getContextClassLoader().getResource(_resource);
        if (url == null) {
            throw new CMyException("\u6587\u4ef6[" + _resource + "]\u6ca1\u6709\u627e\u5230\uff01");
        }
        String sPath = null;
        try {
            sPath = url.getFile();
            if (sPath.indexOf(37) >= 0) {
                String enc = System.getProperty("file.encoding", "GBK");
                sPath = URLDecoder.decode(url.getFile(), enc);
            }
        }
        catch (Exception ex) {
            throw new CMyException("\u6587\u4ef6[" + url.getFile() + "]\u8f6c\u6362\u5931\u8d25\uff01", (Throwable)ex);
        }
        return sPath;
    }

    public static String mapResouceFullPath(String _resource, Class _currClass) throws CMyException {
        URL url = _currClass.getResource(_resource);
        if (url == null) {
            throw new CMyException("\u6587\u4ef6[" + _resource + "]\u6ca1\u6709\u627e\u5230\uff01");
        }
        String sPath = null;
        try {
            sPath = url.getFile();
            if (sPath.indexOf(37) >= 0) {
                String enc = System.getProperty("file.encoding", "GBK");
                sPath = URLDecoder.decode(url.getFile(), enc);
            }
        }
        catch (Exception ex) {
            throw new CMyException("\u6587\u4ef6[" + url.getFile() + "]\u8f6c\u6362\u5931\u8d25\uff01", (Throwable)ex);
        }
        return sPath;
    }

    public static String getTempFileName() {
        String sTime = new Timestamp(System.currentTimeMillis()).toString();
        sTime = sTime.substring(0, 19).replace('-', '.').replace(' ', '_').replace(':', '.');
        StringBuffer sb = new StringBuffer(256);
        sb.append("__deleted_");
        sb.append(sTime);
        sb.append("__");
        return sb.toString();
    }

    public static void searchAndReplace(String[] toSearch, String[] replaceWith, String fileName, String fileEncoding) throws CMyException {
        StringBuffer out = new StringBuffer();
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), fileEncoding));
                String str = new String();
                boolean zFirstLine = true;
                while ((str = in.readLine()) != null) {
                    if (zFirstLine) {
                        char ch;
                        zFirstLine = false;
                        if (fileEncoding != null && "UTF-8".equals(fileEncoding.toUpperCase()) && ((ch = str.charAt(0)) == '\ufeff' || ch == '\ufffe')) {
                            str = str.substring(1);
                        }
                    }
                    int i = 0;
                    while (i < str.length()) {
                        boolean isReplaced = false;
                        int j = 0;
                        while (j < toSearch.length) {
                            if (str.startsWith(toSearch[j], i)) {
                                out.append(replaceWith[j]);
                                i += toSearch[j].length();
                                isReplaced = true;
                                break;
                            }
                            ++j;
                        }
                        if (isReplaced) continue;
                        out.append(str.charAt(i));
                        ++i;
                    }
                    out.append(System.getProperty("line.separator"));
                }
            }
            catch (Exception e) {
                throw new CMyException(24, "\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u65f6\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        Writer w = null;
        try {
            try {
                w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), fileEncoding));
                w.write(out.toString());
            }
            catch (Exception e) {
                throw new CMyException(25, "\u5199\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void main(String[] agrs) throws Exception {
        CMyFile.copyFileDir("D:\\testfile", "D:\\testfileto", false);
    }
}

