/*
 * Decompiled with CFR 0.152.
 */
package com.trs.autodeploy.tools;

import com.trs.autodeploy.tools.AbsSqlFileProcessor;
import com.trs.autodeploy.tools.DB2Processor;
import com.trs.autodeploy.tools.MySQLProcessor;
import com.trs.autodeploy.tools.OracleProcessor;
import com.trs.autodeploy.tools.SQLServerProcessor;
import com.trs.autodeploy.tools.SybaseProcessor;
import com.trs.util.CMyFile;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Map;

public class SQLProcessTool {
    private String m_sSQLFilePath = "";
    private static final Map PROCESSORS = new HashMap(8);

    static {
        PROCESSORS.put("sqlserver", new SQLServerProcessor());
        PROCESSORS.put("sybase", new SybaseProcessor());
        PROCESSORS.put("oracle", new OracleProcessor());
        PROCESSORS.put("db2", new DB2Processor());
        PROCESSORS.put("mysql", new MySQLProcessor());
        PROCESSORS.put("kingbase", new OracleProcessor());
    }

    public static void main(String[] args) {
        try {
            String sModify;
            String sSQLFilePath = "E:\\work\\tempfiles";
            boolean bValid = false;
            if (args.length > 0) {
                sSQLFilePath = args[0];
            }
            if (args.length > 1 && "bValid".equals(sModify = args[1])) {
                bValid = true;
            }
            SQLProcessTool tool = new SQLProcessTool(sSQLFilePath);
            System.out.println("=====================================");
            if (bValid) {
                System.out.println("---Valid sql-------");
                tool.detect();
            } else {
                System.out.println("=========modify sql==========");
                System.out.println("the path is " + sSQLFilePath);
                tool.modifySQL();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private SQLProcessTool() {
    }

    public SQLProcessTool(String _sSQLFilePath) {
        this.m_sSQLFilePath = _sSQLFilePath;
    }

    public void detect() throws Exception {
        File dir = new File(this.m_sSQLFilePath);
        if (!dir.exists()) {
            throw new Exception("\u6307\u5b9a\u7684\u8def\u5f84\u3010" + this.m_sSQLFilePath + "\u3011\u4e0d\u5b58\u5728");
        }
        dir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                String sPathName = pathname.getAbsolutePath();
                if (pathname.isDirectory()) {
                    pathname.listFiles(this);
                } else if (pathname.getName().endsWith(".sql")) {
                    String parent = pathname.getParentFile().getName();
                    System.out.println("========pathname======" + pathname);
                    AbsSqlFileProcessor processor = SQLProcessTool.this.getSqlProcessor(parent);
                    try {
                        String sDetectResult = processor.detectSQL(sPathName);
                        if (sDetectResult.length() > 0) {
                            String sLogFile = String.valueOf(sPathName) + "_detect.log";
                            System.out.println(String.valueOf(parent) + "\u6570\u636e\u5e93\u68c0\u6d4b\u51fa\u6709\u95ee\u9898\u7684SQL\uff0c\u95ee\u9898\u53caSQL\u8bed\u53e5\u5c06\u8f93\u51fa\u5728\u6587\u4ef6\u3010" + sLogFile + "\u3011\u4e2d");
                            CMyFile.writeFile(sLogFile, sDetectResult);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("detect failed: " + pathname);
                        e.printStackTrace(System.out);
                    }
                }
                return false;
            }
        });
    }

    public void modifySQL() throws Exception {
        File dir = new File(this.m_sSQLFilePath);
        if (!dir.exists()) {
            throw new Exception("\u6307\u5b9a\u7684\u8def\u5f84\u3010" + this.m_sSQLFilePath + "\u3011\u4e0d\u5b58\u5728");
        }
        dir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                String sPathName = pathname.getAbsolutePath();
                if (pathname.isDirectory()) {
                    pathname.listFiles(this);
                } else if (pathname.getName().endsWith(".sql")) {
                    String parent = pathname.getParentFile().getName();
                    AbsSqlFileProcessor processor = SQLProcessTool.this.getSqlProcessor(parent);
                    try {
                        CMyFile.copyFile(sPathName, String.valueOf(CMyFile.excludeFileExt(sPathName)) + "_bak.sql");
                        String sModifyResult = processor.modifySQL(sPathName);
                        CMyFile.writeFile(sPathName, sModifyResult);
                    }
                    catch (Exception e) {
                        System.out.println("modify failed: " + pathname);
                        e.printStackTrace(System.out);
                    }
                }
                return false;
            }
        });
    }

    AbsSqlFileProcessor getSqlProcessor(String _sName) {
        AbsSqlFileProcessor sqlProcessor = (AbsSqlFileProcessor)PROCESSORS.get(_sName = _sName.toLowerCase());
        if (sqlProcessor != null) {
            return sqlProcessor;
        }
        throw new RuntimeException("No processor for :" + _sName);
    }
}

