/*
 * Decompiled with CFR 0.152.
 */
package com.trs.autodeploy.tools;

import com.trs.autodeploy.tools.AbsSqlProcessor;
import com.trs.autodeploy.tools.DB2;
import com.trs.autodeploy.tools.KingBase;
import com.trs.autodeploy.tools.MySQL;
import com.trs.autodeploy.tools.Oracle;
import com.trs.autodeploy.tools.SQLServer;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Map;

public class SQLIfUtil {
    private static final Map PROCESSORS = new HashMap(8);

    static {
        PROCESSORS.put("sqlserver", new SQLServer());
        PROCESSORS.put("sybase", new SQLServer());
        PROCESSORS.put("oracle", new Oracle());
        PROCESSORS.put("db2", new DB2());
        PROCESSORS.put("mysql", new MySQL());
        PROCESSORS.put("kingbase", new KingBase());
    }

    private SQLIfUtil() {
    }

    public AbsSqlProcessor get(String name) {
        AbsSqlProcessor p = (AbsSqlProcessor)PROCESSORS.get(name = name.toLowerCase());
        if (p != null) {
            return p;
        }
        throw new RuntimeException("no processor for: " + name);
    }

    public static void main(String[] args) {
        String fn = "/f:/WCMSQL_TO_1095";
        fn = "E:/work/tempfiles";
        if (args.length > 0) {
            fn = args[0];
        }
        System.out.println("begin--------------------");
        File dir = new File(fn);
        SQLIfUtil util = new SQLIfUtil();
        dir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    pathname.listFiles(this);
                } else if (pathname.getName().endsWith(".sql")) {
                    String parent = pathname.getParentFile().getName();
                    AbsSqlProcessor processor = SQLIfUtil.this.get(parent);
                    try {
                        processor.process(pathname);
                    }
                    catch (Exception e) {
                        System.out.println("process failed: " + pathname);
                        e.printStackTrace(System.out);
                    }
                }
                return false;
            }
        });
        System.out.println("end------------------------------------");
    }
}

