/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.tools;

import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.sql.DataSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xmlmiddleware.db.JDBC1DataSource;
import org.xmlmiddleware.db.JDBC2DataSource;
import org.xmlmiddleware.schemas.dtds.DTD;
import org.xmlmiddleware.schemas.dtds.DTDSerializer;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.maps.XMLDBMSMap;
import org.xmlmiddleware.xmldbms.maps.factories.MapCompiler;
import org.xmlmiddleware.xmldbms.maps.factories.MapFactory_DTD;
import org.xmlmiddleware.xmldbms.maps.factories.MapFactory_Database;
import org.xmlmiddleware.xmldbms.maps.utils.DDLGenerator;
import org.xmlmiddleware.xmldbms.maps.utils.DTDGenerator;
import org.xmlmiddleware.xmldbms.maps.utils.MapSerializer;
import org.xmlmiddleware.xmldbms.tools.PropertyProcessor;
import org.xmlmiddleware.xmldbms.tools.XMLDBMSProps;
import org.xmlmiddleware.xmlutils.ParserUtils;

public class MapManager
extends PropertyProcessor {
    private ParserUtils utils;
    private static final Properties emptyProps = new Properties();
    private static String DEFAULT = "Default";
    private static String JDBC1DATASOURCE = "org.xmlmiddleware.db.JDBC1DataSource";
    private static String JDBC2DATASOURCE = "org.xmlmiddleware.db.JDBC2DataSource";

    private MapManager() {
    }

    public MapManager(Properties properties) throws XMLMiddlewareException {
        if (properties == null) {
            properties = emptyProps;
        }
        this.setParserUtils(properties);
    }

    public MapManager(ParserUtils parserUtils) {
        if (parserUtils == null) {
            throw new IllegalArgumentException("utils argument must not be null.");
        }
        this.utils = parserUtils;
    }

    public static void main(String[] stringArray) {
        MapManager mapManager = new MapManager();
        Properties properties = new Properties();
        if (stringArray.length < 1) {
            System.out.println("Usage: java MapManager <property>=<value> [<property>=<value>...]\n\nSee the documentation for a list of valid properties.");
            return;
        }
        try {
            mapManager.addPropertiesFromArray(properties, stringArray, 0, true);
            mapManager.setParserUtils(properties);
            mapManager.dispatch(properties);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void dispatch(Properties properties) throws XMLMiddlewareException, SQLException {
        XMLDBMSMap xMLDBMSMap;
        String string;
        String[] stringArray;
        String string2;
        if (properties == null) {
            properties = emptyProps;
        }
        if ((string2 = properties.getProperty(XMLDBMSProps.INPUT)) == null) {
            throw new XMLMiddlewareException("Input property not specified.");
        }
        String string3 = properties.getProperty(XMLDBMSProps.OUTPUT);
        if (string3 != null) {
            stringArray = new String[]{string3};
        } else {
            stringArray = this.getNumberedProps(XMLDBMSProps.OUTPUT, properties);
            if (stringArray == null) {
                throw new XMLMiddlewareException("Output property or Output1, Output2, ... properties not specified.");
            }
        }
        if (string2.equals(XMLDBMSProps.DTD)) {
            string = properties.getProperty(XMLDBMSProps.DTDFILE);
            if (string == null) {
                throw new XMLMiddlewareException("You must specify the DTDFile property when the value of the Input property is DTD.");
            }
            xMLDBMSMap = this.createMapFromDTD(properties, properties, string);
        } else if (string2.equals(XMLDBMSProps.DATABASE)) {
            String[] stringArray2;
            String[] stringArray3;
            String[] stringArray4;
            String[] stringArray5;
            String[] stringArray6;
            String[] stringArray7;
            String[] stringArray8;
            String[] stringArray9;
            if (properties.getProperty(XMLDBMSProps.ROOTTABLE) != null) {
                stringArray9 = this.getUnnumberedProps(XMLDBMSProps.ROOTDATABASE, properties);
                stringArray8 = this.getUnnumberedProps(XMLDBMSProps.ROOTCATALOG, properties);
                stringArray7 = this.getUnnumberedProps(XMLDBMSProps.ROOTSCHEMA, properties);
                stringArray6 = this.getUnnumberedProps(XMLDBMSProps.ROOTTABLE, properties);
            } else {
                stringArray9 = this.getNumberedProps(XMLDBMSProps.ROOTDATABASE, properties);
                stringArray8 = this.getNumberedProps(XMLDBMSProps.ROOTCATALOG, properties);
                stringArray7 = this.getNumberedProps(XMLDBMSProps.ROOTSCHEMA, properties);
                stringArray6 = this.getNumberedProps(XMLDBMSProps.ROOTTABLE, properties);
            }
            if (stringArray6 == null) {
                throw new IllegalArgumentException("You must specify a " + XMLDBMSProps.ROOTTABLE + "n property or properties, where n is optional but must be numbered 1, 2, 3, ... if present.");
            }
            if (properties.getProperty(XMLDBMSProps.STOPTABLE) != null) {
                stringArray5 = this.getUnnumberedProps(XMLDBMSProps.STOPDATABASE, properties);
                stringArray4 = this.getUnnumberedProps(XMLDBMSProps.STOPCATALOG, properties);
                stringArray3 = this.getUnnumberedProps(XMLDBMSProps.STOPSCHEMA, properties);
                stringArray2 = this.getUnnumberedProps(XMLDBMSProps.STOPTABLE, properties);
            } else {
                stringArray5 = this.getNumberedProps(XMLDBMSProps.STOPDATABASE, properties);
                stringArray4 = this.getNumberedProps(XMLDBMSProps.STOPCATALOG, properties);
                stringArray3 = this.getNumberedProps(XMLDBMSProps.STOPSCHEMA, properties);
                stringArray2 = this.getNumberedProps(XMLDBMSProps.STOPTABLE, properties);
            }
            xMLDBMSMap = this.createMapFromDatabase(properties, properties, stringArray9, stringArray8, stringArray7, stringArray6, stringArray5, stringArray4, stringArray3, stringArray2);
        } else if (string2.equals(XMLDBMSProps.MAP)) {
            string = properties.getProperty(XMLDBMSProps.MAPFILE);
            if (string == null) {
                throw new XMLMiddlewareException("You must specify the MapFile property when the value of the Input property is Map.");
            }
            xMLDBMSMap = this.compileMap(properties, string);
        } else {
            throw new XMLMiddlewareException("Invalid value of " + XMLDBMSProps.INPUT + " property: " + string2);
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(XMLDBMSProps.MAP)) {
                string = properties.getProperty(XMLDBMSProps.MAPFILE);
                if (string == null) {
                    throw new XMLMiddlewareException("You must specify the MapFile property when the value of the Output(n) property is Map.");
                }
                this.writeMap(properties, xMLDBMSMap, string);
            } else if (stringArray[n].equals(XMLDBMSProps.DTD)) {
                string = properties.getProperty(XMLDBMSProps.DTDFILE);
                if (string == null) {
                    throw new XMLMiddlewareException("You must specify the DTDFile property when the value of the Output(n) property is DTD.");
                }
                this.createDTD(properties, xMLDBMSMap, string);
            } else if (stringArray[n].equals(XMLDBMSProps.SQL)) {
                string = properties.getProperty(XMLDBMSProps.SQLFILE);
                if (string == null) {
                    throw new XMLMiddlewareException("You must specify the SQLFile property when the value of the Output(n) property is SQL.");
                }
                this.createSQL(properties, properties, xMLDBMSMap, string);
            } else {
                throw new XMLMiddlewareException("Invalid value of " + XMLDBMSProps.OUTPUT + " property: " + stringArray[n]);
            }
            ++n;
        }
    }

    public XMLDBMSMap compileMap(Properties properties, String string) throws XMLMiddlewareException {
        MapCompiler mapCompiler = null;
        if (properties == null) {
            properties = emptyProps;
        }
        try {
            String string2 = properties.getProperty(XMLDBMSProps.VALIDATE);
            boolean bl = string2 == null ? true : this.getYesNo(string2);
            mapCompiler = new MapCompiler(this.utils.getXMLReader(bl));
            return mapCompiler.compile(new InputSource(new FileReader(string)));
        }
        catch (SAXException sAXException) {
            this.processSAXException(sAXException);
        }
        catch (Exception exception) {
            throw new XMLMiddlewareException(exception);
        }
        return null;
    }

    public XMLDBMSMap createMapFromDTD(Properties properties, Properties properties2, String string) throws XMLMiddlewareException, SQLException {
        String string2;
        if (properties == null) {
            properties = emptyProps;
        }
        if (properties2 == null) {
            properties2 = emptyProps;
        }
        MapFactory_DTD mapFactory_DTD = new MapFactory_DTD();
        DBInfo dBInfo = this.getDBInfo(properties, false);
        if (dBInfo != null) {
            Connection connection = dBInfo.dataSource.getConnection(dBInfo.user, dBInfo.password);
            mapFactory_DTD.setConnection(connection);
        }
        if ((string2 = properties2.getProperty(XMLDBMSProps.ORDERTYPE)) != null) {
            if (string2.equals(XMLDBMSProps.FIXED)) {
                mapFactory_DTD.setOrderType(1);
            } else if (string2.equals(XMLDBMSProps.NONE)) {
                mapFactory_DTD.setOrderType(0);
            } else if (string2.equals(XMLDBMSProps.COLUMNS)) {
                mapFactory_DTD.setOrderType(2);
            } else {
                throw new IllegalArgumentException("Invalid value of " + XMLDBMSProps.ORDERTYPE + " property: " + string2);
            }
        }
        String string3 = properties.getProperty(XMLDBMSProps.DATABASENAME);
        String string4 = properties.getProperty(XMLDBMSProps.CATALOGNAME);
        String string5 = properties.getProperty(XMLDBMSProps.SCHEMANAME);
        if (string3 != null || string4 != null || string5 != null) {
            mapFactory_DTD.setDatabaseNames(string3, string4, string5);
        }
        Hashtable hashtable = this.getNamespaceURIOrURIs(properties2);
        try {
            return mapFactory_DTD.createMap(new InputSource(new FileReader(string)), 0, hashtable);
        }
        catch (Exception exception) {
            throw new XMLMiddlewareException(exception);
        }
    }

    public XMLDBMSMap createMapFromDatabase(Properties properties, Properties properties2, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7, String[] stringArray8) throws XMLMiddlewareException, SQLException {
        String string;
        String string2;
        String string3;
        int n = 0;
        if (properties == null) {
            properties = emptyProps;
        }
        if (properties2 == null) {
            properties2 = emptyProps;
        }
        Hashtable hashtable = this.getDBInfoOrDBInfos(properties);
        Enumeration enumeration = hashtable.keys();
        String[] stringArray9 = new String[hashtable.size()];
        Connection[] connectionArray = new Connection[hashtable.size()];
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            DBInfo dBInfo = (DBInfo)hashtable.get(string4);
            Connection connection = dBInfo.dataSource.getConnection(dBInfo.user, dBInfo.password);
            stringArray9[n] = string4;
            connectionArray[n] = connection;
            ++n;
        }
        MapFactory_Database mapFactory_Database = new MapFactory_Database(stringArray9, connectionArray);
        String string5 = properties2.getProperty(XMLDBMSProps.MAPCOLUMNSAS);
        if (string5 != null) {
            if (string5.equals(XMLDBMSProps.ELEMENTTYPES)) {
                mapFactory_Database.columnsAreElementTypes(true);
            } else if (string5.equals(XMLDBMSProps.ATTRIBUTES)) {
                mapFactory_Database.columnsAreElementTypes(false);
            } else {
                throw new XMLMiddlewareException("Invalid value of " + XMLDBMSProps.MAPCOLUMNSAS + " property: " + string5);
            }
        }
        if ((string3 = properties2.getProperty(XMLDBMSProps.FOLLOWPRIMARYKEYS)) != null) {
            mapFactory_Database.followPrimaryKeys(this.getYesNo(string3));
        }
        if ((string2 = properties2.getProperty(XMLDBMSProps.FOLLOWFOREIGNKEYS)) != null) {
            mapFactory_Database.followForeignKeys(this.getYesNo(string2));
        }
        if ((string = properties2.getProperty(XMLDBMSProps.URI)) != null) {
            mapFactory_Database.setNamespaceInfo(string, properties2.getProperty(XMLDBMSProps.PREFIX));
        }
        if (stringArray == null) {
            stringArray = new String[stringArray4.length];
        }
        if (stringArray2 == null) {
            stringArray2 = new String[stringArray4.length];
        }
        if (stringArray3 == null) {
            stringArray3 = new String[stringArray4.length];
        }
        if (stringArray8 != null) {
            if (stringArray5 == null) {
                stringArray5 = new String[stringArray8.length];
            }
            if (stringArray6 == null) {
                stringArray6 = new String[stringArray8.length];
            }
            if (stringArray7 == null) {
                stringArray7 = new String[stringArray8.length];
            }
        }
        if (stringArray8 == null) {
            return mapFactory_Database.createMap(stringArray, stringArray2, stringArray3, stringArray4);
        }
        return mapFactory_Database.createMap(stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8);
    }

    public void writeMap(Properties properties, XMLDBMSMap xMLDBMSMap, String string) throws XMLMiddlewareException {
        int n;
        if (properties == null) {
            properties = emptyProps;
        }
        Writer writer = this.getWriter(string, properties);
        MapSerializer mapSerializer = new MapSerializer(writer);
        String string2 = properties.getProperty(XMLDBMSProps.PRETTY);
        boolean bl = string2 == null ? true : this.getYesNo(string2);
        try {
            String string3 = properties.getProperty(XMLDBMSProps.INDENT);
            n = string3 == null ? 3 : Integer.valueOf(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMLMiddlewareException(numberFormatException);
        }
        mapSerializer.setPrettyPrinting(bl, n);
        Hashtable hashtable = this.getNamespaceURIOrURIs(properties);
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            String[] stringArray = new String[hashtable.size()];
            String[] stringArray2 = new String[hashtable.size()];
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                stringArray[n2] = (String)enumeration.nextElement();
                stringArray2[n2] = (String)hashtable.get(stringArray[n2]);
                ++n2;
            }
            mapSerializer.usePrefixes(stringArray, stringArray2);
        }
        try {
            String string4 = properties.getProperty(XMLDBMSProps.SYSTEMID);
            if (string4 != null) {
                mapSerializer.serialize(xMLDBMSMap, string4, properties.getProperty(XMLDBMSProps.PUBLICID));
            } else {
                mapSerializer.serialize(xMLDBMSMap);
            }
            writer.close();
            return;
        }
        catch (IOException iOException) {
            throw new XMLMiddlewareException(iOException);
        }
    }

    public void createDTD(Properties properties, XMLDBMSMap xMLDBMSMap, String string) throws XMLMiddlewareException {
        if (properties == null) {
            properties = emptyProps;
        }
        DTDGenerator dTDGenerator = new DTDGenerator();
        DTD dTD = dTDGenerator.getDTD(xMLDBMSMap);
        Writer writer = this.getWriter(string, properties);
        String string2 = properties.getProperty(XMLDBMSProps.PRETTY);
        boolean bl = string2 == null ? true : this.getYesNo(string2);
        try {
            DTDSerializer dTDSerializer = new DTDSerializer();
            dTDSerializer.serialize(dTD, writer, bl);
            writer.close();
            return;
        }
        catch (IOException iOException) {
            throw new XMLMiddlewareException(iOException);
        }
    }

    public void createSQL(Properties properties, Properties properties2, XMLDBMSMap xMLDBMSMap, String string) throws XMLMiddlewareException, SQLException {
        DDLGenerator dDLGenerator;
        String string2;
        Connection connection;
        DBInfo dBInfo;
        if (properties == null) {
            properties = emptyProps;
        }
        if (properties2 == null) {
            properties2 = emptyProps;
        }
        if (properties.getProperty(XMLDBMSProps.DATASOURCECLASS) != null) {
            dBInfo = this.getDBInfo(properties, true);
            connection = dBInfo.dataSource.getConnection(dBInfo.user, dBInfo.password);
            string2 = properties.getProperty(XMLDBMSProps.DBNAME);
            dDLGenerator = new DDLGenerator(string2, connection.getMetaData());
        } else if (properties.getProperty(String.valueOf(XMLDBMSProps.DATASOURCECLASS) + "1") != null) {
            Hashtable hashtable = this.getDBInfoOrDBInfos(properties);
            Enumeration enumeration = hashtable.keys();
            String[] stringArray = new String[hashtable.size()];
            DatabaseMetaData[] databaseMetaDataArray = new DatabaseMetaData[hashtable.size()];
            int n = 0;
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                dBInfo = (DBInfo)hashtable.get(string2);
                connection = dBInfo.dataSource.getConnection(dBInfo.user, dBInfo.password);
                stringArray[n] = string2;
                databaseMetaDataArray[n] = connection.getMetaData();
                ++n;
            }
            dDLGenerator = new DDLGenerator(stringArray, databaseMetaDataArray);
        } else {
            dDLGenerator = new DDLGenerator();
        }
        Vector vector = dDLGenerator.getCreateTableStrings(xMLDBMSMap);
        Writer writer = this.getWriter(string, properties2);
        String string3 = properties2.getProperty(XMLDBMSProps.SQLSEPARATOR);
        if (string3 == null) {
            string3 = ";" + System.getProperty("line.separator");
        }
        try {
            int n = 0;
            while (n < vector.size()) {
                writer.write((String)vector.elementAt(n));
                writer.write(string3);
                ++n;
            }
            writer.close();
            return;
        }
        catch (IOException iOException) {
            throw new XMLMiddlewareException(iOException);
        }
    }

    private Hashtable getDBInfoOrDBInfos(Properties properties) throws XMLMiddlewareException {
        Hashtable hashtable;
        if (properties.getProperty(XMLDBMSProps.DATASOURCECLASS) != null) {
            hashtable = new Hashtable();
            DBInfo dBInfo = this.getDBInfo(properties, true);
            String string = properties.getProperty(XMLDBMSProps.DBNAME);
            if (string == null) {
                string = DEFAULT;
            }
            hashtable.put(string, dBInfo);
        } else {
            hashtable = this.getDBInfos(properties);
        }
        return hashtable;
    }

    private DBInfo getDBInfo(Properties properties, boolean bl) throws XMLMiddlewareException {
        String string = properties.getProperty(XMLDBMSProps.DATASOURCECLASS);
        if (string == null) {
            if (bl) {
                throw new XMLMiddlewareException("You must specify a value for the " + XMLDBMSProps.DATASOURCECLASS + " property.");
            }
            return null;
        }
        DBInfo dBInfo = new DBInfo();
        dBInfo.dataSource = this.createDataSource(string, properties, 0);
        dBInfo.user = properties.getProperty(XMLDBMSProps.USER);
        dBInfo.password = properties.getProperty(XMLDBMSProps.PASSWORD);
        return dBInfo;
    }

    private Hashtable getDBInfos(Properties properties) throws XMLMiddlewareException {
        Hashtable<String, DBInfo> hashtable = new Hashtable<String, DBInfo>();
        String[] stringArray = this.getNumberedProps(XMLDBMSProps.DBNAME, properties);
        String[] stringArray2 = this.getNumberedProps(XMLDBMSProps.DATASOURCECLASS, properties);
        String[] stringArray3 = this.getNumberedProps(XMLDBMSProps.USER, properties);
        String[] stringArray4 = this.getNumberedProps(XMLDBMSProps.PASSWORD, properties);
        if (stringArray == null || stringArray2 == null) {
            throw new XMLMiddlewareException("You must specify a single DataSourceClass property, or one or more DBName1 (2, 3, ...) and DataSourceClass1 (2, 3, ...) properties.");
        }
        try {
            int n = 0;
            while (n < stringArray2.length) {
                DBInfo dBInfo = new DBInfo();
                hashtable.put(stringArray[n], dBInfo);
                dBInfo.dataSource = this.createDataSource(stringArray2[n], properties, n);
                dBInfo.user = stringArray3 == null ? null : stringArray3[n];
                dBInfo.password = stringArray4 == null ? null : stringArray4[n];
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new XMLMiddlewareException("If you specify them, you must have the same number of " + XMLDBMSProps.DBNAME + ", " + XMLDBMSProps.DATASOURCECLASS + ", " + XMLDBMSProps.USER + ", and " + XMLDBMSProps.PASSWORD + " properties.");
        }
        return hashtable;
    }

    private DataSource createDataSource(String string, Properties properties, int n) {
        if (string == null) {
            throw new IllegalArgumentException("You must specify a DataSourceClass property");
        }
        if (string.equals(JDBC1DATASOURCE)) {
            return this.createJDBC1DataSource(properties, n);
        }
        if (string.equals(JDBC2DATASOURCE)) {
            return this.createJDBC2DataSource(properties, n);
        }
        throw new IllegalArgumentException("The data source class must be c or org.xmlmiddleware.db.JDBC2DataSource.");
    }

    private DataSource createJDBC1DataSource(Properties properties, int n) {
        String string = n == 0 ? XMLDBMSProps.DRIVER : String.valueOf(XMLDBMSProps.DRIVER) + n;
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            throw new IllegalArgumentException("You must specify the driver when using a JDBC1DataSource.");
        }
        string = n == 0 ? XMLDBMSProps.URL : String.valueOf(XMLDBMSProps.URL) + n;
        String string3 = properties.getProperty(string);
        if (string3 == null) {
            throw new IllegalArgumentException("You must specify the URL when using a JDBC1DataSource.");
        }
        return new JDBC1DataSource(string2, string3);
    }

    private DataSource createJDBC2DataSource(Properties properties, int n) {
        String string = n == 0 ? XMLDBMSProps.JNDICONTEXT : String.valueOf(XMLDBMSProps.JNDICONTEXT) + n;
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            throw new IllegalArgumentException("You must specify the JNDI context when using a JDBC2DataSource.");
        }
        string = n == 0 ? XMLDBMSProps.JNDILOOKUPNAME : String.valueOf(XMLDBMSProps.JNDILOOKUPNAME) + n;
        String string3 = properties.getProperty(string);
        if (string3 == null) {
            throw new IllegalArgumentException("You must specify the JNDI lookup name of the data source when using a JDBC2DataSource.");
        }
        return new JDBC2DataSource(string2, string3);
    }

    private Hashtable getNamespaceURIOrURIs(Properties properties) throws XMLMiddlewareException {
        Hashtable hashtable;
        String string = properties.getProperty(XMLDBMSProps.URI);
        if (string != null) {
            hashtable = new Hashtable();
            String string2 = properties.getProperty(XMLDBMSProps.PREFIX);
            if (string2 == null) {
                throw new XMLMiddlewareException("Invalid to specify namespace URI without namespace prefix.");
            }
            hashtable.put(string2, string);
        } else {
            hashtable = this.getNamespaceURIs(properties);
        }
        return hashtable;
    }

    private Hashtable getNamespaceURIs(Properties properties) throws XMLMiddlewareException {
        String[] stringArray = this.getNumberedProps(XMLDBMSProps.URI, properties);
        String[] stringArray2 = this.getNumberedProps(XMLDBMSProps.PREFIX, properties);
        if (stringArray == null && stringArray2 == null) {
            return null;
        }
        if (stringArray == null && stringArray2 != null || stringArray != null && stringArray2 == null) {
            throw new IllegalArgumentException("If you specify numbered " + XMLDBMSProps.URI + " properties, you must also specify numbered " + XMLDBMSProps.PREFIX + " properties and vice versa.");
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            int n = 0;
            while (n < stringArray.length) {
                hashtable.put(stringArray2[n], stringArray[n]);
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new XMLMiddlewareException("If you specify them, you must have the same number of " + XMLDBMSProps.URI + " and " + XMLDBMSProps.PREFIX + " properties.");
        }
        return hashtable;
    }

    private Writer getWriter(String string, Properties properties) throws XMLMiddlewareException {
        try {
            String string2 = properties.getProperty(XMLDBMSProps.ENCODING);
            if (string2 != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                return new OutputStreamWriter((OutputStream)fileOutputStream, string2);
            }
            return new FileWriter(string);
        }
        catch (Exception exception) {
            throw new XMLMiddlewareException(exception);
        }
    }

    private void setParserUtils(Properties properties) throws XMLMiddlewareException {
        String string = properties.getProperty(XMLDBMSProps.PARSERUTILSCLASS);
        if (string == null) {
            throw new IllegalArgumentException("Properties object must contain " + XMLDBMSProps.PARSERUTILSCLASS + " property.");
        }
        this.utils = (ParserUtils)this.instantiateObject(string);
    }

    private void processSAXException(SAXException sAXException) throws XMLMiddlewareException {
        Exception exception = sAXException.getException();
        if (exception != null) {
            if (exception instanceof XMLMiddlewareException) {
                throw (XMLMiddlewareException)exception;
            }
            throw new XMLMiddlewareException(exception);
        }
        throw new XMLMiddlewareException(sAXException);
    }

    private Object instantiateObject(String string) throws XMLMiddlewareException {
        try {
            return Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new XMLMiddlewareException(String.valueOf(exception.getClass().getName()) + ": " + exception.getMessage());
        }
    }

    private boolean getYesNo(String string) throws XMLMiddlewareException {
        if (string.equals(XMLDBMSProps.YES)) {
            return true;
        }
        if (string.equals(XMLDBMSProps.NO)) {
            return false;
        }
        throw new XMLMiddlewareException("Invalid Yes/No value: " + string);
    }

    private String[] getUnnumberedProps(String string, Properties properties) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = new String[]{string2};
        return stringArray;
    }

    private class DBInfo {
        DataSource dataSource;
        String user;
        String password;

        DBInfo() {
            MapManager.this = MapManager.this;
        }
    }
}

