/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.maps.utils;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xmlmiddleware.schemas.dtds.Attribute;
import org.xmlmiddleware.schemas.dtds.DTD;
import org.xmlmiddleware.schemas.dtds.ElementType;
import org.xmlmiddleware.schemas.dtds.Group;
import org.xmlmiddleware.schemas.dtds.Reference;
import org.xmlmiddleware.utils.Sort;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.maps.ClassMap;
import org.xmlmiddleware.xmldbms.maps.ClassMapBase;
import org.xmlmiddleware.xmldbms.maps.InlineClassMap;
import org.xmlmiddleware.xmldbms.maps.OrderInfo;
import org.xmlmiddleware.xmldbms.maps.PropertyMap;
import org.xmlmiddleware.xmldbms.maps.RelatedClassMap;
import org.xmlmiddleware.xmldbms.maps.XMLDBMSMap;
import org.xmlmiddleware.xmlutils.XMLName;

public class DTDGenerator {
    private DTD dtd;
    private XMLDBMSMap map;
    private Hashtable order = new Hashtable();
    private static final Long MAXLONG = new Long(Long.MAX_VALUE);

    public DTD getDTD(XMLDBMSMap xMLDBMSMap) throws XMLMiddlewareException {
        this.dtd = new DTD();
        this.map = xMLDBMSMap;
        this.order.clear();
        this.processClassMaps();
        this.sortContentModels();
        return this.dtd;
    }

    private void processClassMaps() throws XMLMiddlewareException {
        Enumeration enumeration = this.map.getClassMaps();
        while (enumeration.hasMoreElements()) {
            ClassMap classMap = (ClassMap)enumeration.nextElement();
            this.processClassMapBase(classMap);
        }
    }

    private void processClassMapBase(ClassMapBase classMapBase) throws XMLMiddlewareException {
        if (classMapBase instanceof ClassMap) {
            this.checkUnhandledStructures((ClassMap)classMapBase);
        }
        ElementType elementType = this.dtd.createElementType(classMapBase.getElementTypeName());
        PropertyMap propertyMap = classMapBase.getPCDATAMap();
        Enumeration enumeration = classMapBase.getChildMaps();
        this.setContentType(elementType, propertyMap, enumeration);
        this.processChildMaps(elementType, enumeration);
        Enumeration enumeration2 = classMapBase.getAttributeMaps();
        this.processAttributeMaps(elementType, enumeration2);
    }

    private void processChildMaps(ElementType elementType, Enumeration enumeration) throws XMLMiddlewareException {
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof PropertyMap) {
                this.processPropertyMap(elementType, (PropertyMap)e);
                continue;
            }
            if (e instanceof RelatedClassMap) {
                this.processRelatedClassMap(elementType, (RelatedClassMap)e);
                continue;
            }
            this.processInlineClassMap(elementType, (InlineClassMap)e);
        }
    }

    private void processPropertyMap(ElementType elementType, PropertyMap propertyMap) {
        XMLName xMLName = propertyMap.getXMLName();
        ElementType elementType2 = this.dtd.createElementType(xMLName);
        switch (elementType2.contentType) {
            case 0: {
                elementType2.contentType = 3;
                break;
            }
            case 1: {
                elementType2.contentType = 3;
                break;
            }
        }
        elementType.children.put(xMLName, elementType2);
        Reference reference = new Reference(elementType2);
        elementType.content.members.addElement(reference);
        if (elementType.contentType == 5) {
            if (propertyMap.getTable() != null) {
                if (!propertyMap.isTokenList()) {
                    reference.isRepeatable = true;
                    reference.isRequired = false;
                }
            } else if (propertyMap.getColumn().getNullability() == 1) {
                reference.isRequired = false;
            }
        }
        this.addOrderValue(elementType, xMLName, propertyMap.getOrderInfo());
        elementType2.parents.put(elementType.name, elementType);
    }

    private void processRelatedClassMap(ElementType elementType, RelatedClassMap relatedClassMap) {
        XMLName xMLName = relatedClassMap.getElementTypeName();
        ElementType elementType2 = this.dtd.createElementType(xMLName);
        Reference reference = new Reference(elementType2);
        elementType.content.members.addElement(reference);
        if (elementType.contentType == 5) {
            reference.isRequired = false;
            reference.isRepeatable = relatedClassMap.getLinkInfo().parentKeyIsUnique();
        }
        this.addOrderValue(elementType, xMLName, relatedClassMap.getOrderInfo());
    }

    private void processInlineClassMap(ElementType elementType, InlineClassMap inlineClassMap) throws XMLMiddlewareException {
        XMLName xMLName = inlineClassMap.getElementTypeName();
        ElementType elementType2 = this.dtd.createElementType(xMLName);
        Reference reference = new Reference(elementType2);
        elementType.content.members.addElement(reference);
        this.addOrderValue(elementType, xMLName, inlineClassMap.getOrderInfo());
        this.processClassMapBase(inlineClassMap);
    }

    private void processAttributeMaps(ElementType elementType, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            PropertyMap propertyMap = (PropertyMap)enumeration.nextElement();
            this.processAttributeMap(elementType, propertyMap);
        }
    }

    private void processAttributeMap(ElementType elementType, PropertyMap propertyMap) {
        XMLName xMLName = propertyMap.getXMLName();
        Attribute attribute = new Attribute(xMLName);
        elementType.attributes.put(xMLName, attribute);
        int n = attribute.type = propertyMap.isTokenList() ? 8 : 1;
        if (propertyMap.getTable() != null) {
            attribute.required = 2;
            return;
        }
        if (propertyMap.getColumn().getNullability() == 1) {
            attribute.required = 2;
            return;
        }
        attribute.required = 1;
    }

    private void checkUnhandledStructures(ClassMap classMap) throws XMLMiddlewareException {
        if (classMap.getBaseClassMap() != null) {
            throw new XMLMiddlewareException("The class map for the " + classMap.getElementTypeName().getUniversalName() + " uses base class maps (the Extends element). This structure cannot be represented in a DTD.");
        }
        if (classMap.getUsedClassMap() != null) {
            throw new XMLMiddlewareException("The class map for the " + classMap.getElementTypeName().getUniversalName() + " uses the class map for another element type (the UseClassMap element). This structure cannot be represented in a DTD.");
        }
    }

    private void setContentType(ElementType elementType, PropertyMap propertyMap, Enumeration enumeration) {
        switch (elementType.contentType) {
            case 0: 
            case 1: {
                if (enumeration.hasMoreElements()) {
                    if (propertyMap == null) {
                        elementType.contentType = 5;
                        break;
                    }
                    elementType.contentType = 4;
                    break;
                }
                if (propertyMap == null) {
                    elementType.contentType = 1;
                    break;
                }
                elementType.contentType = 3;
                break;
            }
            case 5: {
                if (propertyMap == null) break;
                elementType.contentType = 4;
                this.updateContentModel(elementType);
                break;
            }
            case 3: {
                if (!enumeration.hasMoreElements()) break;
                elementType.contentType = 4;
                break;
            }
        }
        if ((elementType.contentType == 5 || elementType.contentType == 4) && elementType.content == null) {
            elementType.content = new Group();
            elementType.content.members = new Vector();
            if (elementType.contentType == 5) {
                elementType.content.type = 3;
                return;
            }
            elementType.content.type = 2;
            elementType.content.isRepeatable = true;
            elementType.content.isRequired = false;
        }
    }

    private void updateContentModel(ElementType elementType) {
        elementType.content.type = 2;
        elementType.content.isRepeatable = true;
        elementType.content.isRequired = false;
        int n = 0;
        while (n < elementType.content.members.size()) {
            Reference reference = (Reference)elementType.content.members.elementAt(n);
            reference.isRepeatable = false;
            reference.isRequired = true;
            ++n;
        }
        this.order.remove(elementType.name);
    }

    private void addOrderValue(ElementType elementType, XMLName xMLName, OrderInfo orderInfo) {
        if (elementType.contentType != 5) {
            return;
        }
        Hashtable<XMLName, Long> hashtable = (Hashtable<XMLName, Long>)this.order.get(elementType.name);
        if (hashtable == null) {
            hashtable = new Hashtable<XMLName, Long>();
            this.order.put(elementType.name, hashtable);
        }
        if (orderInfo != null && orderInfo.orderValueIsFixed()) {
            hashtable.put(xMLName, new Long(orderInfo.getFixedOrderValue()));
            return;
        }
        hashtable.put(xMLName, MAXLONG);
    }

    private void sortContentModels() {
        Enumeration enumeration = this.dtd.elementTypes.elements();
        while (enumeration.hasMoreElements()) {
            ElementType elementType = (ElementType)enumeration.nextElement();
            if (elementType.contentType != 5) continue;
            this.sortContentModel(elementType);
        }
    }

    private void sortContentModel(ElementType elementType) {
        Hashtable hashtable = (Hashtable)this.order.get(elementType.name);
        Object[] objectArray = new Object[elementType.content.members.size()];
        elementType.content.members.copyInto(objectArray);
        long[] lArray = new long[elementType.content.members.size()];
        int n = 0;
        while (n < lArray.length) {
            XMLName xMLName = ((Reference)objectArray[n]).elementType.name;
            lArray[n] = (Long)hashtable.get(xMLName);
            ++n;
        }
        Sort.sort(lArray, objectArray);
        elementType.content.members.removeAllElements();
        n = 0;
        while (n < objectArray.length) {
            elementType.content.members.addElement(objectArray[n]);
            ++n;
        }
    }
}

