/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.maps;

import java.util.Enumeration;
import java.util.Hashtable;
import org.xmlmiddleware.utils.Sort;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.maps.Column;
import org.xmlmiddleware.xmldbms.maps.Key;
import org.xmlmiddleware.xmldbms.maps.MapBase;

public class Table
extends MapBase {
    private static String DEFAULT = "Default";
    private static String DOUBLEQUOTE = "\"";
    private static String DQPDQ = "\".\"";
    private static String PRIMARYKEY = "PrimaryKey";
    private static String SEMICOLON = ";";
    private static String NULL = "null";
    private String databaseName;
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String hashName;
    private Hashtable columns = new Hashtable();
    private Column[] rsColumns;
    private Key primaryKey;
    private Hashtable uniqueKeys = new Hashtable();
    private Hashtable foreignKeys = new Hashtable();

    private Table(String string, String string2, String string3, String string4) {
        this.databaseName = string != null ? string : DEFAULT;
        this.catalogName = string2;
        this.schemaName = string3;
        this.tableName = string4;
        this.hashName = Table.getHashName(string, string2, string3, string4);
    }

    public static Table create(String string, String string2, String string3, String string4) {
        MapBase.checkArgNull(string4, "tableName");
        return new Table(string, string2, string3, string4);
    }

    public final String getDatabaseName() {
        return this.databaseName;
    }

    public final String getCatalogName() {
        return this.catalogName;
    }

    public final String getSchemaName() {
        return this.schemaName;
    }

    public final String getTableName() {
        return this.tableName;
    }

    public final String getUniversalName() {
        return Table.getUniversalName(this.databaseName, this.catalogName, this.schemaName, this.tableName);
    }

    public static String getUniversalName(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        MapBase.checkArgNull(string4, "tableName");
        stringBuffer.append(DOUBLEQUOTE);
        stringBuffer.append(string != null ? string : DEFAULT);
        stringBuffer.append(DQPDQ);
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append(DQPDQ);
        if (string3 != null) {
            stringBuffer.append(string3);
        }
        stringBuffer.append(DQPDQ);
        stringBuffer.append(string4);
        stringBuffer.append(DOUBLEQUOTE);
        return stringBuffer.toString();
    }

    public final String getHashName() {
        return this.hashName;
    }

    public static String getHashName(String string, String string2, String string3, String string4) {
        MapBase.checkArgNull(string4, "tableName");
        if (string == null) {
            string = DEFAULT;
        }
        String string5 = Integer.toString(string.hashCode());
        String string6 = string2 == null ? NULL : Integer.toString(string2.hashCode());
        String string7 = string3 == null ? NULL : Integer.toString(string3.hashCode());
        String string8 = Integer.toString(string4.hashCode());
        return String.valueOf(string5) + SEMICOLON + string6 + SEMICOLON + string7 + SEMICOLON + string8;
    }

    public final int getNumberOfColumns() {
        return this.columns.size();
    }

    public final Column getColumn(String string) {
        MapBase.checkArgNull(string, "columnName");
        return (Column)this.columns.get(string);
    }

    public final Enumeration getColumns() {
        return this.columns.elements();
    }

    public final Column[] getResultSetColumns() {
        if (this.rsColumns == null) {
            long[] lArray = new long[this.columns.size()];
            this.rsColumns = new Column[this.columns.size()];
            Enumeration enumeration = this.columns.elements();
            int n = 0;
            while (n < this.columns.size()) {
                Column column;
                this.rsColumns[n] = column = (Column)enumeration.nextElement();
                lArray[n] = column.getResultSetIndex();
                ++n;
            }
            Sort.sort(lArray, (Object[])this.rsColumns);
        }
        return this.rsColumns;
    }

    public Column createColumn(String string) {
        MapBase.checkArgNull(string, "columnName");
        Column column = (Column)this.columns.get(string);
        if (column == null) {
            column = Column.create(string);
            this.columns.put(string, column);
        }
        this.rsColumns = null;
        return column;
    }

    public void addColumn(Column column) throws XMLMiddlewareException {
        MapBase.checkArgNull(column, "column");
        String string = column.getName();
        Object v = this.columns.get(string);
        if (v != null) {
            throw new XMLMiddlewareException("Column " + string + " already exists in " + this.getUniversalName() + ".");
        }
        this.columns.put(string, column);
        this.rsColumns = null;
    }

    public void removeColumn(String string) throws XMLMiddlewareException {
        MapBase.checkArgNull(string, "columnName");
        Object v = this.columns.remove(string);
        if (v == null) {
            throw new XMLMiddlewareException("Column " + string + " not found in table " + this.getUniversalName());
        }
        this.rsColumns = null;
    }

    public void removeAllColumns() {
        this.columns.clear();
        this.rsColumns = null;
    }

    public final Key getPrimaryKey() {
        return this.primaryKey;
    }

    public Key createPrimaryKey(String string) {
        if (string == null) {
            string = PRIMARYKEY;
        }
        if (this.primaryKey == null) {
            this.primaryKey = Key.createPrimaryKey(string);
        } else if (!this.primaryKey.getName().equals(string)) {
            throw new IllegalArgumentException("The primary key already exists, but has a different name. To change the name of the primary key, delete it and create a new primary key with the new name.");
        }
        return this.primaryKey;
    }

    public void addPrimaryKey(Key key) throws XMLMiddlewareException {
        if (this.primaryKey != null) {
            throw new XMLMiddlewareException("Primary key already exists.");
        }
        MapBase.checkArgNull(key, "key");
        if (key.getType() != 1) {
            throw new IllegalArgumentException("Key is not a primary key.");
        }
        this.primaryKey = key;
    }

    public void removePrimaryKey() throws XMLMiddlewareException {
        if (this.primaryKey == null) {
            throw new XMLMiddlewareException("Primary key does not exist.");
        }
        this.primaryKey = null;
    }

    public final Key getUniqueKey(String string) {
        return this.getKey(this.uniqueKeys, string);
    }

    public final Enumeration getUniqueKeys() {
        return this.uniqueKeys.elements();
    }

    public Key createUniqueKey(String string) {
        return this.createKey(this.uniqueKeys, string, 2);
    }

    public void addUniqueKey(Key key) throws XMLMiddlewareException {
        this.addKey(this.uniqueKeys, key, 2);
    }

    public void removeUniqueKey(String string) throws XMLMiddlewareException {
        this.removeKey(this.uniqueKeys, string);
    }

    public void removeAllUniqueKeys() {
        this.uniqueKeys.clear();
    }

    public final Key getForeignKey(String string) {
        return this.getKey(this.foreignKeys, string);
    }

    public final Enumeration getForeignKeys() {
        return this.foreignKeys.elements();
    }

    public Key createForeignKey(String string) {
        return this.createKey(this.foreignKeys, string, 3);
    }

    public void addForeignKey(Key key) throws XMLMiddlewareException {
        this.addKey(this.foreignKeys, key, 3);
    }

    public void removeForeignKey(String string) throws XMLMiddlewareException {
        this.removeKey(this.foreignKeys, string);
    }

    public void removeAllForeignKeys() {
        this.foreignKeys.clear();
    }

    public Column checkMetadata() {
        Enumeration enumeration = this.getColumns();
        while (enumeration.hasMoreElements()) {
            Column column = (Column)enumeration.nextElement();
            if (column.isMetadataSet()) continue;
            return column;
        }
        return null;
    }

    private final Key getKey(Hashtable hashtable, String string) {
        MapBase.checkArgNull(string, "keyName");
        return (Key)hashtable.get(string);
    }

    private Key createKey(Hashtable hashtable, String string, int n) {
        MapBase.checkArgNull(string, "keyName");
        Key key = (Key)hashtable.get(string);
        if (key == null) {
            if (n == 2) {
                key = Key.createUniqueKey(string);
            } else if (n == 3) {
                key = Key.createForeignKey(string);
            }
            hashtable.put(string, key);
        }
        return key;
    }

    private void addKey(Hashtable hashtable, Key key, int n) throws XMLMiddlewareException {
        MapBase.checkArgNull(key, "key");
        if (key.getType() != n) {
            throw new IllegalArgumentException("Key is not the correct type.");
        }
        String string = key.getName();
        Object v = hashtable.get(string);
        if (v != null) {
            throw new XMLMiddlewareException("Key " + string + " already exists in " + this.getUniversalName() + ".");
        }
        hashtable.put(string, key);
    }

    private void removeKey(Hashtable hashtable, String string) throws XMLMiddlewareException {
        MapBase.checkArgNull(string, "keyName");
        Object v = hashtable.remove(string);
        if (v == null) {
            throw new XMLMiddlewareException("Key " + string + " not found in table " + this.getUniversalName() + ".");
        }
    }
}

