/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.config.PublishDistributionTargetType;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.distribute.PublishDistributionMgr;
import com.trs.components.common.publish.persistent.distribute.PublishDistribution;
import com.trs.components.common.publish.persistent.distribute.PublishDistributions;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.log.LogServer;
import com.trs.service.IWCMPublishElementService;
import java.util.Iterator;
import java.util.Map;

public class WCMPublishElementServiceImpl
implements IWCMPublishElementService {
    @Override
    public WCMFolderPublishConfig findFolderConfig(BaseChannel _currChannel) throws WCMException {
        return WCMFolderPublishConfig.findOf(_currChannel.getWCMType(), _currChannel.getId());
    }

    @Override
    public WCMFolderPublishConfig save(BaseChannel _currChannel, WCMFolderPublishConfig _currFolderConfig) throws WCMException {
        String sDesc = I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label1", "\u4fdd\u5b58") + _currChannel + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label2", "\u53d1\u5e03\u914d\u7f6e\u4fe1\u606f");
        if (_currChannel == null) {
            throw new WCMException(sDesc + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label3", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6307\u5b9a\u9891\u9053\uff01"));
        }
        int nRightIndex = 13;
        if (!AuthServer.hasRight(ContextHelper.getLoginUser(), (CMSObj)_currChannel, nRightIndex)) {
            throw new WCMException(sDesc + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label4", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        }
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "PUBLISH_SETTING", sDesc, _currChannel);
        try {
            _currFolderConfig.save(this.getLoginUser());
            LogServer.endRecordSucceedOperation(lStartTime);
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lStartTime, e);
            throw new WCMException(sDesc + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label5", "\u5931\u8d25!"), e);
        }
        return _currFolderConfig;
    }

    @Override
    public PublishDistributions findPublishDistributions(WebSite _currSite, boolean _bExcludingDisabled, WCMFilter _filter) throws WCMException {
        return this.getPublishDistributionMgr().getDistributionsOf(this.getFolder(_currSite), _bExcludingDisabled, _filter);
    }

    @Override
    public PublishDistribution save(WebSite _currSite, PublishDistribution _currPublishDistribution) throws WCMException {
        String sDesc = I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label1", "\u4fdd\u5b58") + _currSite + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label6", "\u7684\u53d1\u5e03\u5206\u53d1\u76ee\u5f55\u4fe1\u606f");
        if (_currSite == null || _currPublishDistribution == null) {
            throw new WCMException(sDesc + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label7", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6307\u5b9a\u7ad9\u70b9\u6216\u53d1\u5e03\u5206\u53d1\u4fe1\u606f\uff01"));
        }
        int nRightIndex = 1;
        if (!AuthServer.hasRight(ContextHelper.getLoginUser(), (CMSObj)_currSite, nRightIndex)) {
            throw new WCMException(sDesc + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label4", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        }
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "DISTRIBUTION_SAVE", sDesc, _currSite);
        try {
            _currPublishDistribution.setFolder(_currSite.getWCMType(), _currSite.getId());
            PublishDistributionMgr mgr = (PublishDistributionMgr)DreamFactory.createObjectById("PublishDistributionMgr");
            mgr.save(_currPublishDistribution);
            LogServer.endRecordSucceedOperation(lStartTime);
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lStartTime, e);
            throw new WCMException(sDesc + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label5", "\u5931\u8d25!"), e);
        }
        return _currPublishDistribution;
    }

    @Override
    public void setPubDistributionsEnable(WebSite _currSite, String _sPublishDistributionIds, boolean _bEnable) throws WCMException {
        String sDesc = I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label8", "\u5c06[") + _currSite + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label9", "]\u53d1\u5e03\u5206\u53d1\u76ee\u5f55") + (_bEnable ? I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label10", "\u542f\u7528") : I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label11", "\u505c\u6b62")) + "\uff01";
        if (_currSite == null) {
            throw new WCMException(sDesc + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label12", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6307\u5b9a\u7ad9\u70b9\uff01"));
        }
        int nRightIndex = 1;
        if (!AuthServer.hasRight(ContextHelper.getLoginUser(), (CMSObj)_currSite, nRightIndex)) {
            throw new WCMException(sDesc + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label4", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        }
        PublishDistributions aDistributions = PublishDistributions.findByIds(this.getLoginUser(), _sPublishDistributionIds);
        if (aDistributions.isEmpty()) {
            return;
        }
        String sOperType = _bEnable ? "DISTRIBUTION_ENABLE" : "DISTRIBUTION_DISABLE";
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), sOperType, sDesc, _currSite);
        try {
            int nCount = aDistributions.size();
            for (int i = 0; i < nCount; ++i) {
                PublishDistribution aPublishDistribution = (PublishDistribution)aDistributions.getAt(i);
                if (aPublishDistribution == null || _bEnable ^ aPublishDistribution.isEnabled()) continue;
                aPublishDistribution.canEdit(this.getLoginUser());
                aPublishDistribution.setEnabled(_bEnable);
                this.getPublishDistributionMgr().save(aPublishDistribution);
            }
            LogServer.endRecordSucceedOperation(lStartTime);
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lStartTime, e);
            throw new WCMException(sDesc + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label5", "\u5931\u8d25!"), e);
        }
    }

    @Override
    public void deletePublishDistributions(WebSite _currSite, String _sPublishDistributionIds) throws WCMException {
        String sDesc = I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label8", "\u5c06[") + _currSite + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label13", "]\u53d1\u5e03\u5206\u53d1\u76ee\u5f55\u5220\u9664\uff01");
        if (_currSite == null) {
            throw new WCMException(sDesc + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label12", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6307\u5b9a\u7ad9\u70b9\uff01"));
        }
        int nRightIndex = 1;
        if (!AuthServer.hasRight(ContextHelper.getLoginUser(), (CMSObj)_currSite, nRightIndex)) {
            throw new WCMException(sDesc + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label4", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        }
        PublishDistributions aDistributions = PublishDistributions.findByIds(this.getLoginUser(), _sPublishDistributionIds);
        if (aDistributions.isEmpty()) {
            return;
        }
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "DISTRIBUTION_DELETE", sDesc, _currSite);
        try {
            int nCount = aDistributions.size();
            for (int i = 0; i < nCount; ++i) {
                PublishDistribution aPublishDistribution = (PublishDistribution)aDistributions.getAt(i);
                if (aPublishDistribution == null) continue;
                this.getPublishDistributionMgr().delete(aPublishDistribution);
            }
            LogServer.endRecordSucceedOperation(lStartTime);
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lStartTime, e);
            throw new WCMException(sDesc + I18NMessage.get(WCMPublishElementServiceImpl.class, "WCMPublishElementServiceImpl.label5", "\u5931\u8d25!"), e);
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private String getLoginUserName() {
        return ContextHelper.getLoginUser().getName();
    }

    protected PublishDistributionMgr getPublishDistributionMgr() {
        return (PublishDistributionMgr)DreamFactory.createObjectById("PublishDistributionMgr");
    }

    private IPublishFolder getFolder(BaseChannel _currChannel) throws WCMException {
        return (IPublishFolder)PublishElementFactory.makeElementFrom(_currChannel);
    }

    @Override
    public Iterator getDistributionTargetTypes() throws Exception {
        Map map = PublishServerConfigMapper.getDistributionTargetTypes();
        return map.values().iterator();
    }

    @Override
    public PublishDistributionTargetType lookupDistributionTargetTypeByName(String _sName) throws Exception {
        return PublishServerConfigMapper.lookupDistributionTargetTypeByName(_sName);
    }
}

