/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.impl;

import com.tencent.weibo.api.UserAPI;
import com.tencent.weibo.beans.OAuth;
import com.tencent.weibo.oauthv2.OAuthV2;
import com.trs.scm.sdk.impl.AbstractUserMgr;
import com.trs.scm.sdk.model.MicroUser;
import com.trs.scm.sdk.util.TencentObjectUtil;

public class TencentUserMgr
extends AbstractUserMgr {
    private UserAPI m_oUserAPI = new UserAPI("2.a");
    private OAuthV2 m_oTencentOAuth = new OAuthV2();

    public TencentUserMgr(com.trs.scm.sdk.model.OAuth _oAuth) {
        super(_oAuth);
        this.m_oTencentOAuth.setAccessToken(_oAuth.getOAuth_token());
        this.m_oTencentOAuth.setOpenid(_oAuth.getOAuth_token_secret());
        this.m_oTencentOAuth.setClientId(_oAuth.getAppKey());
    }

    @Override
    public MicroUser showUser() throws Exception {
        String sResponse = this.m_oUserAPI.info((OAuth)this.m_oTencentOAuth, "json");
        MicroUser oUser = TencentObjectUtil.constructMicroUser(sResponse);
        return oUser;
    }

    @Override
    public MicroUser findUserById(String userId) throws Exception {
        if (userId == null || userId.length() == 0) {
            throw new Exception("\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sResponse = this.m_oUserAPI.otherInfo((OAuth)this.m_oTencentOAuth, "json", "", userId);
        MicroUser oUser = TencentObjectUtil.constructMicroUser(sResponse, false);
        return oUser;
    }

    @Override
    public MicroUser findUserByNickName(String nickName) throws Exception {
        if (nickName == null || nickName.length() == 0) {
            throw new Exception("\u7528\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sResponse = this.m_oUserAPI.otherInfo((OAuth)this.m_oTencentOAuth, "json", nickName, "");
        MicroUser oUser = TencentObjectUtil.constructMicroUser(sResponse, false);
        return oUser;
    }
}

