/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scene.tools;

import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.scene.tools.SceneNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Stack;
import org.apache.log4j.Logger;

public class SceneNodeParser {
    private static Logger logger = Logger.getLogger(SceneNodeParser.class);
    private char m_cSplitChar = (char)9;
    private Stack m_ClassInfoStack = new Stack();

    public SceneNode importFormFileByName(String _sFileName) throws Exception {
        FileService file = new FileService(_sFileName);
        if (!file.exists()) {
            try {
                String sFilePath = FilesMan.getFilesMan().mapFilePath(_sFileName, 0);
                file = new FileService(sFilePath + _sFileName);
                if (!file.exists() || !file.isFile()) {
                    throw new WCMException("\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=" + _sFileName + "]");
                }
            }
            catch (Exception e) {
                throw new WCMException("\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=" + _sFileName + "]");
            }
        }
        InputStreamReader fileReader = null;
        InputStream fis = null;
        BufferedReader buffReader = null;
        SceneNode oRootNode = null;
        try {
            String sLine;
            fis = file.getInputStream();
            buffReader = new BufferedReader(new InputStreamReader(fis, "GBK"));
            int nLineCount = 0;
            while ((sLine = buffReader.readLine()) != null) {
                ++nLineCount;
                if (sLine.trim().length() == 0) continue;
                int nTabCount = this.getTabCount(sLine, this.m_cSplitChar);
                SceneNode parentNode = this.makeParentNode(nTabCount - 1);
                if (nTabCount > 0 && parentNode == null) {
                    throw new WCMException("\u6587\u4ef6\u7b2c[" + nLineCount + "]\u884c\u6570\u636e\u5b58\u5728\u95ee\u9898\uff01\u662f\u4e0d\u662f\u591a\u952e\u5165\u4e86Tab\u4e2a\u6570\uff1fTab\u4e2a\u6570\u4e3a[" + nTabCount + "]\u4e2a\uff01");
                }
                String cNameAndCode = sLine.trim();
                String[] aInfos = cNameAndCode.split(this.m_cSplitChar + "+");
                String sName = "";
                String sCode = "";
                if (aInfos.length > 1) {
                    sCode = aInfos[0];
                    sName = aInfos[1];
                } else if (aInfos.length > 0) {
                    sName = aInfos[0];
                }
                SceneNode currNode = null;
                if (parentNode == null) {
                    oRootNode = currNode = new SceneNode(sName, 1);
                    currNode = currNode.addChildNode("\u7b2c\u4e00\u6761\u8fde\u7ebf", nTabCount);
                    logger.info((Object)("\u7b2c\u4e00\u4e2a\u8282\u70b9\uff01[" + sName + "]"));
                } else {
                    currNode = parentNode.addChildNode(sName, nTabCount);
                }
                this.m_ClassInfoStack.push(currNode);
            }
        }
        catch (FileNotFoundException ex) {
            throw new Exception("\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230[File=" + _sFileName + "]", ex);
        }
        catch (IOException ex) {
            throw new Exception("\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef[File=" + _sFileName + "]", ex);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        this.supplementLastNode(oRootNode);
        return oRootNode;
    }

    private void supplementLastNode(SceneNode _node) throws WCMException {
        if (_node.getType() == 3 && (_node.getChildren() == null || _node.getChildren().isEmpty())) {
            _node.addChildNode(_node.getName(), _node.getTabCount() + 1);
            return;
        }
        ArrayList arChildren = _node.getChildren();
        for (int j = arChildren.size() - 1; j >= 0; --j) {
            SceneNode child = (SceneNode)arChildren.get(j);
            this.supplementLastNode(child);
        }
    }

    private int getTabCount(String _srcStr, char _cSplitChar) {
        if (_srcStr == null) {
            return -1;
        }
        int position = 0;
        for (int i = 0; i < _srcStr.length() && _srcStr.charAt(i) == _cSplitChar; ++i) {
            ++position;
        }
        return position;
    }

    private SceneNode makeParentNode(int _nCurrLevel) {
        if (this.m_ClassInfoStack.isEmpty() || _nCurrLevel == -1) {
            return null;
        }
        SceneNode oParentNode = (SceneNode)this.m_ClassInfoStack.peek();
        while (oParentNode != null) {
            int nTopLevel = oParentNode.getTabCount();
            if (_nCurrLevel >= nTopLevel) {
                return oParentNode;
            }
            this.m_ClassInfoStack.pop();
            if (this.m_ClassInfoStack.isEmpty()) {
                return null;
            }
            oParentNode = (SceneNode)this.m_ClassInfoStack.peek();
        }
        return null;
    }

    public static void main(String[] args) {
        String sPath = "c:\\\u573a\u666f\u5f0f\u670d\u52a1\u6279\u91cf\u521b\u5efa\\";
        try {
            FileService filePath = new FileService(sPath);
            FileStore[] pFiles = filePath.listFiles();
            for (int i = 0; i < pFiles.length; ++i) {
                int nStartPos;
                FileStore file = pFiles[i];
                String sFileName = file.getName();
                int nEndPos = sFileName.indexOf(46, nStartPos = sFileName.lastIndexOf(File.separatorChar));
                if (nEndPos < 0) continue;
                SceneNodeParser util = new SceneNodeParser();
                SceneNode sceneNode = util.importFormFileByName(file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

