/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.common;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

public class PageViewConstants {
    public static final int TREE_TYPE_NORMAL = 0;
    public static final int TREE_TYPE_CHECKBOX = 1;
    public static final int TREE_TYPE_RADIOBOX = 2;
    public static final int TREE_OPERATION_OTHER = 0;
    public static final int TREE_OPERATION_DOCUMENT = 1;
    public static final int TREE_OPERATION_SITE = 2;
    public static final int TREE_OPERATION_TEMPLATE = 3;
    public static final int TREE_OPERATION_PORTAL = 4;
    public static final int TREE_OPERATION_SYSUSER_MGR = 10;
    public static final int TREE_OPERATION_GRPUSER_SEL = 11;
    public static final int TREE_OPERATION_GRPUSER_SEL_SPECIAL = 23;
    public static final int TREE_OPERATION_GRPUSER_MGR = 12;
    public static final int TREE_OPERATION_ROLEUSER_SEL = 13;
    public static final int TREE_OPERATION_ROLEUSER_MGR = 14;
    public static final int TREE_OPERATION_GROUP_SEL = 19;
    public static final int OPER_DOCUMENT_MOVE = 10;
    public static final int OPER_DOCUMENT_COPY = 20;
    public static final int OPER_DOCUMENT_QUOTE = 30;
    public static final int OPER_DOCUMENT_MIRROR = 40;
    public static final String OPER_ROOT_URL_KEY = "OPER_ROOT_URL";
    public static final String OPER_NODE_URL_KEY = "OPER_NODE_URL";
    public static final String FILE_VIEW_CONFIG = "/TRSWCMView.ini";
    private static Properties s_oProperties = null;

    public static final String getOperRootURL(int _nOperationType) throws WCMException {
        return PageViewConstants.getViewConfigValue(OPER_ROOT_URL_KEY + _nOperationType);
    }

    public static final String getOperNodeURL(int _nOperationType) throws WCMException {
        return PageViewConstants.getViewConfigValue(OPER_NODE_URL_KEY + _nOperationType);
    }

    public static final String getViewConfigValue(String _sKey) throws WCMException {
        if (s_oProperties == null) {
            PageViewConstants.loadProperties();
        }
        return CMyString.showNull(s_oProperties.getProperty(_sKey));
    }

    private static final void loadProperties() throws WCMException {
        InputStream isConfig = null;
        try {
            isConfig = new FileService(CMyFile.mapResouceFullPath(FILE_VIEW_CONFIG, PageViewConstants.class)).getInputStream();
            if (isConfig == null) {
                throw new WCMException(55, I18NMessage.get(PageViewConstants.class, "PageViewConstants.label1", "\u8868\u73b0\u5c42\u914d\u7f6e\u6587\u4ef6[") + FILE_VIEW_CONFIG + I18NMessage.get(PageViewConstants.class, "PageViewConstants.label2", "]\u6ca1\u6709\u627e\u5230\uff01"));
            }
        }
        catch (Exception ex) {
            throw new WCMException(55, I18NMessage.get(PageViewConstants.class, "PageViewConstants.label1", "\u8868\u73b0\u5c42\u914d\u7f6e\u6587\u4ef6[") + FILE_VIEW_CONFIG + I18NMessage.get(PageViewConstants.class, "PageViewConstants.label2", "]\u6ca1\u6709\u627e\u5230\uff01"), ex);
        }
        try {
            s_oProperties = new Properties();
            s_oProperties.load(isConfig);
        }
        catch (IOException ex) {
            throw new WCMException(55, I18NMessage.get(PageViewConstants.class, "PageViewConstants.label1", "\u8868\u73b0\u5c42\u914d\u7f6e\u6587\u4ef6[") + FILE_VIEW_CONFIG + I18NMessage.get(PageViewConstants.class, "PageViewConstants.label2", "]\u6ca1\u6709\u627e\u5230\uff01"), ex);
        }
        finally {
            try {
                if (isConfig != null) {
                    isConfig.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static final void reloadProperties() throws WCMException {
        PageViewConstants.clear();
        PageViewConstants.loadProperties();
    }

    public static final Enumeration getPropertyNames() throws WCMException {
        return PageViewConstants.getProperties().keys();
    }

    protected static Properties getProperties() throws WCMException {
        if (s_oProperties == null) {
            PageViewConstants.loadProperties();
        }
        return s_oProperties;
    }

    private static void clear() {
        if (s_oProperties == null) {
            return;
        }
        s_oProperties.clear();
        s_oProperties = null;
    }

    public static void main(String[] args) {
        try {
            Enumeration enNames = PageViewConstants.getPropertyNames();
            String sName = null;
            while (enNames.hasMoreElements()) {
                sName = enNames.nextElement().toString();
                System.out.println(sName + ":" + PageViewConstants.getViewConfigValue(sName));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

