/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.jazzlib;

import com.trs.infra.util.jazzlib.CRC32;
import com.trs.infra.util.jazzlib.Inflater;
import com.trs.infra.util.jazzlib.InflaterInputStream;
import com.trs.infra.util.jazzlib.ZipConstants;
import com.trs.infra.util.jazzlib.ZipEntry;
import com.trs.infra.util.jazzlib.ZipException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ZipInputStream
extends InflaterInputStream
implements ZipConstants {
    private CRC32 crc = new CRC32();
    private ZipEntry entry = null;
    private int csize;
    private int size;
    private int method;
    private int flags;
    private int avail;

    public ZipInputStream(InputStream in) {
        super(in, new Inflater(true));
    }

    private void fillBuf() throws IOException {
        this.avail = this.len = this.in.read(this.buf, 0, this.buf.length);
    }

    private int readBuf(byte[] out, int offset, int length) throws IOException {
        if (this.avail <= 0) {
            this.fillBuf();
            if (this.avail <= 0) {
                return -1;
            }
        }
        if (length > this.avail) {
            length = this.avail;
        }
        System.arraycopy(this.buf, this.len - this.avail, out, offset, length);
        this.avail -= length;
        return length;
    }

    private void readFully(byte[] out) throws IOException {
        int count;
        int off = 0;
        for (int len = out.length; len > 0; len -= count) {
            count = this.readBuf(out, off, len);
            if (count == -1) {
                throw new EOFException();
            }
            off += count;
        }
    }

    private final int readLeByte() throws IOException {
        if (this.avail <= 0) {
            this.fillBuf();
            if (this.avail <= 0) {
                throw new ZipException("EOF in header");
            }
        }
        return this.buf[this.len - this.avail--] & 0xFF;
    }

    private final int readLeShort() throws IOException {
        return this.readLeByte() | this.readLeByte() << 8;
    }

    private final int readLeInt() throws IOException {
        return this.readLeShort() | this.readLeShort() << 16;
    }

    public ZipEntry getNextEntry() throws IOException {
        return this.getNextEntry(null);
    }

    public ZipEntry getNextEntry(String _encoding) throws IOException {
        int header;
        if (this.crc == null) {
            throw new IllegalStateException("Closed.");
        }
        if (this.entry != null) {
            this.closeEntry();
        }
        if ((header = this.readLeInt()) == 33639248) {
            this.close();
            return null;
        }
        if (header != 67324752) {
            throw new ZipException("Wrong Local header signature" + Integer.toHexString(header));
        }
        this.readLeShort();
        this.flags = this.readLeShort();
        this.method = this.readLeShort();
        int dostime = this.readLeInt();
        int crc = this.readLeInt();
        this.csize = this.readLeInt();
        this.size = this.readLeInt();
        int nameLen = this.readLeShort();
        int extraLen = this.readLeShort();
        if (this.method == 0 && this.csize != this.size) {
            throw new ZipException("Stored, but compressed != uncompressed");
        }
        byte[] buffer = new byte[nameLen];
        this.readFully(buffer);
        String name = _encoding == null ? new String(buffer) : new String(buffer, _encoding);
        this.entry = new ZipEntry(name);
        this.entry.setMethod(this.method);
        if ((this.flags & 8) == 0) {
            this.entry.setCrc((long)crc & 0xFFFFFFFFL);
            this.entry.setSize((long)this.size & 0xFFFFFFFFL);
            this.entry.setCompressedSize((long)this.csize & 0xFFFFFFFFL);
        }
        this.entry.setDOSTime(dostime);
        if (extraLen > 0) {
            byte[] extra = new byte[extraLen];
            this.readFully(extra);
            this.entry.setExtra(extra);
        }
        if (this.method == 8 && this.avail > 0) {
            System.arraycopy(this.buf, this.len - this.avail, this.buf, 0, this.avail);
            this.len = this.avail;
            this.avail = 0;
            this.inf.setInput(this.buf, 0, this.len);
        }
        return this.entry;
    }

    private void readDataDescr() throws IOException {
        if (this.readLeInt() != 134695760) {
            throw new ZipException("Data descriptor signature not found");
        }
        this.entry.setCrc((long)this.readLeInt() & 0xFFFFFFFFL);
        this.csize = this.readLeInt();
        this.size = this.readLeInt();
        this.entry.setSize((long)this.size & 0xFFFFFFFFL);
        this.entry.setCompressedSize((long)this.csize & 0xFFFFFFFFL);
    }

    public void closeEntry() throws IOException {
        if (this.crc == null) {
            throw new IllegalStateException("Closed.");
        }
        if (this.entry == null) {
            return;
        }
        if (this.method == 8) {
            if ((this.flags & 8) != 0) {
                byte[] tmp = new byte[2048];
                while (this.read(tmp) > 0) {
                }
                return;
            }
            this.csize -= this.inf.getTotalIn();
            this.avail = this.inf.getRemaining();
        }
        if (this.avail > this.csize && this.csize >= 0) {
            this.avail -= this.csize;
        } else {
            this.csize -= this.avail;
            this.avail = 0;
            while (this.csize != 0) {
                long skipped = this.in.skip((long)this.csize & 0xFFFFFFFFL);
                if (skipped <= 0L) {
                    throw new ZipException("zip archive ends early.");
                }
                this.csize = (int)((long)this.csize - skipped);
            }
        }
        this.size = 0;
        this.crc.reset();
        if (this.method == 8) {
            this.inf.reset();
        }
        this.entry = null;
    }

    @Override
    public int available() throws IOException {
        return this.entry != null ? 1 : 0;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) <= 0) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.crc == null) {
            throw new IllegalStateException("Closed.");
        }
        if (this.entry == null) {
            return -1;
        }
        boolean finished = false;
        switch (this.method) {
            case 8: {
                len = super.read(b, off, len);
                if (len >= 0) break;
                if (!this.inf.finished()) {
                    throw new ZipException("Inflater not finished!?");
                }
                this.avail = this.inf.getRemaining();
                if ((this.flags & 8) != 0) {
                    this.readDataDescr();
                }
                if (this.inf.getTotalIn() != this.csize || this.inf.getTotalOut() != this.size) {
                    throw new ZipException("size mismatch: " + this.csize + ";" + this.size + " <-> " + this.inf.getTotalIn() + ";" + this.inf.getTotalOut());
                }
                this.inf.reset();
                finished = true;
                break;
            }
            case 0: {
                if (len > this.csize && this.csize >= 0) {
                    len = this.csize;
                }
                if ((len = this.readBuf(b, off, len)) > 0) {
                    this.csize -= len;
                    this.size -= len;
                }
                if (this.csize == 0) {
                    finished = true;
                    break;
                }
                if (len >= 0) break;
                throw new ZipException("EOF in stored block");
            }
        }
        if (len > 0) {
            this.crc.update(b, off, len);
        }
        if (finished) {
            if ((this.crc.getValue() & 0xFFFFFFFFL) != this.entry.getCrc()) {
                throw new ZipException("CRC mismatch");
            }
            this.crc.reset();
            this.entry = null;
        }
        return len;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.crc = null;
        this.entry = null;
    }

    protected ZipEntry createZipEntry(String name) {
        return new ZipEntry(name);
    }
}

