/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.ClusterDBIdManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class DBIdManager {
    private static Logger logger = Logger.getLogger(DBIdManager.class);
    public static boolean ISDEBUG = false;
    private Hashtable hBuffer = new Hashtable(50);
    private String sqlGetNextId = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DBIdManager load(Connection _oConn, String _sGetNextIdSQL) throws WCMException {
        String sql = "select TABLENAME,IDFIELDNAME from WCMID where NEXTID=0";
        Statement stmt = null;
        ResultSet rs = null;
        Statement pstmt = null;
        try {
            stmt = _oConn.createStatement();
            this.removeInvalidData(stmt);
            rs = stmt.executeQuery(sql);
            HashMap<String, String> tables = new HashMap<String, String>(20, 1.0f);
            while (rs.next()) {
                tables.put(rs.getString(1), rs.getString(2));
            }
            rs.close();
            if (tables.isEmpty()) {
                DBIdManager dBIdManager = this;
                return dBIdManager;
            }
            sql = "update WCMID set NEXTID=? where TABLENAME=? and NEXTID=0";
            pstmt = _oConn.prepareStatement(sql);
            Iterator itrTabs = tables.entrySet().iterator();
            StringBuffer buff = new StringBuffer(256);
            while (itrTabs.hasNext()) {
                Map.Entry table = itrTabs.next();
                String tablename = (String)table.getKey();
                buff.setLength(0);
                buff.append("select max(");
                buff.append(CMyString.filterForSQL2((String)table.getValue()));
                buff.append(")+1 from ");
                buff.append(CMyString.filterForSQL2(tablename));
                int id = 0;
                try {
                    rs = stmt.executeQuery(buff.toString());
                    if (rs.next()) {
                        id = rs.getInt(1);
                    }
                    if (id == 0) {
                        id = 1;
                    }
                }
                catch (SQLException e) {
                    if (logger.isDebugEnabled()) {
                        logger.fatal((Object)"warn:", (Throwable)e);
                    } else {
                        logger.fatal((Object)("warn: execute sql failed." + buff));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
                pstmt.setInt(1, id);
                pstmt.setString(2, tablename);
                pstmt.executeUpdate();
            }
            tables.clear();
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(DBIdManager.class, "DBIdManager.label1", "\u83b7\u53d6\u6570\u636e\u8868ID\u503c\u4fe1\u606f\u5931\u8d25\uff08DBIdManager.load\uff09"), ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        return this;
    }

    private void removeInvalidData(Statement stmt) throws SQLException {
        String sql = "delete from WCMID where tablename='WCMID' or IDFIELDNAME is null";
        stmt.executeUpdate(sql);
    }

    private int refreshIdSeqFromDB(IdSeq _idSeq, Connection _oConn, String _sTableName, String _sIdField) throws WCMException {
        Statement oStmt = null;
        ResultSet rsMax = null;
        String strSQL = null;
        try {
            strSQL = "select MAX(" + _sIdField + ") from " + _sTableName;
            oStmt = _oConn.createStatement();
            rsMax = oStmt.executeQuery(strSQL);
            int nNextId = rsMax.next() ? rsMax.getInt(1) + 1 : 1;
            rsMax.close();
            rsMax = null;
            if (_idSeq == null) {
                _idSeq = new IdSeq();
                _idSeq.setNextId(nNextId);
                this.hBuffer.put(_sTableName, _idSeq);
                strSQL = "insert into WCMID(TABLENAME,NEXTID,CACHESIZE) values('" + _sTableName + "'," + (_idSeq.getMaxId() + 1) + "," + _idSeq.getCacheSize() + ")";
            } else {
                _idSeq.setNextId(nNextId);
                strSQL = "update WCMID set NEXTID=" + (_idSeq.getMaxId() + 1) + " where TABLENAME='" + _sTableName + "'";
            }
            oStmt.executeUpdate(strSQL);
            int n = _idSeq.getNextId();
            return n;
        }
        catch (Exception ex) {
            logger.error((Object)"==============strSQL============");
            logger.error(strSQL);
            logger.error((Object)"==============hBuffer============");
            logger.error((Object)this.hBuffer);
            throw new WCMException(1100, I18NMessage.get(DBIdManager.class, "DBIdManager.label2", "\u4e3a\u6570\u636e\u8868") + _sTableName + I18NMessage.get(DBIdManager.class, "DBIdManager.label3", "\u66f4\u65b0ID\u4fe1\u606f\u8bb0\u5f55\u65f6\u5931\u8d25\uff08DBIdManager.refreshIdSeqFromDB\uff09"), ex);
        }
        finally {
            if (rsMax != null) {
                try {
                    rsMax.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private int getNextIdFromDB(IdSeq _idSeq, Connection _oConn, String _sTableName) throws WCMException {
        Statement oCallStmt = null;
        Statement oStmt = null;
        ResultSet rsData = null;
        try {
            int nNextId;
            if (this.sqlGetNextId != null) {
                oCallStmt = _oConn.prepareCall(this.sqlGetNextId);
                oCallStmt.setString(1, _sTableName);
                oCallStmt.setInt(2, _idSeq.getCacheSize());
                oCallStmt.registerOutParameter(3, 4);
                oCallStmt.executeUpdate();
                nNextId = oCallStmt.getInt(3);
            } else {
                String strSQL = "select NEXTID from WCMID where TABLENAME='" + _sTableName + "'";
                oStmt = _oConn.createStatement();
                rsData = oStmt.executeQuery(strSQL);
                rsData.next();
                nNextId = rsData.getInt(1);
                rsData.close();
                rsData = null;
                strSQL = "update WCMID set NEXTID=NEXTID+" + _idSeq.getCacheSize() + " where TABLENAME='" + _sTableName + "'";
                oStmt.executeUpdate(strSQL);
            }
            _idSeq.setNextId(nNextId);
            int strSQL = _idSeq.getNextId();
            return strSQL;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(DBIdManager.class, "DBIdManager.label4", "\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u8868") + _sTableName + I18NMessage.get(DBIdManager.class, "DBIdManager.label5", "\u7684\u4e0b\u4e00\u4e2aID\u503c\u65f6\u5931\u8d25\uff08DBIdManager.getNextIdFromDB\uff09"), ex);
        }
        finally {
            if (oCallStmt != null) {
                try {
                    oCallStmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public synchronized int getNextId(BaseObj _obj, Connection _oConn, boolean _bAddIfNotExist) throws WCMException {
        if (_obj == null) {
            throw new WCMException(10, I18NMessage.get(DBIdManager.class, "DBIdManager.label6", "\u65e0\u6548\u53c2\u6570:WCMObj\u5bf9\u8c61\u4e3a\u7a7a\uff08DBIdManager.getNextId\uff09"));
        }
        String sTableName = _obj.getDbTableName();
        return this.getNextId(sTableName, _obj.getIdFieldName(), _oConn, _bAddIfNotExist);
    }

    public int getNextId(String _sTableName, String _sIdFieldName, Connection _oConn, boolean _bAddIfNotExist) throws WCMException {
        return ClusterDBIdManager.getNextId(_sTableName, _sIdFieldName);
    }

    public class IdSeq {
        public static final int CACHESIZE_DEFAULT = 5;
        private int nextId;
        private int maxId = 0;
        private int cacheSize = 5;

        public IdSeq() {
            this(0, 0);
        }

        public IdSeq(int _nextId) {
            this(_nextId, 0);
        }

        public IdSeq(int _nextId, int _cacheSize) {
            this.setCacheSize(_cacheSize);
            this.nextId = _nextId;
        }

        public int getCacheSize() {
            return this.cacheSize;
        }

        public IdSeq setCacheSize(int _cacheSize) {
            this.cacheSize = _cacheSize < 1 ? 1 : _cacheSize;
            return this;
        }

        public int getMaxId() {
            return this.maxId;
        }

        public synchronized int getNextId() {
            if (ISDEBUG) {
                System.out.print("\n NextId=" + this.nextId + " MaxId=" + this.maxId);
            }
            if (this.nextId < 1) {
                return 0;
            }
            if (this.nextId <= this.maxId) {
                return this.nextId++;
            }
            return -1;
        }

        public synchronized IdSeq setNextId(int _nextId) {
            if (this.nextId >= this.maxId && _nextId > this.maxId) {
                this.nextId = _nextId;
                this.maxId = this.nextId + this.cacheSize - 1;
            }
            return this;
        }
    }
}

