/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.config;

import com.trs.infra.config.TRSConfigServer;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.Loader;
import com.trs.infra.util.store.FileService;
import java.io.File;
import java.net.URL;

public final class ConfigConstants {
    public static String DIR_APPROOT = ConfigConstants.makeAppRootPath();
    public static String DIR_CLASSROOT = ConfigConstants.makeClassRootPath();
    public static final String EXT_FILE_CONFIG = "xml";
    public static final String NAME_FILE_CONFIG = "config.xml";
    public static final String NAME_FILE_BEAN = "beans.xml";
    public static final String TAG_ELEMENT_BEANS = "beans";
    public static final String TAG_ELEMENT_BEAN = "bean";
    public static final String TAG_ATTRIBUTE_BEANID = "id";
    public static final String TAG_ATTRIBUTE_BEANCLASSNAME = "class";
    public static final String NAME_FILE_MAPPING = "mapping.xml";
    public static final String TAG_ATTRIBUTE_BEANISSINGLETON = "singleton";
    public static final int ERR_FORMAT_INVALID = 3000;

    private static String makeAppRootPath() {
        URL url = Loader.getResource(TRSConfigServer.FILENAME_APP_PROPERTIES);
        if (url == null) {
            throw new RuntimeException("Cannot find file[" + TRSConfigServer.FILENAME_APP_PROPERTIES + "] at the root of application!");
        }
        String sPropertiesFilePath = null;
        sPropertiesFilePath = url.getFile();
        FileService file = new FileService(sPropertiesFilePath);
        String sPath = file.getAbsolutePath();
        if (File.separatorChar == '\\') {
            sPath = sPath.replace('/', '\\');
        }
        sPath = CMyFile.extractFilePath(sPath);
        return sPath;
    }

    private static String makeClassRootPath() {
        try {
            URL url = Loader.getResource("RootFile.trs");
            if (url == null) {
                throw new RuntimeException("Cannot find file[" + TRSConfigServer.FILENAME_APP_PROPERTIES + "] at the root of application!");
            }
            String sPropertiesFilePath = null;
            sPropertiesFilePath = url.getFile();
            FileService file = new FileService(sPropertiesFilePath);
            String sPath = file.getAbsolutePath();
            if (File.separatorChar == '\\') {
                sPath = sPath.replace('/', '\\');
            }
            sPath = CMyFile.extractFilePath(sPath);
            return sPath;
        }
        catch (Throwable e) {
            return ConfigConstants.makeAppRootPath();
        }
    }

    public static String getAbsoluteFileNameOfCoreMapping() {
        return ConfigConstants.getConfigRootPath() + NAME_FILE_MAPPING;
    }

    public static String getAbsoluteFileNameOfCoreConfigXML() {
        return ConfigConstants.getConfigRootPath() + NAME_FILE_CONFIG;
    }

    public static String getAbsoluteFileNameOfCoreBeansXML() {
        return ConfigConstants.getConfigRootPath() + NAME_FILE_BEAN;
    }

    public static String getConfigRootPath() {
        try {
            return TRSConfigServer.getConfigRootPath() + "domain" + File.separator;
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to read config path!", e);
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println(DIR_APPROOT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

