/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.version.file;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.version.file.FileVersion;
import com.trs.components.wcm.version.file.FileVersions;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class FileVersionMgr {
    public static final String VERSION_FOLDER_NAME = "version";
    public static final String VERSION_FILE_SEPRATOR = "_v";

    public int buildVersion(String _sFileName) throws WCMException {
        if (_sFileName == null) {
            throw new WCMException(I18NMessage.get(FileVersionMgr.class, "FileVersionMgr.lable2", "\u6587\u4ef6\u4ea7\u751f\u7248\u672c\u65f6\u53c2\u6570\u9519\u8bef"));
        }
        String sFileFlag = this.getFileFlag(_sFileName);
        if (CMyString.isEmpty(sFileFlag)) {
            throw new WCMException(I18NMessage.get(FileVersionMgr.class, "FileVersionMgr.lable1", "\u6587\u4ef6\u540d\u4e0d\u7b26\u5408WCM\u547d\u540d\u89c4\u8303"));
        }
        String sCurFilePath = this.getFilePath(_sFileName, sFileFlag);
        String sFileNameNoSuffix = CMyFile.extractMainFileName(sCurFilePath);
        String sFileSuffix = CMyFile.extractFileExt(sCurFilePath);
        String sFilePathNoFileName = CMyFile.extractFilePath(sCurFilePath);
        FileVersion lastedFileVersion = this.getLastedVersion(_sFileName);
        if (lastedFileVersion == null) {
            int nNewVersionNum = 1;
            String sVersionFilePath = sFilePathNoFileName + File.separator + VERSION_FOLDER_NAME + File.separator + sFileNameNoSuffix + VERSION_FILE_SEPRATOR + nNewVersionNum + "." + sFileSuffix;
            try {
                CMyFile.copyFile(sCurFilePath, sVersionFilePath, true);
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(FileVersionMgr.class, "FileVersionMgr.lable2", "\u6587\u4ef6\u4ea7\u751f\u7248\u672c\u65f6\u7248\u672c\u6587\u4ef6\u590d\u5236\u5f02\u5e38"));
            }
            String sVersionName = sFileNameNoSuffix + VERSION_FILE_SEPRATOR + nNewVersionNum + "." + sFileSuffix;
            FileVersion fileVersion = new FileVersion();
            fileVersion.setFormerFileName(_sFileName);
            fileVersion.setVersionFileName(sVersionName);
            fileVersion.setVersionNum(nNewVersionNum);
            fileVersion.setUsedVersions(1);
            fileVersion.insert(this.getLoginUser());
            return nNewVersionNum;
        }
        String sLastedFilePath = sFilePathNoFileName + File.separator + VERSION_FOLDER_NAME + File.separator + lastedFileVersion.getVersionFileName();
        if (this.isSameFile(sCurFilePath, sLastedFilePath)) {
            lastedFileVersion.setUsedVersions(lastedFileVersion.getUsedVersions() + 1);
            lastedFileVersion.update(this.getLoginUser());
            return lastedFileVersion.getVersionNum();
        }
        int nNewVersionNum = lastedFileVersion.getVersionNum() + 1;
        String sVersionFilePath = sFilePathNoFileName + File.separator + VERSION_FOLDER_NAME + File.separator + sFileNameNoSuffix + VERSION_FILE_SEPRATOR + nNewVersionNum + "." + sFileSuffix;
        try {
            CMyFile.copyFile(sCurFilePath, sVersionFilePath, true);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(FileVersionMgr.class, "FileVersionMgr.lable3", "\u6587\u4ef6\u4ea7\u751f\u7248\u672c\u65f6\u7248\u672c\u6587\u4ef6\u590d\u5236\u5f02\u5e38"));
        }
        String sVersionName = sFileNameNoSuffix + VERSION_FILE_SEPRATOR + nNewVersionNum + "." + sFileSuffix;
        FileVersion fileVersion = new FileVersion();
        fileVersion.setFormerFileName(_sFileName);
        fileVersion.setVersionFileName(sVersionName);
        fileVersion.setVersionNum(nNewVersionNum);
        fileVersion.setUsedVersions(1);
        fileVersion.insert(this.getLoginUser());
        return nNewVersionNum;
    }

    public void recover(String _sFileName, int _nVersion) throws WCMException {
        if (_sFileName == null) {
            throw new WCMException(I18NMessage.get(FileVersionMgr.class, "FileVersionMgr.lable4", "\u6587\u4ef6\u7248\u672c\u6062\u590d\u65f6\u53c2\u6570\u9519\u8bef"));
        }
        String sFileFlag = this.getFileFlag(_sFileName);
        if (CMyString.isEmpty(sFileFlag)) {
            throw new WCMException(I18NMessage.get(FileVersionMgr.class, "FileVersionMgr.lable1", "\u6587\u4ef6\u540d\u4e0d\u7b26\u5408WCM\u547d\u540d\u89c4\u8303"));
        }
        WCMFilter filter = new WCMFilter("", "VERSIONNUM=? and FORMERFILENAME=?", "", "", 1);
        filter.addSearchValues(_nVersion);
        filter.addSearchValues(_sFileName);
        FileVersions fileVersions = FileVersions.openWCMObjs(this.getLoginUser(), filter);
        if (fileVersions != null && fileVersions.size() > 0) {
            FileVersion fileVersion = (FileVersion)fileVersions.getAt(0);
            String sCurFilePath = this.getFilePath(_sFileName, sFileFlag);
            String sFilePathNoFileName = CMyFile.extractFilePath(sCurFilePath);
            String sVersionFilePath = sFilePathNoFileName + File.separator + VERSION_FOLDER_NAME + File.separator + fileVersion.getVersionFileName();
            try {
                CMyFile.copyFile(sVersionFilePath, sCurFilePath, true);
            }
            catch (CMyException e) {
                throw new WCMException(I18NMessage.get(FileVersionMgr.class, "FileVersionMgr.lable5", "\u6587\u4ef6\u7248\u672c\u6062\u590d\u65f6\u590d\u5236\u5f02\u5e38"));
            }
        } else {
            throw new WCMException(I18NMessage.get(FileVersionMgr.class, "FileVersionMgr.lable2", "\u6587\u4ef6\u6062\u590d\u5f02\u5e38\uff0c\u6587\u4ef6\u540d\u9519\u8bef\u6216\u65e0\u6b64\u7248\u672c\u6587\u4ef6\u4fe1\u606f"));
        }
    }

    public void deleteAllVersion(String _sFileName) throws WCMException {
        if (_sFileName == null) {
            throw new WCMException(I18NMessage.get(FileVersionMgr.class, "FileVersionMgr.lable6", "\u6587\u4ef6\u5220\u9664\u7248\u672c\u65f6\u53c2\u6570\u9519\u8bef"));
        }
        String sFileFlag = this.getFileFlag(_sFileName);
        if (CMyString.isEmpty(sFileFlag)) {
            throw new WCMException(I18NMessage.get(FileVersionMgr.class, "FileVersionMgr.lable1", "\u6587\u4ef6\u540d\u4e0d\u7b26\u5408WCM\u547d\u540d\u89c4\u8303"));
        }
        WCMFilter filter = new WCMFilter("", "FORMERFILENAME=?", "", "");
        filter.addSearchValues(_sFileName);
        FileVersions fileVersions = FileVersions.openWCMObjs(this.getLoginUser(), filter);
        for (int i = 0; i < fileVersions.size(); ++i) {
            FileVersion fileVersion = (FileVersion)fileVersions.getAt(i);
            String sCurFilePath = this.getFilePath(_sFileName, sFileFlag);
            String sFilePathNoFileName = CMyFile.extractFilePath(sCurFilePath);
            String sVersionFilePath = sFilePathNoFileName + File.separator + VERSION_FOLDER_NAME + File.separator + fileVersion.getVersionFileName();
            try {
                CMyFile.deleteFile(sVersionFilePath);
                fileVersion.delete(this.getLoginUser());
                continue;
            }
            catch (WCMException e) {
                // empty catch block
            }
        }
    }

    public void deleteFileVersion(String _sFileName, int _nVersionNum) throws WCMException {
        System.out.println("==================================================" + _sFileName);
        if (_sFileName == null) {
            throw new WCMException(I18NMessage.get(FileVersionMgr.class, "FileVersionMgr.lable6", "\u6587\u4ef6\u5220\u9664\u7248\u672c\u65f6\u53c2\u6570\u9519\u8bef"));
        }
        String sFileFlag = this.getFileFlag(_sFileName);
        if (CMyString.isEmpty(sFileFlag)) {
            throw new WCMException(I18NMessage.get(FileVersionMgr.class, "FileVersionMgr.lable1", "\u6587\u4ef6\u540d\u4e0d\u7b26\u5408WCM\u547d\u540d\u89c4\u8303"));
        }
        WCMFilter filter = new WCMFilter("", "FORMERFILENAME=? and VERSIONNUM=?", "", "");
        filter.addSearchValues(_sFileName);
        filter.addSearchValues(_nVersionNum);
        FileVersions fileVersions = FileVersions.openWCMObjs(this.getLoginUser(), filter);
        if (fileVersions != null && fileVersions.size() > 0) {
            FileVersion fileVersion = (FileVersion)fileVersions.getAt(0);
            int nUsedVeriosns = fileVersion.getUsedVersions() - 1;
            if (nUsedVeriosns > 0) {
                fileVersion.setUsedVersions(nUsedVeriosns);
                fileVersion.update(this.getLoginUser());
            } else {
                String sCurFilePath = this.getFilePath(_sFileName, sFileFlag);
                String sFilePathNoFileName = CMyFile.extractFilePath(sCurFilePath);
                String sVersionFilePath = sFilePathNoFileName + File.separator + VERSION_FOLDER_NAME + File.separator + fileVersion.getVersionFileName();
                CMyFile.deleteFile(sVersionFilePath);
                fileVersion.delete(this.getLoginUser());
            }
        }
    }

    private FileVersion getLastedVersion(String _sFileName) throws WCMException {
        WCMFilter afilter = new WCMFilter("", "FORMERFILENAME=?", "VERSIONNUM desc", "*", 1);
        afilter.addSearchValues(_sFileName);
        FileVersions fileVersions = FileVersions.openWCMObjs(this.getLoginUser(), afilter);
        if (!fileVersions.isEmpty()) {
            FileVersion fileVersion = (FileVersion)fileVersions.getAt(0);
            return fileVersion;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSameFile(String _sFileName1, String _sFileName2) {
        InputStream fis1 = null;
        InputStream fis2 = null;
        try {
            fis1 = new FileService(_sFileName1).getInputStream();
            fis2 = new FileService(_sFileName2).getInputStream();
            int len1 = fis1.available();
            int len2 = fis2.available();
            if (len1 == len2) {
                byte[] data1 = new byte[len1];
                byte[] data2 = new byte[len2];
                fis1.read(data1);
                fis2.read(data2);
                for (int i = 0; i < len1; ++i) {
                    if (data1[i] == data2[i]) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            boolean data1 = false;
            return data1;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fis1 != null) {
                try {
                    fis1.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fis2 != null) {
                try {
                    fis2.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getFilePath(String _sFileName, String _sFileFlag) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        if (_sFileFlag.equals("TM")) {
            String sFlagPath = filesMan.getPathConfigValue(_sFileFlag, 0);
            if (sFlagPath == null) {
                throw new WCMException(1100, "Path config for " + _sFileFlag + " missing!");
            }
            return sFlagPath + _sFileName;
        }
        _sFileName = CMyFile.extractFileName(_sFileName.trim());
        return filesMan.mapFilePath(_sFileName, 0) + _sFileName;
    }

    private String getFileFlag(String _sFileName) {
        FilesMan filesMan = FilesMan.getFilesMan();
        String sFileFlag = null;
        if (_sFileName.indexOf("..") >= 0) {
            return null;
        }
        sFileFlag = _sFileName.indexOf("site") == 0 || _sFileName.indexOf("root") == 0 ? "TM" : filesMan.getFileFlag(_sFileName);
        return sFileFlag;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

