/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.distribute.FileDistributeShip;
import com.trs.components.common.publish.domain.publisher.PageGenerator;
import com.trs.components.common.publish.domain.publisher.PageNavHelper;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.LoopException;
import com.trs.components.common.publish.domain.tagparser.NestTemplateChecker;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagDocumentReader;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class XWCMTagParserPageGeneration
implements ITagParser {
    protected static Logger logger = Logger.getLogger(XWCMTagParserPageGeneration.class);
    private TagItem m_tagItem = null;
    private static final Set m_oGenerating = new HashSet(32);
    private static TagBeanInfo s_TagBeanInfo = null;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TBI tbi = new TBI();
            tbi.setName("TRS_PAGEGENERATE");
            tbi.setDesc("TRS_PAGEGENERATE");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TEMPNAME");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOUPDATE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("OnlyPublish");
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("EXT");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("filenamedateformat");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("fromdate");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("todate");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public void setTagItem(TagItem _item) {
        this.m_tagItem = _item;
    }

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] parse4Outline(PublishTagContext _context) {
        IPublishElement element;
        if (logger.isDebugEnabled()) {
            logger.info((Object)I18NMessage.get(XWCMTagParserPageGeneration.class, "XWCMTagParserPageGeneration.label1", "===>1.\u5f00\u59cb\u5206\u6790\u7f6e\u6807[TRS_PAGEGENERATE]"));
        }
        if ((element = _context.getUpperHost()) == null) {
            return null;
        }
        IPublishFolder folder = (IPublishFolder)element;
        boolean isPreview = _context.isPreview();
        String sGeneratingFileKey = null;
        try {
            TagItem tagItem = _context.getTagItem();
            Template template = this.getTemplateUsed(element, tagItem);
            if (template == null) {
                String tempName = tagItem.getAttributeTrim("TEMPNAME");
                logger.warn((Object)(I18NMessage.get(XWCMTagParserPageGeneration.class, "XWCMTagParserPageGeneration.label4", "\u4f9d\u636e\u5f53\u524d\u7684\u5bf9\u8c61[") + element + I18NMessage.get(XWCMTagParserPageGeneration.class, "XWCMTagParserPageGeneration.label5", "]\u7684\u4e0a\u4e0b\u6587\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6a21\u677f") + tempName + "\uff01"));
                String[] stringArray = null;
                XWCMTagParserPageGeneration.unregister(sGeneratingFileKey);
                return stringArray;
            }
            if (!isPreview && !XWCMTagParserPageGeneration.testAndRegister(sGeneratingFileKey = XWCMTagParserPageGeneration.makeGeneratingRegisterKey(folder.getType(), folder.getId(), template.getId()))) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("generating.... ignore this task: " + sGeneratingFileKey));
                }
                String[] tempName = null;
                XWCMTagParserPageGeneration.unregister(sGeneratingFileKey);
                return tempName;
            }
            if (logger.isDebugEnabled()) {
                logger.info((Object)(I18NMessage.get(XWCMTagParserPageGeneration.class, "XWCMTagParserPageGeneration.label6", "===>2.\u5f00\u59cb\u83b7\u53d6\u914d\u7f6e\u7684\u6a21\u677f[") + template.getName() + I18NMessage.get(XWCMTagParserPageGeneration.class, "XWCMTagParserPageGeneration.label7", "]\u5e76\u8fdb\u884c\u89e3\u6790")));
            }
            PublishTask task = null;
            if (!isPreview) {
                task = new PublishTask();
            }
            PublishTaskContext taskContext = new PublishTaskContext(task, folder);
            PublishPageContext pageContext = new PublishPageContext(folder, taskContext);
            String sTemplateNameFirst = _context.getAttribute("OnlyTemplateName");
            pageContext.setExtraAttribute("OnlyTemplateName", sTemplateNameFirst);
            PageGenerator.generatePage(pageContext, template, true);
            String[] stringArray = null;
            XWCMTagParserPageGeneration.unregister(sGeneratingFileKey);
            return stringArray;
        }
        catch (Exception ex) {
            logger.warn((Object)I18NMessage.get(XWCMTagParserPageGeneration.class, "XWCMTagParserPageGeneration.label15", "\u65e0\u6cd5\u751f\u6210\u9875\u9762\uff01"), (Throwable)ex);
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            XWCMTagParserPageGeneration.unregister(sGeneratingFileKey);
        }
    }

    public String getFileName(PublishTagContext _context) {
        String sFileName = null;
        try {
            TagItem tagItem = _context.getTagItem();
            IPublishElement element = _context.getUpperHost();
            IPublishContent content = (IPublishContent)element;
            sFileName = PublishPathCompass.makeDetailPageFileName(content);
            Template template = this.getTemplateUsed((IPublishContent)element, tagItem);
            String sExt = _context.getAttribute("EXT");
            if (sExt == null || "".equalsIgnoreCase(sExt)) {
                sExt = "ext";
            } else if ("templateid".equalsIgnoreCase(sExt)) {
                sExt = template.getId() + "";
            }
            sFileName = sFileName + "_" + sExt + '.' + template.getOutputFileExt();
        }
        catch (WCMException e) {
            logger.warn((Object)I18NMessage.get(XWCMTagParserPageGeneration.class, "XWCMTagParserPageGeneration.label15", "\u65e0\u6cd5\u83b7\u53d6\u53d1\u5e03\u6587\u4ef6\u540d\u79f0\uff01"), (Throwable)e);
        }
        return sFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] parse(PublishTagContext _context) {
        if (logger.isDebugEnabled()) {
            logger.info((Object)"===>1.\u5f00\u59cb\u5206\u6790\u7f6e\u6807[TRS_PAGEGENERATE]");
        }
        try {
            if (!CMyString.isEmpty(_context.getAttribute("filenamedateformat"))) {
                new DailyPageGenration().parse(_context);
                return null;
            }
        }
        catch (CMyException e) {
            logger.error((Object)"\u5c1d\u8bd5\u751f\u6210\u680f\u76ee\u5386\u53f2\u7d22\u5f15\u9875\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        IPublishElement element = _context.getUpperHost();
        if (element == null) {
            return null;
        }
        if (!(element instanceof IPublishContent)) {
            return this.parse4Outline(_context);
        }
        IPublishContent content = (IPublishContent)element;
        String sDocURL = null;
        String sGeneratingFileKey = null;
        try {
            TagItem tagItem = _context.getTagItem();
            Template template = this.getTemplateUsed((IPublishContent)element, tagItem);
            if (template == null) {
                String tempName = tagItem.getAttributeTrim("TEMPNAME");
                logger.warn((Object)(I18NMessage.get(XWCMTagParserPageGeneration.class, "XWCMTagParserPageGeneration.label4", "\u4f9d\u636e\u5f53\u524d\u7684\u5bf9\u8c61[") + element + I18NMessage.get(XWCMTagParserPageGeneration.class, "XWCMTagParserPageGeneration.label5", "]\u7684\u4e0a\u4e0b\u6587\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6a21\u677f") + tempName + "\uff01"));
                String[] stringArray = null;
                XWCMTagParserPageGeneration.unregister(sGeneratingFileKey);
                return stringArray;
            }
            boolean isPreview = _context.isPreview();
            if (!isPreview && !XWCMTagParserPageGeneration.testAndRegister(sGeneratingFileKey = XWCMTagParserPageGeneration.makeGeneratingRegisterKey(element.getType(), element.getId(), template.getId()))) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("generating.... ignore this task: " + sGeneratingFileKey));
                }
                String[] stringArray = null;
                XWCMTagParserPageGeneration.unregister(sGeneratingFileKey);
                return stringArray;
            }
            if (logger.isDebugEnabled()) {
                logger.info((Object)("===>2.\u5f00\u59cb\u83b7\u53d6\u914d\u7f6e\u7684\u6a21\u677f[" + template.getName() + "]\u5e76\u8fdb\u884c\u89e3\u6790"));
            }
            PublishTask task = null;
            if (!isPreview) {
                task = new PublishTask();
            }
            PublishTaskContext taskContext = new PublishTaskContext(task, content.getOriginalHome());
            PublishPageContext pageContext = new PublishPageContext(content, taskContext);
            String sAutoUpdate = tagItem.getAttributeTrim("AUTOUPDATE");
            String sFileName = PublishPathCompass.makeDetailPageFileName(content);
            String sExt = _context.getAttribute("EXT");
            if (sExt == null || "".equalsIgnoreCase(sExt)) {
                sExt = "ext";
            } else if ("templateid".equalsIgnoreCase(sExt)) {
                sExt = template.getId() + "";
            } else if (sExt.indexOf(91) >= 0) {
                sExt = CMyString.replaceStr(sExt, "[", "$[");
                sExt = CMyString.parsePageVariables(sExt, content.getSubstance().getProperties(), new char[]{'[', ']'});
            }
            pageContext.setExtraAttribute("EXT", sExt);
            sFileName = sFileName + "_" + sExt + '.' + template.getOutputFileExt();
            PublishPathCompass compass = _context.getPathCompass();
            String base = CMyFile.extractFilePath(compass.getHttpUrl(content, 0));
            String sAbsURL = sDocURL = base + sFileName;
            sDocURL = HtmlUtil.calRelativePath(sDocURL, _context.getPageHttpPath());
            if (sAutoUpdate != null && sAutoUpdate.equalsIgnoreCase("false")) {
                if (logger.isDebugEnabled()) {
                    logger.info((Object)I18NMessage.get(XWCMTagParserPageGeneration.class, "XWCMTagParserPageGeneration.label8", "===>3.1[AUTOUPDATE]\u5c5e\u6027\u4e3afalse..."));
                }
                if (this.existsLocalFile(pageContext, sFileName, isPreview)) {
                    if (logger.isDebugEnabled()) {
                        logger.info((Object)(I18NMessage.get(XWCMTagParserPageGeneration.class, "XWCMTagParserPageGeneration.label9", "===>3.1.1.[AUTOUPDATE]\u5c5e\u6027\u4e3afalse\uff0c\u5e76\u4e14[\u6587\u4ef6") + sDocURL + I18NMessage.get(XWCMTagParserPageGeneration.class, "XWCMTagParserPageGeneration.label10", "]\u5df2\u7ecf\u5b58\u5728(\u5373\u6309\u7167\u6b64\u6a21\u677f\u53d1\u5e03\u8fc7)")));
                    }
                    String[] stringArray = new String[]{_context.getAttribute("URLIsABS", false) ? sAbsURL : sDocURL};
                    XWCMTagParserPageGeneration.unregister(sGeneratingFileKey);
                    return stringArray;
                }
                if (logger.isDebugEnabled()) {
                    logger.info((Object)(I18NMessage.get(XWCMTagParserPageGeneration.class, "XWCMTagParserPageGeneration.label11", "===>3.1.1.[AUTOUPDATE]\u5c5e\u6027\u4e3afalse\uff0c\u4f46\u6587\u4ef6[") + sDocURL + I18NMessage.get(XWCMTagParserPageGeneration.class, "XWCMTagParserPageGeneration.label12", "]\u4e0d\u5b58\u5728(\u5373\u5c1a\u672a\u6309\u7167\u6b64\u6a21\u677f\u53d1\u5e03\u8fc7)")));
                }
            }
            PageGenerator.generatePage(pageContext, template, true);
            if (logger.isDebugEnabled()) {
                logger.info((Object)(I18NMessage.get(XWCMTagParserPageGeneration.class, "XWCMTagParserPageGeneration.label13", "===>4.[AUTOUPDATE]\u5c5e\u6027\u4e3a[") + sAutoUpdate + I18NMessage.get(XWCMTagParserPageGeneration.class, "XWCMTagParserPageGeneration.label14", "]\uff0c\u6210\u529f\u751f\u6210\u4e86\u6587\u4ef6[") + sDocURL + "]!"));
            }
            if (_context.getAttribute("OnlyPublish", false)) {
                String[] stringArray = null;
                XWCMTagParserPageGeneration.unregister(sGeneratingFileKey);
                return stringArray;
            }
            String[] stringArray = new String[]{_context.getAttribute("URLIsABS", false) ? sAbsURL : sDocURL};
            XWCMTagParserPageGeneration.unregister(sGeneratingFileKey);
            return stringArray;
        }
        catch (Exception ex) {
            logger.warn((Object)I18NMessage.get(XWCMTagParserPageGeneration.class, "XWCMTagParserPageGeneration.label15", "\u65e0\u6cd5\u751f\u6210\u9875\u9762\uff01"), (Throwable)ex);
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            XWCMTagParserPageGeneration.unregister(sGeneratingFileKey);
        }
    }

    private boolean existsLocalFile(PublishPageContext pageContext, String fileName, boolean bIsPreview) throws WCMException {
        PublishPathCompass compass = pageContext.getPathCompass();
        String sLocalPath = CMyString.setStrEndWith(compass.getLocalPath(pageContext.getPageElement(), bIsPreview), File.separatorChar);
        return CMyFile.fileExists(sLocalPath + fileName);
    }

    private Template getTemplateUsed(IPublishElement _element, TagItem tagItem) throws WCMException {
        String sTempName = tagItem.getAttributeTrim("TEMPNAME");
        if (CMyString.isEmpty(sTempName)) {
            throw new WCMException(I18NMessage.get(XWCMTagParserPageGeneration.class, "XWCMTagParserPageGeneration.label16", "[TEMPNAME]\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        TemplateCacheMgr templateCacheMgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
        IPublishFolder folder = _element.getFolder();
        if (folder == null && !_element.isFolder()) {
            folder = ((IPublishContent)_element).getOriginalHome();
        }
        if (folder == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"current folder is null, no template selected.");
            }
            return null;
        }
        return templateCacheMgr.lookupByName(folder.getRoot(), sTempName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean testAndRegister(String sGeneratingFileKey) {
        if (sGeneratingFileKey == null) {
            return false;
        }
        Set set = m_oGenerating;
        synchronized (set) {
            if (m_oGenerating.contains(sGeneratingFileKey)) {
                return false;
            }
            m_oGenerating.add(sGeneratingFileKey);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void unregister(String sGeneratingFileKey) {
        if (sGeneratingFileKey == null) {
            return;
        }
        Set set = m_oGenerating;
        synchronized (set) {
            m_oGenerating.remove(sGeneratingFileKey);
        }
    }

    private static final String makeGeneratingRegisterKey(int _nType, int _nId, int _nTemplateId) {
        return _nType + "_" + _nId + "_" + _nTemplateId;
    }

    class DailyPageGenration {
        DailyPageGenration() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String[] parse(PublishTagContext _context) throws CMyException {
            IPublishElement element;
            String sFileNameDateFormat = _context.getAttribute("filenamedateformat");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("filenamedateformat:" + sFileNameDateFormat));
            }
            if (CMyString.isEmpty(sFileNameDateFormat)) {
                return null;
            }
            CMyDateTime toDate = CMyDateTime.now();
            toDate = toDate.dateAdd(3, 1);
            String sToDate = _context.getAttribute("todate");
            if (!CMyString.isEmpty(sToDate)) {
                toDate.setDateTimeWithString(sToDate);
            }
            sToDate = toDate.toString("yyyy-MM-dd");
            toDate.setDateTimeWithString(sToDate + " 00:00:00", "yyyy-MM-dd HH:mm:ss");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("todate:" + toDate.toString()));
            }
            boolean bForce = _context.getAttribute("force", false);
            CMyDateTime fromDate = new CMyDateTime(toDate.getTimeInMillis());
            fromDate.dateAdd(3, -1);
            String sFromDate = _context.getAttribute("fromdate");
            if (!CMyString.isEmpty(sFromDate)) {
                fromDate.setDateTimeWithString(sFromDate);
            }
            sFromDate = fromDate.toString("yyyy-MM-dd");
            fromDate.setDateTimeWithString(sFromDate + " 00:00:00", "yyyy-MM-dd HH:mm:ss");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("fromdate:" + fromDate.toString()));
            }
            if ((element = _context.getUpperHost()) == null) {
                return null;
            }
            if (!(element instanceof IPublishFolder)) {
                return null;
            }
            IPublishFolder folder = (IPublishFolder)element;
            boolean isPreview = _context.isPreview();
            String sGeneratingFileKey = null;
            try {
                TagItem tagItem = _context.getTagItem();
                Template template = XWCMTagParserPageGeneration.this.getTemplateUsed(element, tagItem);
                if (template == null) {
                    String tempName = tagItem.getAttributeTrim("TEMPNAME");
                    logger.warn((Object)(I18NMessage.get(XWCMTagParserPageGeneration.class, "XWCMTagParserPageGeneration.label4", "\u4f9d\u636e\u5f53\u524d\u7684\u5bf9\u8c61[") + element + I18NMessage.get(XWCMTagParserPageGeneration.class, "XWCMTagParserPageGeneration.label5", "]\u7684\u4e0a\u4e0b\u6587\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6a21\u677f") + tempName + "\uff01"));
                    String[] stringArray = null;
                    XWCMTagParserPageGeneration.unregister(sGeneratingFileKey);
                    return stringArray;
                }
                if (!isPreview && !XWCMTagParserPageGeneration.testAndRegister(sGeneratingFileKey = XWCMTagParserPageGeneration.makeGeneratingRegisterKey(folder.getType(), folder.getId(), template.getId()))) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("generating.... ignore this task: " + sGeneratingFileKey));
                    }
                    String[] tempName = null;
                    XWCMTagParserPageGeneration.unregister(sGeneratingFileKey);
                    return tempName;
                }
                long range = toDate.dateDiff(3, fromDate);
                int i = 0;
                while ((long)i < range) {
                    CMyDateTime tmpDate = new CMyDateTime(fromDate.getTimeInMillis());
                    tmpDate.dateAdd(3, 1);
                    this.generateOneDay(folder, template, fromDate, tmpDate, sFileNameDateFormat, _context);
                    fromDate.dateAdd(3, 1);
                    ++i;
                }
                XWCMTagParserPageGeneration.unregister(sGeneratingFileKey);
                return null;
            }
            catch (Exception ex) {
                logger.warn((Object)I18NMessage.get(XWCMTagParserPageGeneration.class, "XWCMTagParserPageGeneration.label15", "\u65e0\u6cd5\u751f\u6210\u9875\u9762\uff01"), (Throwable)ex);
                String[] stringArray = null;
                return stringArray;
            }
            finally {
                XWCMTagParserPageGeneration.unregister(sGeneratingFileKey);
            }
        }

        private String[] generateOneDay(IPublishFolder folder, Template template, CMyDateTime fromDate, CMyDateTime toDate, String sFileNameDateFormat, PublishTagContext _context) throws Exception {
            String[] results;
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("FROMDATE", fromDate.toString("yyyy-MM-dd"));
            variables.put("TODATE", toDate.toString("yyyy-MM-dd"));
            String sTempText = template.getText();
            sTempText = CMyString.parsePageVariables(sTempText, variables, new char[]{'[', ']'});
            TagDocument tempDoc = TagDocumentReader.read(sTempText);
            PublishTaskContext taskContext = new PublishTaskContext(_context.getPageContext().getTaskContext().getTask(), folder);
            PublishPageContext pageContext = new PublishPageContext(folder, taskContext);
            PublishTagContext tagContext = new PublishTagContext(pageContext);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u751f\u6210\u6307\u5b9a\u65f6\u95f4\u8303\u56f4\u7684\u7d22\u5f15\u6587\u4ef6:[fromdate:" + fromDate + ", todate:" + toDate + "]"));
            }
            if ((results = TagParseHelper.parseItems(tempDoc.getItems(), tagContext)) == null) {
                logger.fatal((Object)"Parse no content!");
                return null;
            }
            boolean bPreview = pageContext.isPreview();
            PublishPathCompass compass = pageContext.getPathCompass();
            String sRootPath = compass.getRootHttpPathFrom(folder);
            String sEncoding = folder.getEncoding();
            String sLocalPath = compass.getLocalPath(folder, bPreview);
            PublishSyncGlobalTuner.insureLocalPathExists(sLocalPath);
            String sFileName = template.getOutputFileName();
            sFileName = sFileName + "_" + fromDate.toString(sFileNameDateFormat);
            String sFileExt = template.getOutputFileExt();
            String sFullFileName = null;
            String sLocalFilePathName = null;
            FileDistributeShip distributeShip = null;
            Object sUrlReturn = null;
            for (int i = 0; i < results.length; ++i) {
                boolean bShowWhenOnePage;
                sFullFileName = PublishPathCompass.makePageFileName(sFileName, sFileExt, i);
                sLocalFilePathName = sLocalPath + sFullFileName;
                variables = new HashMap(6);
                variables.put("ROOT_PATH", sRootPath);
                variables.put("PAGE_COUNT", String.valueOf(results.length));
                variables.put("PAGE_NAME", sFileName);
                variables.put("PAGE_EXT", sFileExt);
                variables.put("RECORD_COUNT", pageContext.getExtraAttribute("RECORD_COUNT"));
                variables.put("TOTAL_COUNT", pageContext.getExtraAttribute("TOTAL_COUNT"));
                variables.put("PAGE_INDEX", String.valueOf(i));
                String sShowOnlyOne = pageContext.getExtraAttribute("NAV_SHOWWHENONEPAGE");
                boolean bl = bShowWhenOnePage = sShowOnlyOne == null ? true : "true".equalsIgnoreCase(sShowOnlyOne);
                if (!bShowWhenOnePage && results.length == 1) {
                    variables.put("OUTLINE_NAV", "");
                } else {
                    variables.put("OUTLINE_NAV", PageNavHelper.makeNav(pageContext, sFileName, sFileExt, results.length, i));
                }
                String sContent = CMyString.parsePageVariables(results[i], variables);
                CMyFile.writeFile(sLocalFilePathName, sContent, sEncoding);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\u5199\u5165\u7d22\u5f15\u6587\u4ef6:[filename:" + sLocalFilePathName + "]"));
                }
                pageContext.incOutlinePageCount();
                if (bPreview) continue;
                if (distributeShip == null) {
                    distributeShip = pageContext.getFileDistributeShip();
                }
                pageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label18", "\u5206\u53d1\u6587\u4ef6:") + sLocalFilePathName);
                distributeShip.distributeFile(sLocalFilePathName, folder);
            }
            return null;
        }
    }

    private class TBI
    extends TagBeanInfo {
        private NestTemplateChecker m_oChcker = new NestTemplateChecker("TRS_PAGEGENERATE");

        @Override
        public void checkSemantic(IPublishFolder _folder, TagItem _tagItem, StringBuffer _sbResult, String _sTempName) {
            String sTempName = _tagItem.getAttribute("TEMPNAME");
            TemplateCacheMgr tcm = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
            ArrayList result = null;
            try {
                Template generTemplate = tcm.lookupByName(_folder, sTempName);
                if (generTemplate == null) {
                    _sbResult.append("\u6307\u5b9a\u7684\u6a21\u677f\u4e0d\u5b58\u5728[TEMPNAME=" + sTempName + "]");
                    return;
                }
                result = new ArrayList(4);
                this.m_oChcker.checkNested(generTemplate, result, tcm, _folder);
            }
            catch (LoopException e) {
                _sbResult.append("\u6a21\u677f[");
                _sbResult.append(_sTempName);
                _sbResult.append("]\u4e0e\u5176\u5b83\u6a21\u677f");
                _sbResult.append("\u7684\u7f6e\u6807TRS_PAGEGENERATE\u5b58\u5728\u5d4c\u5957\u73af\u8def.");
                _sbResult.append("\u73af\u8def\u4e3a:" + result);
            }
            catch (Exception e) {
                _sbResult.append("\u5728\u6267\u884c\u6821\u9a8c\u7f6e\u6807");
                _sbResult.append(_tagItem.getDescWithPos());
                _sbResult.append("\u7684\u8bed\u4e49\u65f6\u51fa\u73b0\u9519\u8bef\u3002");
                _sbResult.append(e.getMessage());
                _sbResult.append("\n");
            }
        }
    }
}

