/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import java.util.regex.Pattern;

public class WCMTagParserCurPage
implements ITagParser {
    private TagItem m_tagItem;
    private static TagBeanInfo s_TagBeanInfo = null;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_CURPAGE");
            tbi.setDesc("TRS_CURPAGE");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("VALUE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue(" > ");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ONLY");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOLINK");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("true");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TARGET");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("_self");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("EXTRA");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("HOMEPAGEDESC");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("USEDNAME");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("INDEXNAME");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FROMPOSITION");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("HIDECURRCHNL");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CURRCHNLNOLINK");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CURRCHNLCLS");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("Reverse");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("HideHome");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public void setTagItem(TagItem _item) {
        this.m_tagItem = _item;
    }

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) throws WCMException {
        TemplateQuote aQuote = new TemplateQuote();
        aQuote.setQuotedFolderWithParent();
        aQuote.setQuoteType(5);
        return new TemplateQuote[]{aQuote};
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        String sResult;
        IPublishElement pageElement = _context.getPageElement();
        if (pageElement == null) {
            throw new WCMException(10, "Page element required in context!");
        }
        IPublishFolder currFolder = pageElement.getFolder();
        if (currFolder == null) {
            throw new WCMException(10, "FolderTypeConfig required in page element!");
        }
        BaseChannel channelOrSite = (BaseChannel)currFolder.getSubstance();
        if (pageElement.getType() != 605) {
            IPublishElement upperHost = _context.getUpperHost();
            if (upperHost.getType() == 605) {
                Document currDocuemnt = (Document)upperHost.getSubstance();
                channelOrSite = currDocuemnt.getChannel();
            }
            if (upperHost.getType() == 101) {
                channelOrSite = (Channel)upperHost.getSubstance();
            }
        }
        if (channelOrSite == null) {
            throw new WCMException(10, "Start folder substance required in page context!");
        }
        boolean bMyselfOnly = _context.getAttribute("only", false);
        boolean bAutoLink = _context.getAttribute("autolink", true);
        if (bAutoLink) {
            String sPageDataPath;
            if (pageElement.isFolder()) {
                sPageDataPath = null;
                if (_context.getUpperHost().getType() == 605) {
                    sPageDataPath = PublishPathCompass.calSubDirectory((IPublishContent)_context.getUpperHost(), false);
                }
            } else {
                sPageDataPath = PublishPathCompass.calSubDirectory((IPublishContent)pageElement, false);
            }
            sResult = this.getLinkedPath(_context, channelOrSite, bMyselfOnly, sPageDataPath);
        } else {
            sResult = this.getDescPath(_context, channelOrSite, bMyselfOnly);
        }
        return new String[]{sResult};
    }

    protected String getApdHttpPath(PublishTagContext _context) throws WCMException {
        IPublishElement apdOwner = _context.getUpperHost();
        PublishPathCompass compass = _context.getPathCompass();
        return compass.getAbsoluteHttpPath(apdOwner);
    }

    protected String getApdHttpPath(PublishTagContext _context, IPublishFolder _folder) throws WCMException {
        PublishPathCompass compass = _context.getPathCompass();
        return compass.getAbsoluteHttpPath(_folder);
    }

    private String getLinkedPath(PublishTagContext _context, BaseChannel _pageFolder, boolean _bMyselfOnly, String _sPageDataPath) throws WCMException {
        try {
            String sUrl;
            String sTarget = _context.getAttribute("TARGET");
            String sExtra = _context.getAttribute("EXTRA");
            boolean bUrlIsAbs = _context.getAttribute("UrlIsAbs", false);
            IPublishFolder currFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(_pageFolder);
            String sPageURL = _context.getPathCompass().getFullDataPath(_context.getUpperHost(), false);
            String sIndexName = _context.getAttribute("INDEXNAME");
            if (sIndexName == null) {
                sIndexName = "";
            }
            if (!bUrlIsAbs) {
                String sAbsURL = _context.getPathCompass().getAbsoluteHttpPath(currFolder);
                sUrl = HtmlUtil.calRelativePath(sAbsURL, _context.getPageHttpPath());
            } else {
                sUrl = _sPageDataPath == null || _sPageDataPath.length() == 0 ? this.getApdHttpPath(_context) : this.getApdHttpPath(_context, currFolder);
            }
            sUrl = sUrl + sIndexName;
            boolean zUsedName = _context.getAttribute("USEDNAME", false);
            String sDesc = null;
            sDesc = zUsedName ? _pageFolder.getName() : _pageFolder.getDispDesc();
            String sResult = "";
            if (!_context.getAttribute("HideCurrChnl", false)) {
                if (_context.getAttribute("CurrChnlNoLink", false)) {
                    sResult = sResult + sDesc;
                } else {
                    String clsRegExp;
                    String sCurrCls = CMyString.showEmpty(_context.getAttribute("CurrChnlCls"), "CurrChnlCls");
                    sExtra = CMyString.isEmpty(sExtra) ? "class=\"" + sCurrCls + "\"" : (Pattern.compile(clsRegExp = "(?is)(class\\s*=\\s*)(['\"])(.*?)\\2").matcher(sExtra).find() ? sExtra.replaceFirst(clsRegExp, "$1$2$3 " + sCurrCls + "$2") : sExtra + " class=\"" + sCurrCls + "\"");
                    sResult = sResult + HtmlUtil.renderLink(sUrl, sTarget, sDesc, sExtra, sDesc);
                }
            }
            if (!_pageFolder.isSite() && ((Channel)_pageFolder).isOnlyManager()) {
                sResult = "";
            }
            String[] position = this.getFromPosition(_context);
            if (!_bMyselfOnly && !_pageFolder.isSite()) {
                String sAbsURL;
                BaseChannel currBaseChannel;
                IPublishFolder parent;
                String sDelim = this.getDelim(_context);
                IPublishFolder child = currFolder;
                if (zUsedName) {
                    for (parent = child.getParent(); parent != null && !parent.isRoot(); parent = parent.getParent()) {
                        currBaseChannel = (BaseChannel)parent.getSubstance();
                        if (position == null || position.length <= 0 || currBaseChannel.isSite() || !position[0].equals("CHANNEL") || !currBaseChannel.getName().equals(position[1])) {
                            if (currBaseChannel.isSite() || !((Channel)currBaseChannel).isOnlyManager()) {
                                if (!bUrlIsAbs) {
                                    sAbsURL = _context.getPathCompass().getAbsoluteHttpPath(parent);
                                    sUrl = HtmlUtil.calRelativePath(sAbsURL, _context.getPageHttpPath());
                                } else {
                                    sUrl = this.getApdHttpPath(_context, parent);
                                }
                                sUrl = sUrl + sIndexName;
                                sDesc = currBaseChannel.getName();
                                sResult = HtmlUtil.renderLink(sUrl, sTarget, sDesc, sExtra, sDesc) + (CMyString.isEmpty(sResult) ? "" : sDelim) + sResult;
                            }
                            child = parent;
                            continue;
                        }
                        break;
                    }
                } else {
                    while (parent != null && !parent.isRoot()) {
                        currBaseChannel = (BaseChannel)parent.getSubstance();
                        if (position == null || position.length <= 0 || currBaseChannel.isSite() || !position[0].equals("CHANNEL") || !currBaseChannel.getName().equals(position[1])) {
                            if (currBaseChannel.isSite() || !((Channel)currBaseChannel).isOnlyManager()) {
                                if (!bUrlIsAbs) {
                                    sAbsURL = _context.getPathCompass().getAbsoluteHttpPath(parent);
                                    sUrl = HtmlUtil.calRelativePath(sAbsURL, _context.getPageHttpPath());
                                } else {
                                    sUrl = this.getApdHttpPath(_context, parent);
                                }
                                sUrl = sUrl + sIndexName;
                                sDesc = currBaseChannel.getDispDesc();
                                sResult = HtmlUtil.renderLink(sUrl, sTarget, sDesc, sExtra, sDesc) + (CMyString.isEmpty(sResult) ? "" : sDelim) + sResult;
                            }
                            child = parent;
                            parent = parent.getParent();
                            continue;
                        }
                        break;
                    }
                }
                if (position == null || position.length <= 0) {
                    IPublishFolder root = currFolder.getRoot();
                    if (!bUrlIsAbs) {
                        sAbsURL = _context.getPathCompass().getAbsoluteHttpPath(root);
                        sUrl = HtmlUtil.calRelativePath(sAbsURL, _context.getPageHttpPath());
                    } else {
                        sUrl = this.getApdHttpPath(_context, parent);
                    }
                    sUrl = sUrl + sIndexName;
                    sDesc = this.getHomePageDesc(_context, (BaseChannel)root.getSubstance());
                    sResult = HtmlUtil.renderLink(sUrl, sTarget, sDesc, sExtra, sDesc) + (CMyString.isEmpty(sResult) ? "" : sDelim) + sResult;
                }
            }
            return sResult;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to assemble the linked path of current folder!", ex);
        }
    }

    private String getDescPath(PublishTagContext _context, BaseChannel _channelOrSite, boolean _bMyselfOnly) throws WCMException {
        String sResult;
        boolean bReverse = _context.getAttribute("Reverse", false);
        boolean zUsedName = _context.getAttribute("USEDNAME", false);
        String string = sResult = zUsedName ? _channelOrSite.getName() : _channelOrSite.getDispDesc();
        if (_bMyselfOnly || _channelOrSite.isSite()) {
            return sResult;
        }
        String[] position = this.getFromPosition(_context);
        String sDelim = this.getDelim(_context);
        Channel parent = ((Channel)_channelOrSite).getParent();
        while (parent != null) {
            if (parent.isOnlyManager()) {
                parent = parent.getParent();
                continue;
            }
            if (position != null && position.length > 1 && position[0].equals("CHANNEL") && parent.getName().equals(position[1])) break;
            sResult = bReverse ? sResult + sDelim + (zUsedName ? parent.getName() : parent.getDispDesc()) : (zUsedName ? parent.getName() : parent.getDispDesc()) + sDelim + sResult;
            parent = parent.getParent();
        }
        if (_context.getAttribute("HideHome", false)) {
            return sResult;
        }
        String sDesc = this.getHomePageDesc(_context, _channelOrSite);
        if (bReverse) {
            return sResult + sDelim + sDesc;
        }
        return sDesc + sDelim + sResult;
    }

    private String getHomePageDesc(PublishTagContext _context, BaseChannel _channelOrSite) throws WCMException {
        String sDesc = null;
        String sHomePage = _context.getAttribute("HOMEPAGEDESC");
        if (CMyString.isEmpty(sHomePage)) {
            boolean bUseDescForHomePage = false;
            try {
                bUseDescForHomePage = "true".equals(ConfigServer.getServer().getSysConfigValue("TAGCURPAGE_USEDESC", "false"));
            }
            catch (WCMException wCMException) {
                // empty catch block
            }
            sDesc = bUseDescForHomePage ? _channelOrSite.getSite().getDispDesc() : I18NMessage.get(WCMTagParserCurPage.class, "WCMTagParserCurPage.label1", "\u9996\u9875");
        } else {
            sDesc = "@truename".equals(sHomePage.toLowerCase()) ? _channelOrSite.getSite().getDispDesc() : sHomePage;
        }
        return sDesc;
    }

    private String getDelim(PublishTagContext _context) {
        String sDelim = _context.getAttribute("VALUE");
        if (sDelim == null || (sDelim = sDelim.trim()).length() == 0) {
            sDelim = "&nbsp;&gt;&nbsp;";
        }
        return sDelim;
    }

    private String[] getFromPosition(PublishTagContext _context) {
        String sFromPosition = _context.getAttribute("fromPosition");
        if (sFromPosition == null) {
            return new String[0];
        }
        String[] position = sFromPosition.split(":");
        position[0] = position[0].toUpperCase();
        return position;
    }
}

