/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.epress;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.resource.Source;
import com.trs.components.wcm.resource.Sources;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.XmlDocWithDom4j;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;

public class EPressXPlusImporter {
    private static final int IMAGE_HEIGHT = 486;
    private static final int IMAGE_WIDTH = 338;
    private static final Map DEFAULT_TAGS = new HashMap(6);
    private static Logger s_logger = Logger.getLogger(EPressXPlusImporter.class);
    private DocumentMgr m_documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFromXPlus(String _zipData, String _tcf, Channel _channel) throws Exception {
        String fn = this.mapFile(_zipData);
        String sUnZipFile = CMyFile.extractFilePath(fn);
        sUnZipFile = sUnZipFile + "temp" + CMyFile.extractMainFileName(fn);
        sUnZipFile = sUnZipFile + File.separator;
        CMyUnZipFile uzf = new CMyUnZipFile(fn, sUnZipFile);
        try {
            uzf.addFileExtFilters("xml");
            uzf.doUnZipAnd();
        }
        catch (CMyException e) {
            throw new WCMException(200, "Zip\u6587\u4ef6\u89e3\u538b\u5931\u8d25!", e);
        }
        finally {
            CMyFile.deleteFile(fn);
        }
        Map tags = this.parseTcf(_tcf);
        ArrayList fsxplus = uzf.getFilteredFiles();
        try {
            String fxplus = null;
            for (int i = 0; i < fsxplus.size(); ++i) {
                fxplus = (String)fsxplus.get(i);
                this.addDocument(fxplus, tags, _channel);
            }
        }
        finally {
            fsxplus.clear();
            uzf = null;
            CMyFile.deleteDir(sUnZipFile);
        }
    }

    private void addDocument(String _fn, Map _tags, Channel _channel) throws Exception {
        Document xmlDoc = XmlDocWithDom4j.parse(_fn);
        String path = CMyFile.extractFilePath(_fn);
        List articles = xmlDoc.selectNodes("/PageInfoFile/ArticleList/Article");
        Element pageEl = (Element)xmlDoc.selectSingleNode("/PageInfoFile/PageInfo");
        String pageNo = pageEl.attributeValue("PageNo");
        String pageNoField = (String)_tags.get("PageNo");
        String pageName = pageEl.attributeValue("PageName");
        String pageNameField = (String)_tags.get("PageName");
        double pageWidth = Double.parseDouble(pageEl.attributeValue("Width"));
        double pageHeight = Double.parseDouble(pageEl.attributeValue("Height"));
        double ratioX = 338.0 / pageWidth;
        double ratioY = 486.0 / pageHeight;
        String mainFn = CMyFile.extractMainFileName(_fn);
        Element article = null;
        com.trs.components.wcm.content.persistent.Document wcmDoc = null;
        int nChnlId = _channel.getId();
        int nStatusId = 1;
        String doccon = null;
        String docTitle = null;
        int size = articles.size();
        for (int i = size - 1; i >= 0; --i) {
            article = (Element)articles.get(i);
            wcmDoc = new com.trs.components.wcm.content.persistent.Document();
            wcmDoc.setChannel(nChnlId);
            wcmDoc.setStatus(nStatusId);
            wcmDoc.setType(20);
            this.copyProps(wcmDoc, article, _tags);
            this.processDocSource(wcmDoc);
            wcmDoc.setPropertyWithString(pageNoField, pageNo);
            wcmDoc.setPropertyWithString(pageNameField, pageName);
            wcmDoc.setPropertyWithString("PDF", mainFn + ".pdf");
            wcmDoc.setPropertyWithString("PICSRC", mainFn + ".gif");
            wcmDoc.setReleaseTime(CMyDateTime.now());
            this.processMapCoords(wcmDoc, article, ratioX, ratioY);
            doccon = wcmDoc.getContent();
            doccon = CMyString.isEmpty(doccon) ? "\u65e0\u5185\u5bb9" : "<p class='trsp-indent'>" + doccon.replaceAll("\n", "\n</p><p class='trsp-indent'>");
            wcmDoc.setHtmlContent(doccon);
            docTitle = wcmDoc.getTitle();
            if (CMyString.isEmpty(docTitle)) {
                wcmDoc.setTitle("\u65e0\u6807\u9898");
            }
            wcmDoc = this.m_documentMgr.save(wcmDoc);
            this.processAppendix(wcmDoc, article, path);
        }
    }

    private void processMapCoords(com.trs.components.wcm.content.persistent.Document wcmDoc, Element article, double ratioX, double ratioY) throws WCMException {
        List points = article.selectNodes("PointList/Point");
        StringBuffer buff = new StringBuffer(128);
        Element point = null;
        int pointX = 0;
        int pointY = 0;
        int size = points.size();
        for (int i = 0; i < size; ++i) {
            point = (Element)points.get(i);
            pointX = Integer.parseInt(point.attributeValue("X"));
            buff.append((int)((double)pointX * ratioX));
            buff.append(",");
            pointY = Integer.parseInt(point.attributeValue("Y"));
            buff.append((int)((double)pointY * ratioY));
            buff.append(",");
        }
        wcmDoc.setPropertyWithString("MAPCOORDS", buff.substring(0, buff.length() - 1));
    }

    private void processAppendix(com.trs.components.wcm.content.persistent.Document _wcmDoc, Element _article, String _path) throws Exception {
        List images = _article.selectNodes("ImageList/Image");
        if (images != null && images.size() > 0) {
            User loginUser = ContextHelper.getLoginUser();
            FilesMan fileman = FilesMan.getFilesMan();
            String flag = "W0";
            int docId = _wcmDoc.getId();
            String path = CMyString.setStrEndWith(_path, File.separatorChar);
            path = path + "images" + File.separator;
            Element image = null;
            Appendix appendix = null;
            String fn = null;
            String desc = null;
            int size = images.size();
            for (int i = 0; i < size; ++i) {
                image = (Element)images.get(i);
                fn = image.attributeValue("Name");
                appendix = new Appendix();
                appendix.setDocId(docId);
                appendix.setAlt(fn);
                appendix.setSrcFile(fn);
                desc = image.getText();
                desc = CMyString.isEmpty(desc) ? fn : desc.trim();
                appendix.setDesc(desc);
                appendix.setSerialNo(i + 1);
                try {
                    fn = fileman.moveFile(path + fn, flag, false);
                    appendix.setFile(fn);
                }
                catch (Exception e) {
                    s_logger.warn((Object)("missing file:" + path + fn), (Throwable)e);
                    continue;
                }
                appendix.setFileExt(CMyFile.extractFileExt(fn));
                appendix.setFlag(20);
                appendix.setUsedByVersion(_wcmDoc.getVersion(), true);
                appendix.setAuthor(image.attributeValue("Author"));
                appendix.insert(loginUser);
            }
        }
    }

    private void copyProps(com.trs.components.wcm.content.persistent.Document _wcmDoc, Element _article, Map _tags) throws Exception {
        Iterator xmlTags = _tags.keySet().iterator();
        String xmlTag = null;
        String prop = null;
        while (xmlTags.hasNext()) {
            xmlTag = (String)xmlTags.next();
            prop = _article.elementText(xmlTag);
            if (CMyString.isEmpty(prop)) continue;
            _wcmDoc.setPropertyWithString((String)_tags.get(xmlTag), prop.trim());
        }
    }

    private com.trs.components.wcm.content.persistent.Document processDocSource(com.trs.components.wcm.content.persistent.Document _document) throws WCMException {
        String source = _document.getPropertyAsString("DOCSOURCE");
        if (CMyString.isEmpty(source)) {
            return _document;
        }
        WCMFilter aFilter = new WCMFilter("", "SRCNAME=?", "");
        aFilter.addSearchValues(0, source);
        aFilter.setMaxRowNumber(1);
        Sources docSources = new Sources(null);
        docSources.open(aFilter);
        Source docSource = null;
        if (docSources.isEmpty()) {
            docSource = new Source();
            docSource.setName(source);
            docSource.insert(User.getSystem());
        } else {
            docSource = (Source)docSources.getAt(0);
        }
        _document.setSource(docSource);
        return _document;
    }

    private String mapFile(String _fn) throws WCMException {
        if (!CMyFile.fileExists(_fn)) {
            FilesMan fileman = FilesMan.getFilesMan();
            String path = fileman.mapFilePath(_fn, 0);
            return path + _fn;
        }
        return _fn;
    }

    private String mapTcfFile(String _fn) {
        if (!CMyString.isEmpty(_fn) && CMyFile.fileExists(_fn)) {
            return _fn;
        }
        FilesMan fileman = FilesMan.getFilesMan();
        String fn = fileman.getPathConfigValue("DS", 0);
        fn = CMyString.setStrEndWith(fn, File.separatorChar);
        fn = fn + "importresource" + File.separator;
        if (CMyString.isEmpty(_fn)) {
            fn = fn + "xplus.tcf";
            return fn;
        }
        User user = ContextHelper.getLoginUser();
        fn = fn + user.getName() + user.getId() + File.separator + _fn;
        return fn;
    }

    private Map parseTcf(String _fn) throws Exception {
        if (CMyString.isEmpty(_fn) && DEFAULT_TAGS.size() > 0) {
            return DEFAULT_TAGS;
        }
        String fn = this.mapTcfFile(_fn);
        Document xmlDoc = XmlDocWithDom4j.parse(fn);
        List els = xmlDoc.selectSingleNode("custom-setings").selectNodes("ref");
        HashMap<String, String> map = new HashMap<String, String>(els.size());
        Iterator itr = els.iterator();
        Element el = null;
        while (itr.hasNext()) {
            el = (Element)itr.next();
            if (el == null) continue;
            map.put(el.attributeValue("tag-name"), el.attributeValue("tag-value"));
        }
        els.clear();
        if (DEFAULT_TAGS.size() == 0) {
            DEFAULT_TAGS.putAll(map);
        }
        return map;
    }

    public static void main(String[] args) {
        try {
            String fn = "e:\\1.xml";
            Document xmlDoc = XmlDocWithDom4j.parse(fn);
            Element article = (Element)xmlDoc.selectNodes("/PageInfoFile/ArticleList/Article").get(0);
            String text = article.selectSingleNode("Content").getText();
            System.out.println(text);
            System.out.println();
            System.out.println(text.trim().replaceAll("\n", "\n<p>"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

