/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.customize;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.customize.UserSetting;
import com.trs.components.wcm.customize.UserSettings;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BaseIdsMan;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;

public class CustomizedChannelIdsMan
extends BaseIdsMan {
    private UserSettings m_customizedChannels;
    private User m_currUser;

    protected CustomizedChannelIdsMan() {
    }

    public CustomizedChannelIdsMan(User _currUser) {
        this.init(_currUser);
    }

    @Override
    protected int getExistsSize() {
        return this.m_customizedChannels.size();
    }

    @Override
    protected int getExistsIdAt(int _nExistsIndex) {
        return ((UserSetting)this.m_customizedChannels.getAt(_nExistsIndex)).getId();
    }

    @Override
    protected void deleteExists(int _nExistsIndex) throws WCMException {
        this.m_customizedChannels.removeAt(_nExistsIndex, true);
    }

    @Override
    protected void addRelation(int _nNewId) throws WCMException {
        UserSetting setting = new UserSetting();
        setting.setUser(this.m_currUser.getId());
        setting.setObjId(_nNewId);
        setting.setObjType(101);
        setting.save(this.m_currUser);
    }

    private void init(User _currUser) {
        try {
            this.m_customizedChannels = this.getCustomedChannels(_currUser);
        }
        catch (WCMException e) {
            throw new RuntimeException(e);
        }
        this.m_currUser = _currUser;
    }

    private UserSettings getCustomedChannels(User _currUser) throws WCMException {
        if (_currUser == null) {
            throw new WCMException(10, I18NMessage.get(CustomizedChannelIdsMan.class, "CustomizedChannelIdsMan.label1", "\u65e0\u6548\u7684\u7528\u6237!"));
        }
        WCMFilter aFilter = new WCMFilter("", "UserId=" + _currUser.getId() + " AND ObjType=" + 101, "RangeIndex desc,SettingId asc", "ObjId");
        return UserSettings.openWCMObjs(_currUser, aFilter);
    }
}

