/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.sun.star.uno.Exception;
import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.resource.FileType;
import com.trs.components.wcm.version.AppendixUsedVersion;
import com.trs.components.wcm.version.AppendixUsedVersionMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import org.apache.log4j.Logger;

public class Appendix
extends CMSObj {
    private static Logger logger = Logger.getLogger(Appendix.class);
    public static final int OBJ_TYPE = 601;
    public static final String DB_TABLE_NAME = "WCMAPPENDIX";
    public static final String DB_ID_NAME = "APPENDIXID";
    private static final int FLAG_UNKNOWN = -1;
    public static final int FLAG_DOCCON = 0;
    public static final int FLAG_DOCAPD = 10;
    public static final int FLAG_DOCPIC = 20;
    public static final int FLAG_HTMLPIC = 30;
    public static final int FLAG_LINK = 40;
    public static final int FLAG_VIDEO = 50;
    public static final int FLAG_ALL_APD = 60;
    public static final int FLAG_FIELD_DOCAPD = 70;
    public static final int FLAG_FIELD_DOCPIC = 80;
    public static final int FLAG_FIELD_VIDEO = 90;
    public static final int FLAG_ALL = -1;
    public static final int APPENDIX_FLAG_DOCCON = 0;
    public static final int APPENDIX_FLAG_DOCAPD = 10;
    public static final int APPENDIX_FLAG_DOCPIC = 20;
    public static final int APPENDIX_FLAG_HTMLPIC = 30;
    public static final int APPENDIX_FLAG_LINK = 40;
    public static final int APPENDIX_FLAG_VIDEO = 50;
    public static final int APPENDIX_FLAG_ALL = -1;
    private boolean m_bForceAdd = false;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 601;
    }

    public boolean isDeleted() {
        return this.getId() < 0;
    }

    public int getDocId() {
        return this.getPropertyAsInt("APPDOCID", 0);
    }

    public boolean setDocId(int _docId) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(Appendix.class, "Appendix.label1", "\u6587\u6863\u7f16\u53f7\u4e0d\u5141\u8bb8\u4fee\u6539(Appendix.setDocId)"));
        }
        return this.setProperty("APPDOCID", _docId);
    }

    public int getFlag() {
        return this.getPropertyAsInt("APPFLAG", -1);
    }

    public String getFlagString() {
        return Appendix.getFlagString(this.getFlag());
    }

    public static String getFlagString(int _nFlag) {
        switch (_nFlag) {
            case 0: {
                return I18NMessage.get(Appendix.class, "Appendix.label2", "\u6b63\u6587\u9644\u4ef6");
            }
            case 10: {
                return I18NMessage.get(Appendix.class, "Appendix.label3", "\u6587\u6863\u9644\u4ef6");
            }
            case 20: {
                return I18NMessage.get(Appendix.class, "Appendix.label4", "\u6587\u6863\u56fe\u7247");
            }
            case 30: {
                return I18NMessage.get(Appendix.class, "Appendix.label5", "HTML\u56fe\u7247");
            }
            case 40: {
                return I18NMessage.get(Appendix.class, "Appendix.label6", "\u94fe\u63a5\u9644\u4ef6");
            }
            case 50: {
                return "\u89c6\u9891\u9644\u4ef6";
            }
        }
        return I18NMessage.get(Appendix.class, "Appendix.label7", "\u672a\u77e5");
    }

    public boolean setFlag(int _flag) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(Appendix.class, "Appendix.label8", "\u9644\u4ef6\u6807\u8bc6\u4e0d\u5141\u8bb8\u4fee\u6539(Appendix.setFlag)"));
        }
        if (_flag != 0 && _flag != 10 && _flag != 20 && _flag != 30 && _flag != 40 && _flag != 50 && _flag != 70 && _flag != 80 && _flag != 90) {
            throw new WCMException(10, I18NMessage.get(Appendix.class, "Appendix.label9", "\u65e0\u6548\u7684\u9644\u4ef6\u7c7b\u578b\u6807\u8bc6(Appendix.setFlag)"));
        }
        return this.setProperty("APPFLAG", _flag);
    }

    @Override
    public void setId(int _nId) {
        this.id = _nId;
        if (_nId > 0) {
            this.m_bForceAdd = true;
        }
    }

    @Override
    public void setNextId() throws WCMException {
        this.id = this.getNextId();
    }

    public int getFileTypeId() {
        return this.getPropertyAsInt("APPFILETYPE", 0);
    }

    public FileType getFileType() throws WCMException {
        return FileType.findById(this.getFileTypeId());
    }

    public String getFile() {
        return (String)this.getProperty("APPFILE");
    }

    public boolean setFile(String _file) throws WCMException {
        return this.setProperty("APPFILE", _file);
    }

    public String getDesc() {
        return (String)this.getProperty("APPDESC");
    }

    public boolean setDesc(String _desc) throws WCMException {
        return this.setProperty("APPDESC", _desc);
    }

    public String getAlt() {
        return (String)this.getProperty("APPLINKALT");
    }

    public boolean setAlt(String _alt) throws WCMException {
        return this.setProperty("APPLINKALT", _alt);
    }

    public int getApdProperty() {
        return this.getPropertyAsInt("APPPROP", 0);
    }

    public boolean setApdProperty(int _nProperty) throws WCMException {
        return this.setProperty("APPPROP", _nProperty);
    }

    public CMyDateTime getTime() {
        return this.getPropertyAsDateTime("APPTIME");
    }

    public boolean setTime(CMyDateTime _time) throws WCMException {
        return this.setProperty("APPTIME", _time);
    }

    public String getEditor() {
        return (String)this.getProperty("APPEDITOR");
    }

    public boolean setEditor(String _editor) throws WCMException {
        return this.setProperty("APPEDITOR", _editor);
    }

    public String getAuthor() {
        return (String)this.getProperty("APPAUTHOR");
    }

    public boolean setAuthor(String _author) throws WCMException {
        return this.setProperty("APPAUTHOR", _author);
    }

    public String getSrcFile() {
        return (String)this.getProperty("SRCFILE");
    }

    public boolean setSrcFile(String _srcFile) throws WCMException {
        return this.setProperty("SRCFILE", _srcFile);
    }

    public String getFileExt() {
        String sExt = (String)this.getProperty("FILEEXT");
        if (sExt == null) {
            sExt = CMyFile.extractFileExt(this.getFile());
        }
        return sExt;
    }

    public boolean setFileExt(String _fileExt) throws WCMException {
        return this.setProperty("FILEEXT", _fileExt);
    }

    public int getSerialNo() {
        return this.getPropertyAsInt("APPSERN", 0);
    }

    public void setSerialNo(int _nNextSerialNo) throws WCMException {
        this.setProperty("APPSERN", _nNextSerialNo);
    }

    private long getUsedVersionsAsLong() {
        return this.getPropertyAsLong("USEDVERSIONS", 0L);
    }

    public CMyBitsValue getUsedVersions() {
        return new CMyBitsValue(this.getUsedVersionsAsLong());
    }

    public boolean setUsedVersions(long _lUsedVersions) throws WCMException {
        return this.setProperty("USEDVERSIONS", _lUsedVersions);
    }

    public boolean isUsedByVersion(int _nVersion) {
        return CMyBitsValue.getBit(this.getUsedVersionsAsLong(), _nVersion);
    }

    public boolean isNotUsed() {
        return this.getUsedVersionsAsLong() == 0L;
    }

    public boolean setUsedByVersion(int _nVersion, boolean _bUsed) throws WCMException {
        Object objValue;
        long lValue = -1L;
        if (!this.isAddMode() && this.isModified() && (objValue = this.getNewProperty("USEDVERSIONS")) != null) {
            lValue = ((Number)objValue).longValue();
        }
        if (lValue < 0L) {
            lValue = this.getUsedVersionsAsLong();
        }
        lValue = CMyBitsValue.setBit(lValue, _nVersion, _bUsed);
        return this.setUsedVersions(lValue);
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            if (this.getSerialNo() == 0) {
                this.setSerialNo();
            }
            super.insert(_currUser);
        }
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("APPDOCID") == null) {
                throw new WCMException(1106, I18NMessage.get(Appendix.class, "Appendix.label11", "\u5c5e\u6027DocId\u6ca1\u6709\u8bbe\u7f6e(Appendix.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(Appendix.class, "Appendix.label12", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Appendix.isValid)"));
        }
        return true;
    }

    @Override
    public int delete(User _currUser) throws WCMException {
        String sFile = this.getFile();
        int nRet = super.delete(_currUser);
        if (this.getFlag() == 40 || this.getFlag() == 30 || this.getProperty("RelatePhotoIds") != null) {
            return nRet;
        }
        AppendixUsedVersionMgr appendixUsedVersionMgr = (AppendixUsedVersionMgr)DreamFactory.createObjectById("IAppendixUsedVersionMgr");
        AppendixUsedVersion appendixUsedVersion = appendixUsedVersionMgr.findByAppendixName(sFile);
        if (appendixUsedVersion == null || appendixUsedVersion.getUsedVersions() == 0) {
            logger.warn((Object)("\u9644\u4ef6[AppId=" + this.getId() + "][Title=" + this.getDesc() + "][DocId=" + this.getDocId() + "]\u88ab\u5220\u9664\uff0c\u6587\u4ef6[" + sFile + "]\u4fdd\u7559!"));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Appendix delete", (Throwable)new Exception("who call me? delete apd file"));
            }
        }
        return nRet;
    }

    @Override
    public synchronized BaseObj cloneToNewWCMObj() throws WCMException {
        FilesMan filesMan;
        Appendix newObj = (Appendix)super.cloneToNewObj();
        newObj.removeProperty("USEDVERSIONS");
        String sFlag = "P0";
        if (newObj.getFlag() == 20) {
            sFlag = "W0";
        }
        String sFile = newObj.getFile();
        if (newObj.getFlag() != 40 && sFile != null && sFile.trim().length() > 0 && (filesMan = FilesMan.getFilesMan()).fileExists(sFile)) {
            sFile = filesMan.copyWCMFile(sFile, sFlag);
        }
        newObj.setFile(sFile);
        return newObj;
    }

    public static final Appendix findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Appendix)BaseObj.findById(Appendix.class, _nId);
    }

    public static final Appendix createNewInstance() throws WCMException {
        return (Appendix)BaseObj.createNewInstance(Appendix.class);
    }

    public static final Appendix findByKey(Object _oKey) throws WCMException {
        return (Appendix)BaseObj.findByKey(Appendix.class, _oKey);
    }

    private void setSerialNo() throws WCMException {
        int nNextSerialNo = 0;
        String strSQL = "select max(APPSERN) from " + this.getDbTableName() + " where (APPDOCID=" + this.getDocId() + ") ";
        nNextSerialNo = this.getDBManager().sqlExecuteIntQuery(strSQL);
        nNextSerialNo = nNextSerialNo < 0 ? 0 : ++nNextSerialNo;
        this.setSerialNo(nNextSerialNo);
    }

    @Override
    public boolean setPropertyWithString(String name, String value) throws WCMException {
        if ("APPFILE".equalsIgnoreCase(name) && value != null) {
            value = value.trim();
        }
        return super.setPropertyWithString(name, value);
    }

    public boolean setRelatedColumn(String _relatedColumn) throws WCMException {
        return this.setProperty("RelatedColumn", _relatedColumn);
    }

    public String getRelatedColumn() {
        return this.getPropertyAsString("RelatedColumn");
    }

    @Override
    public boolean isValidInstance() {
        if (this.m_bForceAdd) {
            return true;
        }
        return !this.bAddMode && this.id > 0;
    }
}

