/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.ContextHelper;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;

public class UserDocumentMgr {
    private Documents getAllDocuments(WCMFilter _filter) throws WCMException {
        if (ContextHelper.getLoginUser() == null) {
            throw new WCMException(10, I18NMessage.get(UserDocumentMgr.class, "UserDocumentMgr.label1", "\u65e0\u6548\u7684\u7528\u6237,\u65e0\u6cd5\u53d6\u5f97\u8be5\u7528\u6237\u521b\u5efa\u7684\u6240\u6709\u6587\u6863!"));
        }
        WCMFilter aFilter = new WCMFilter("WCMDOCUMENT", "CrUser='" + CMyString.filterForSQL(ContextHelper.getLoginUser().getName()) + "'", "");
        aFilter.mergeWith(_filter);
        return Documents.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public Documents getDocuments(WCMFilter _filter) throws WCMException {
        String sWhere = "EXISTS(SELECT ChannelId from WCMChannel WHERE Status=0 AND ChannelId=DocChannel) AND DocStatus>0";
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        aFilter.mergeWith(_filter);
        return this.getAllDocuments(aFilter);
    }

    public Documents getRecycleDocuments(WCMFilter _filter) throws WCMException {
        String sWhere = "EXISTS(SELECT ChannelId FROM WCMChannel WHERE Status=0) AND DocStatus<0";
        WCMFilter aFilter = new WCMFilter("", sWhere, "CrTime desc");
        aFilter.mergeWith(_filter);
        return this.getAllDocuments(aFilter);
    }

    public Documents getDraft(WCMFilter _filter) throws WCMException {
        WCMFilter aFilter = new WCMFilter("", "DocStatus>0 and DocChannel=0", "");
        aFilter.mergeWith(_filter);
        return this.getAllDocuments(aFilter);
    }
}

