/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.components.stat.IStatResult;
import com.trs.components.stat.IStatResults;
import com.trs.components.stat.IStatResultsFilter;
import com.trs.infra.common.WCMException;
import java.util.ArrayList;
import java.util.List;

public class StatResults
implements IStatResults {
    List results = new ArrayList();
    List mainObjs = new ArrayList();
    List xLabels = new ArrayList();

    public StatResults() {
    }

    public StatResults(List _majorObjects, List _results, List _labels) {
        this.mainObjs = _majorObjects;
        this.results = _results;
        this.xLabels = _labels;
    }

    @Override
    public void addResult(IStatResult result) {
        this.results.add(result);
        this.addMainObjs(result);
    }

    public void addMainObjs(IStatResult result) {
        List mainList = result.list();
        for (int i = 0; i < mainList.size(); ++i) {
            if (this.mainObjs.contains(mainList.get(i))) continue;
            this.mainObjs.add(mainList.get(i));
        }
    }

    @Override
    public List getResult(String sKey) {
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        for (int i = 0; i < this.results.size(); ++i) {
            IStatResult oStatResult = (IStatResult)this.results.get(i);
            resultList.add(new Integer(oStatResult.getResult(sKey)));
        }
        return resultList;
    }

    @Override
    public List getResult(int nIndex, String sKey) {
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        for (int i = 0; i < this.results.size(); ++i) {
            IStatResult oStatResult = (IStatResult)this.results.get(i);
            resultList.add(new Integer(oStatResult.getResult(nIndex, sKey)));
        }
        return resultList;
    }

    @Override
    public List getResult(int index, String[] keys) {
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        for (int i = 0; i < this.results.size(); ++i) {
            IStatResult oStatResult = (IStatResult)this.results.get(i);
            resultList.add(new Integer(oStatResult.getResult(index, keys)));
        }
        return resultList;
    }

    @Override
    public List getResult(String[] keys) {
        return this.getResult(1, keys);
    }

    @Override
    public IStatResults filter(IStatResultsFilter resultsFilter) throws WCMException {
        List list = this.list();
        ArrayList<String> newMajorObjects = new ArrayList<String>(list.size());
        int length = list.size();
        for (int i = 0; i < length; ++i) {
            String sKey = (String)list.get(i);
            if (!resultsFilter.accept(sKey, this)) continue;
            newMajorObjects.add(sKey);
        }
        StatResults statResults = new StatResults(newMajorObjects, this.results, this.xLabels);
        return statResults;
    }

    @Override
    public List list() {
        return this.mainObjs;
    }

    @Override
    public void addXlabels(String sCurrLabel) {
        this.xLabels.add(sCurrLabel);
    }

    @Override
    public List getXlabels() {
        return this.xLabels;
    }
}

