/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.components.stat.BaseStatHandler;
import com.trs.components.stat.DefaultStatHandler;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.DebugTimer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DocStatHandler4UserDeptChannel
extends BaseStatHandler {
    private static Logger logger = Logger.getLogger(DefaultStatHandler.class);
    private ChannelMgr m_oChannelMgr = null;
    private HashMap m_hRelGroupsOfUser = null;
    private int m_ChannelId = 0;
    private Channels channels;

    public DocStatHandler4UserDeptChannel(int _nChannelId) {
        this.m_ChannelId = _nChannelId;
        this.m_hRelGroupsOfUser = new HashMap();
        this.m_oChannelMgr = (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");
    }

    @Override
    public void visitStart(ResultSet resultSet, int nSQLIndex) throws WCMException {
        super.visitStart(resultSet, nSQLIndex);
        Channel currChannel = Channel.findById(this.m_ChannelId);
        this.channels = (Channels)this.m_oChannelMgr.getChildren(currChannel, -1, false, new WCMFilter());
        this.channels.addElement(currChannel);
    }

    @Override
    public void visitStatItem(ResultSet resultSet, int nSQLIndex) throws WCMException {
        try {
            int nColumnCount = resultSet.getMetaData().getColumnCount();
            int nChannelId = resultSet.getInt(nColumnCount);
            if (this.channels.indexOf(nChannelId) < 0) {
                return;
            }
            int nDataCount = resultSet.getInt(1);
            String sUserName = resultSet.getString(2);
            DebugTimer timerTemp = new DebugTimer();
            timerTemp.start();
            Groups oRelGroups = this.makeCurrRelGroups(sUserName);
            timerTemp.stop();
            logger.debug((Object)("makeCurrRelGroups of " + sUserName + " use[" + timerTemp.getTime() + "]ms"));
            timerTemp.start();
            int nSize = oRelGroups.size();
            for (int nRelGroupIndex = 0; nRelGroupIndex < nSize; ++nRelGroupIndex) {
                Group oRelGroup = (Group)oRelGroups.getAt(nRelGroupIndex);
                if (oRelGroup == null) continue;
                String sGroupId = oRelGroup.getId() + "";
                String oGroupKey = this.makePrivateKey(sGroupId, this.m_ChannelId + "", resultSet);
                int iExistsDataCount = this.getValue(nSQLIndex, oGroupKey);
                int nDataCountOfCurrGroup = nDataCount;
                this.setValue(nSQLIndex, oGroupKey, nDataCountOfCurrGroup += iExistsDataCount);
                this.addMajorObject(sGroupId);
            }
        }
        catch (SQLException e) {
            logger.debug((Object)"\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new WCMException("\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    private String makePrivateKey(String groupKey, String sChannelId, ResultSet resultSet) throws SQLException {
        int nColumnCount = resultSet.getMetaData().getColumnCount();
        String[] sParam = new String[nColumnCount - 1];
        sParam[0] = groupKey;
        sParam[1] = sChannelId;
        for (int i = 3; i < nColumnCount; ++i) {
            sParam[i - 1] = resultSet.getString(i);
        }
        return this.makeKey(sParam);
    }

    private Groups makeCurrRelGroups(String _sLowerCaseUserName) throws WCMException {
        Groups oCurrRelGroups = (Groups)this.m_hRelGroupsOfUser.get(_sLowerCaseUserName);
        if (oCurrRelGroups != null) {
            return oCurrRelGroups;
        }
        oCurrRelGroups = new Groups(null);
        User oCurrUser = User.findByName(_sLowerCaseUserName);
        if (oCurrUser == null) {
            return oCurrRelGroups;
        }
        Groups groups = oCurrUser.getGroups();
        int nSize = groups.size();
        for (int i = 0; i < nSize; ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null) continue;
            for (Group parent = group; parent != null; parent = parent.getParent()) {
                oCurrRelGroups.addElement(parent);
            }
        }
        this.m_hRelGroupsOfUser.put(oCurrUser.getKey(), oCurrRelGroups);
        return oCurrRelGroups;
    }
}

