/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.stat.BonusRule;
import com.trs.components.stat.BonusRules;
import com.trs.components.stat.IBonusCalculator;
import com.trs.components.stat.IBonusRuleMgr;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class BonusCalculator
implements IBonusCalculator {
    private static Logger logger = Logger.getLogger(BonusCalculator.class);
    private IBonusRuleMgr m_oBonusRuleMgr = (IBonusRuleMgr)DreamFactory.createObjectById("IBonusRuleMgr");

    @Override
    public float caclulateIssuedAmountBonus(int _nDocCount) throws WCMException {
        if (_nDocCount == 0) {
            return 0.0f;
        }
        User currUser = User.getSystem();
        WCMFilter filter = new WCMFilter("", "BonusType = ?", "PRICEPERUNIT ASC");
        filter.addSearchValues(1);
        BonusRules bonusRules = this.m_oBonusRuleMgr.query(currUser, filter);
        if (bonusRules == null) {
            return 0.0f;
        }
        int nHigherLimit = 0;
        int nLowerLimit = 0;
        float fPricePerUnit = 0.0f;
        float fMoney = 0.0f;
        int nSize = bonusRules.size();
        for (int i = 0; i < nSize; ++i) {
            BonusRule bonusRule = (BonusRule)bonusRules.getAt(i);
            if (bonusRule == null) continue;
            String sRange = bonusRule.getRange();
            if (CMyString.isEmpty(sRange)) {
                logger.error((Object)("\u5956\u52b1\u89c4\u5219\u3010id=" + bonusRule.getId() + "\u3011\u7684\u5956\u52b1\u8303\u56f4\u4e3a\u7a7a"));
                sRange = "0,0";
            }
            String[] pRange = sRange.split(",");
            nLowerLimit = Integer.parseInt(pRange[0]);
            if (pRange[1].equalsIgnoreCase("#")) {
                pRange[1] = "2147483647";
            }
            nHigherLimit = Integer.parseInt(pRange[1]);
            fPricePerUnit = bonusRule.getPricePerUnit();
            if (_nDocCount <= nLowerLimit) continue;
            if (_nDocCount > nHigherLimit) {
                fMoney += (float)(nHigherLimit - nLowerLimit) * fPricePerUnit;
                continue;
            }
            fMoney += (float)(_nDocCount - nLowerLimit) * fPricePerUnit;
        }
        return fMoney;
    }

    @Override
    public float caclulateHitsBonus(int _nHitsCount) throws WCMException {
        if (_nHitsCount == 0) {
            return 0.0f;
        }
        User currUser = User.getSystem();
        WCMFilter filter = new WCMFilter("", "BonusType = ?", "PRICEPERUNIT ASC");
        filter.addSearchValues(2);
        BonusRules bonusRules = this.m_oBonusRuleMgr.query(currUser, filter);
        if (bonusRules == null) {
            return 0.0f;
        }
        int nHigherLimit = 0;
        int nLowerLimit = 0;
        float fPricePerUnit = 0.0f;
        float fMoney = 0.0f;
        int nSize = bonusRules.size();
        for (int i = 0; i < nSize; ++i) {
            BonusRule bonusRule = (BonusRule)bonusRules.getAt(i);
            if (bonusRule == null) continue;
            String sRange = bonusRule.getRange();
            if (CMyString.isEmpty(sRange)) {
                logger.error((Object)("\u5956\u52b1\u89c4\u5219\u3010id=" + bonusRule.getId() + "\u3011\u7684\u5956\u52b1\u8303\u56f4\u4e3a\u7a7a"));
                sRange = "0,0";
            }
            String[] pRange = sRange.split(",");
            nLowerLimit = Integer.parseInt(pRange[0]);
            if (pRange[1].equalsIgnoreCase("#")) {
                pRange[1] = "2147483647";
            }
            nHigherLimit = Integer.parseInt(pRange[1]);
            fPricePerUnit = bonusRule.getPricePerUnit();
            if (_nHitsCount <= nLowerLimit) continue;
            if (_nHitsCount > nHigherLimit) {
                fMoney += (float)(nHigherLimit - nLowerLimit) * fPricePerUnit;
                continue;
            }
            fMoney += (float)(_nHitsCount - nLowerLimit) * fPricePerUnit;
        }
        return fMoney;
    }
}

