/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.right;

import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMSystemObject;
import com.trs.components.metadata.definition.MetaDBTable;
import com.trs.components.metadata.definition.MetaView;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;

public class AuthServerMgr {
    public static boolean hasRight(User _loginUser, MetaDBTable _oDBTable) throws WCMException {
        if (_loginUser.isAdministrator()) {
            return true;
        }
        if (_oDBTable == null) {
            return false;
        }
        CMSObj owner = AuthServerMgr.findOwner(_oDBTable.getOwnerType(), _oDBTable.getOwnerId());
        return AuthServerMgr.hasRight(_loginUser, owner);
    }

    public static boolean hasRight(User _loginUser, MetaView _view) throws WCMException {
        if (_loginUser.isAdministrator()) {
            return true;
        }
        if (_view == null) {
            return false;
        }
        CMSObj owner = AuthServerMgr.findOwner(_view.getOwnerType(), _view.getOwnerId());
        return AuthServerMgr.hasRight(_loginUser, owner);
    }

    private static CMSObj findOwner(int _nOwnerType, int _nOwnerId) throws WCMException {
        switch (_nOwnerType) {
            case 1: {
                return new WCMSystemObject(_nOwnerId);
            }
        }
        CMSObj result = (CMSObj)BaseObj.findById(_nOwnerType, _nOwnerId);
        if (result == null) {
            throw new WCMException(I18NMessage.get(AuthServerMgr.class, "AuthServerMgr.label1", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u5bf9\u8c61\uff01[Type=") + _nOwnerType + ", Id=" + _nOwnerId + "]");
        }
        return result;
    }

    private static boolean hasRight(User _loginUser, CMSObj _owner) throws WCMException {
        if (_loginUser.isAdministrator()) {
            return true;
        }
        int nRightIndex = -1;
        switch (_owner.getWCMType()) {
            case 101: {
                nRightIndex = 13;
                break;
            }
            case 1: {
                nRightIndex = -1;
                break;
            }
            default: {
                throw new WCMException(I18NMessage.get(AuthServerMgr.class, "AuthServerMgr.label2", "\u672a\u77e5\u7684Owner Type\uff01[Type=") + _owner.getWCMType() + "]");
            }
        }
        return !(nRightIndex >= 0 ? !AuthServer.hasRight(_loginUser, _owner, nRightIndex) : !_loginUser.isAdministrator());
    }
}

