/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.taskdispatch;

import com.trs.components.common.publish.config.persistent.LaborResourceConfig;
import com.trs.components.common.publish.domain.taskdispatch.ILaborResourceMgr;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.persistent.IConfigElement;
import org.apache.log4j.Logger;

public class LaborResourceMgrImpl
implements ILaborResourceMgr {
    private static Logger logger = Logger.getLogger((String)LaborResourceMgrImpl.class.getName());
    private int m_nHighPriorityLaborsMax = 10;
    private int m_nLowPriorityLaborsMax = 10;
    private int m_nEachTaskLaborsMax = 10;
    private int m_nHighPriorityLaborsUsed = 0;
    private int m_nLowPriorityLaborsUsed = 0;

    public synchronized void clear() {
        this.m_nHighPriorityLaborsUsed = 0;
        this.m_nLowPriorityLaborsUsed = 0;
        this.notifyAll();
    }

    @Override
    public void configure(IConfigElement _config) throws Exception {
        if (_config == null) {
            return;
        }
        LaborResourceConfig laborRscConfig = (LaborResourceConfig)_config;
        try {
            logger.debug((Object)"to configure labor resource ...");
            this.m_nHighPriorityLaborsMax = laborRscConfig.getHighPriorityLaborsMax();
            this.m_nLowPriorityLaborsMax = laborRscConfig.getLowPriorityLaborsMax();
            this.m_nEachTaskLaborsMax = laborRscConfig.getEachTaskLaborsMax();
        }
        catch (Exception ex) {
            throw new WCMException(12, "Failed to configure the labor resource manager!", ex);
        }
    }

    @Override
    public int calMaxLaborNeeded(int _nTaskCount, int _nPriority) {
        if (_nTaskCount <= this.m_nEachTaskLaborsMax) {
            return _nTaskCount / 2 + 1;
        }
        return _nTaskCount / (_nTaskCount / this.m_nEachTaskLaborsMax + 1);
    }

    @Override
    public synchronized boolean hasFreeLabor(int _nPriority) {
        return this.inventoryLeft(_nPriority) > 0;
    }

    private int inventoryLeft(int _nPriority) {
        if (_nPriority < 5 && this.m_nHighPriorityLaborsUsed < this.m_nHighPriorityLaborsMax) {
            return this.m_nLowPriorityLaborsMax - this.m_nLowPriorityLaborsUsed;
        }
        return this.m_nLowPriorityLaborsMax + this.m_nHighPriorityLaborsMax - this.m_nHighPriorityLaborsUsed - this.m_nLowPriorityLaborsUsed;
    }

    @Override
    public synchronized int applyForLabor(int _nMaxNeed, int _nPriority) {
        int nApplied;
        int nLeft = this.inventoryLeft(_nPriority);
        if (nLeft <= 0) {
            return 0;
        }
        int n = nApplied = nLeft >= _nMaxNeed ? _nMaxNeed : nLeft;
        if (_nPriority < 5) {
            this.m_nLowPriorityLaborsUsed += nApplied;
        } else {
            this.m_nHighPriorityLaborsUsed += nApplied;
        }
        logger.debug((Object)("MaxNeed=" + _nMaxNeed + "; Priority=" + _nPriority + "; Applied=" + nApplied));
        return nApplied;
    }

    @Override
    public synchronized void releaseLabor(int _nCount, int _nPriority) {
        if (_nPriority < 5) {
            this.m_nLowPriorityLaborsUsed -= _nCount;
            if (this.m_nLowPriorityLaborsUsed < 0) {
                this.m_nLowPriorityLaborsUsed = 0;
            }
        } else {
            this.m_nHighPriorityLaborsUsed -= _nCount;
            if (this.m_nHighPriorityLaborsUsed < 0) {
                this.m_nHighPriorityLaborsUsed = 0;
            }
        }
        this.notifyAll();
        logger.debug((Object)("Priority=" + _nPriority + "; Count=" + _nCount));
    }
}

