/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine.handlers;

import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.definition.FlowCondition;
import com.trs.cms.process.engine.ExecuteContext;
import com.trs.cms.process.engine.IConditionHandler;
import com.trs.cms.process.engine.handlers.ConditionHelper;
import com.trs.infra.common.WCMException;

public class ContentPropertyHandler
implements IConditionHandler {
    @Override
    public boolean isAccordWith(ExecuteContext _context, FlowCondition _condition) throws WCMException {
        String sParamName = _condition.getParamName();
        String sParamValue = _condition.getParamValue();
        IFlowContent content = _context.getFlowContent();
        if (content == null) {
            return false;
        }
        String sContentValue = content.getProperty(sParamName);
        if (sContentValue == null) {
            return false;
        }
        int nOperator = _condition.getRelationOperator().toUpperCase().hashCode();
        switch (nOperator) {
            case 61: {
                return sParamValue.equals(sContentValue);
            }
            case 1084: {
                return !sParamValue.equals(sContentValue);
            }
            case 60: 
            case 62: 
            case 1921: 
            case 1983: {
                return ConditionHelper.compare(sContentValue, sParamValue, nOperator);
            }
            case -2053034266: {
                return sContentValue.length() == sParamValue.length();
            }
            case 2336663: {
                return sContentValue.indexOf(sParamValue) >= 0;
            }
            case -1964662556: {
                return sContentValue.indexOf(sParamValue) == -1;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        String[] pValues = new String[]{"like", "=", ">=", ">", "<", "<=", "length", "!=", "not like"};
        for (int i = 0; i < pValues.length; ++i) {
            String value = pValues[i];
            System.out.println(value.toUpperCase());
            System.out.println(value.toUpperCase().hashCode());
        }
    }
}

