/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.definition;

import com.trs.DreamFactory;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowEmploy;
import com.trs.cms.process.definition.FlowEmploys;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.cache.ICacheMgr;
import org.apache.log4j.Logger;

public class FlowEmployCacheMgr
implements ICacheMgr {
    private static Logger logger = Logger.getLogger(FlowEmployCacheMgr.class);
    private static Cache cache = (Cache)DreamFactory.createObjectById("cache");
    private static final int MAX_CACHE_SIZE = 3000;

    Flow getFlowOfEmployer(int _nEmployerType, int _nEmployerId) throws WCMException {
        String sKey = this.makeKey(_nEmployerType, _nEmployerId);
        Integer flowId = (Integer)cache.get(sKey);
        if (flowId == null) {
            this.initFlowEmployCache();
            flowId = (Integer)cache.get(sKey);
        }
        return Flow.findByKey(flowId);
    }

    private synchronized void initFlowEmployCache() throws WCMException {
        if (cache.exists(this.getKey()).booleanValue()) {
            return;
        }
        cache.set(this.getKey(), "true");
        logger.info((Object)"init...");
        cache.setMaxSize(3000L);
        FlowEmploys aFlowEmploys = FlowEmploys.openWCMObjs(null, null);
        int nCount = aFlowEmploys.size();
        FlowEmploy aFlowEmploy = null;
        for (int i = 0; i < nCount; ++i) {
            aFlowEmploy = (FlowEmploy)aFlowEmploys.getAt(i);
            if (aFlowEmploy == null) continue;
            cache.set(this.makeKey(aFlowEmploy), new Integer(aFlowEmploy.getFlowId()));
        }
    }

    public void notify(int _nEventType, Object _oCacheObj, Object[] _data) {
    }

    @Override
    public boolean init() throws WCMException {
        this.initFlowEmployCache();
        return true;
    }

    @Override
    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    @Override
    public void clear() {
        cache.clear(this.getKey());
    }

    public boolean isDoNotify(int _nEventType, Object _oCacheObj, Object[] _data) {
        return false;
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        FlowEmploy flowEmploy = (FlowEmploy)_oObjAdded;
        cache.set(this.makeKey(flowEmploy), new Integer(flowEmploy.getFlowId()));
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        FlowEmploy flowEmploy = (FlowEmploy)_oObjDeleted;
        cache.clear(this.makeKey(flowEmploy));
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        FlowEmploy flowEmploy = (FlowEmploy)_oObjModified;
        if (flowEmploy.isChangeProperty("FLOWID")) {
            cache.clear(this.makeKey(flowEmploy));
            int newFlowId = _oObjModified.getNewPropertyAsInt("FLOWID", 0);
            cache.set(this.makeKey(flowEmploy), new Integer(newFlowId));
        }
    }

    private String makeKey(FlowEmploy _flowEmploy) {
        return this.makeKey(_flowEmploy.getEmployerType(), _flowEmploy.getEmployerId());
    }

    private String makeKey(int _nEmployerType, int _nEmployerId) {
        return this.getKey(_nEmployerType + "_" + _nEmployerId);
    }

    private String getKey(String key) {
        return this.getKey() + "." + key;
    }

    private String getKey() {
        return FlowEmployCacheMgr.class.getName();
    }
}

