/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process;

import com.trs.cms.process.DefaultFlowNotify;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.IFlowNotify;
import com.trs.cms.process.IFlowNotifyAcceptor;
import com.trs.infra.I18NMessage;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class FlowContentNotifyFactory {
    private static Logger logger = Logger.getLogger(FlowContentNotifyFactory.class);
    private List flowNotifys = null;
    private boolean bLoaded = false;
    private static FlowContentNotifyFactory m_oFlowContentNotifyFactory = null;

    public static FlowContentNotifyFactory getInstance() {
        if (m_oFlowContentNotifyFactory == null) {
            m_oFlowContentNotifyFactory = new FlowContentNotifyFactory();
        }
        return m_oFlowContentNotifyFactory;
    }

    private synchronized void load() {
        if (this.bLoaded) {
            return;
        }
        Iterator iterator = WCMDiscoveryFactory.getDiscovery().getImplementors("com.trs.cms.process.IFlowNotify");
        this.flowNotifys = new ArrayList();
        while (iterator != null && iterator.hasNext()) {
            String sClazz = (String)iterator.next();
            try {
                this.flowNotifys.add(Class.forName(sClazz));
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)I18NMessage.get(FlowContentNotifyFactory.class, "FlowContentNotifyFactory.label1", "\u52a0\u8f7d\u7c7b\u5931\u8d25\uff01"), (Throwable)e);
            }
        }
        this.bLoaded = true;
    }

    public IFlowNotify getFlowNotify(IFlowContent flowContent, int nRelFlowDocId) {
        if (flowContent == null) {
            return null;
        }
        if (!this.bLoaded) {
            this.load();
        }
        try {
            for (int i = 0; i < this.flowNotifys.size(); ++i) {
                Constructor constructor = ((Class)this.flowNotifys.get(i)).getConstructor(IFlowContent.class, Integer.TYPE);
                Object flowNotify = constructor.newInstance(flowContent, nRelFlowDocId);
                if (!((IFlowNotifyAcceptor)flowNotify).accept()) continue;
                return (IFlowNotify)flowNotify;
            }
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(FlowContentNotifyFactory.class, "FlowContentNotifyFactory.label2", "\u521b\u5efa\u5de5\u4f5c\u6d41\u5bf9\u8c61\u5931\u8d25\uff01"), (Throwable)e);
        }
        return new DefaultFlowNotify(flowContent, nRelFlowDocId);
    }
}

