/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.content;

import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyBitsValue;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WCMObjsHandler
extends DefaultHandler {
    private CMSObj m_oSrcWCMObj;
    private StringBuffer m_sbValue;
    private boolean m_bParseObjProp;
    private String m_sWCMObjTagName = "WCMOBJ";
    private boolean m_bParasingObj = false;
    private CMSObj m_currWCMObj = null;
    private ArrayList m_arList = null;

    public WCMObjsHandler(CMSObj _obj, String _sTagName) {
        this.m_oSrcWCMObj = _obj;
        this.m_bParseObjProp = false;
        this.m_sWCMObjTagName = _sTagName;
        this.m_arList = new ArrayList();
    }

    public WCMObjsHandler(CMSObj _obj) {
        this.m_oSrcWCMObj = _obj;
        this.m_bParseObjProp = false;
        this.m_arList = new ArrayList();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if ((qName = qName.toUpperCase()).equals(this.m_sWCMObjTagName) || qName.equals(this.m_oSrcWCMObj.getDbTableName())) {
            this.m_bParasingObj = true;
            this.m_currWCMObj = (CMSObj)this.m_oSrcWCMObj.clone();
            return;
        }
        if (this.m_bParasingObj && qName.equals("PROPERTIES")) {
            this.m_bParseObjProp = true;
            this.m_sbValue = new StringBuffer();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.m_bParseObjProp && this.m_sbValue != null) {
            this.m_sbValue.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ((qName = qName.toUpperCase()).equals("PROPERTIES")) {
            this.m_bParseObjProp = false;
            return;
        }
        if (qName.equals(this.m_sWCMObjTagName) || qName.equals(this.m_oSrcWCMObj.getDbTableName())) {
            this.m_bParasingObj = false;
            this.saveWCMObj();
            return;
        }
        if (this.m_bParseObjProp) {
            try {
                String sValue = this.m_sbValue.toString().trim();
                if (qName.equals("RIGHTVALUE")) {
                    CMyBitsValue currValue = new CMyBitsValue(sValue);
                    currValue.setValue(sValue);
                    sValue = String.valueOf(currValue.getValue());
                }
                this.m_currWCMObj.setPropertyWithString(qName, sValue);
            }
            catch (Exception e) {
                throw new SAXException(I18NMessage.get(WCMObjsHandler.class, "WCMObjsHandler.label1", "\u8bbe\u7f6e[") + qName.toUpperCase() + I18NMessage.get(WCMObjsHandler.class, "WCMObjsHandler.label2", "]\u5c5e\u6027\u5931\u8d25\uff01"), e);
            }
            finally {
                this.m_sbValue.delete(0, this.m_sbValue.length());
            }
        }
    }

    private void saveWCMObj() {
        this.m_arList.add(this.m_currWCMObj);
    }

    public List getWCMObjList() {
        return this.m_arList;
    }
}

