/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.config.RightConfigServer;
import com.trs.cms.auth.domain.GroupAuthServer;
import com.trs.cms.auth.domain.IRightHost;
import com.trs.cms.auth.domain.IRightMgr;
import com.trs.cms.auth.domain.IRightObj;
import com.trs.cms.auth.domain.RightCacheMgr;
import com.trs.cms.auth.domain.RightObjectFactory;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.Rights;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.RoleUserCacheMgr;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMObjHelper;
import com.trs.cms.content.WCMSystemObject;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyBitsValue;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class AuthServer {
    private static Logger logger = Logger.getLogger(AuthServer.class);
    private static RightConfigServer s_oRightConfigServer;
    private static RoleUserCacheMgr roleUserCacheMgr;

    public static boolean hasRight(User _currUser, CMSObj _objCurrent, int _index) throws WCMException {
        if (_objCurrent instanceof WCMSystemObject) {
            return _currUser.isAdministrator();
        }
        return AuthServer.hasRight(_currUser, _objCurrent, _index, false);
    }

    public static boolean hasRightInObjects(User _currUser, CMSBaseObjs _objects, int _index) throws WCMException {
        int nSize = _objects.size();
        for (int i = 0; i < nSize; ++i) {
            CMSObj cmsObj = (CMSObj)_objects.getAt(i);
            if (cmsObj == null || AuthServer.hasRight(_currUser, cmsObj, _index)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasRight(User _currUser, CMSObj _objCurrent, int _index, boolean _bGetFromSelf) throws WCMException {
        IRightObj rightObj;
        if (_objCurrent instanceof Document) {
            Document doc = (Document)_objCurrent;
            if (doc == null) {
                return false;
            }
            return DocumentAuthServer.hasRight(_currUser, (BaseChannel)doc.getChannel(), doc, _index);
        }
        if (_objCurrent instanceof ChnlDoc) {
            ChnlDoc chnldoc = (ChnlDoc)_objCurrent;
            if (chnldoc == null) {
                return false;
            }
            return DocumentAuthServer.hasRight(_currUser, chnldoc, _index);
        }
        if (_objCurrent instanceof Group) {
            return GroupAuthServer.hasRight(_currUser, (Group)_objCurrent, _index);
        }
        if (_index == -1) {
            return true;
        }
        if (_currUser == null) {
            throw new WCMException(I18NMessage.get(AuthServer.class, "AuthServer.label1", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u6821\u9a8c\u7684\u7528\u6237\uff01"));
        }
        if (_currUser.isSystem()) {
            logger.warn((Object)I18NMessage.get(AuthServer.class, "AuthServer.label2", "\u5f53\u524d\u5224\u65ad\u6743\u9650\u7528\u6237\u4e3aSystem!"));
            return false;
        }
        if (_objCurrent == null) {
            return AuthServer.hasAttributeRight(_currUser, _index);
        }
        if (!_bGetFromSelf && (rightObj = RightObjectFactory.makeRightObjectFrom(_objCurrent)) != null) {
            return rightObj.hasRight(_currUser, _index);
        }
        return AuthServer.hasRightOnSelf(_currUser, _objCurrent, _index);
    }

    private static boolean hasAttributeRight(User _currUser, int _index) throws WCMException {
        if (_currUser == null) {
            throw new WCMException(I18NMessage.get(AuthServer.class, "AuthServer.label1", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u6821\u9a8c\u7684\u7528\u6237\uff01"));
        }
        if (_currUser.isAdministrator()) {
            return true;
        }
        int nExtMaxIndex = WCMRightTypes.getExtMaxIndex();
        int nSysMinIndex = WCMRightTypes.getSysMinIndex();
        if (_index < nSysMinIndex || _index > nExtMaxIndex) {
            return false;
        }
        int nSysMaxIndex = WCMRightTypes.getSysMaxIndex();
        RightValue rightValue = new RightValue();
        rightValue.load(_currUser, 1, _index <= nSysMaxIndex ? 1 : 2);
        return rightValue.isHasRight(_index);
    }

    private static boolean hasStatisticAttributeRight(User _currUser, int _index) throws WCMException {
        if (_currUser == null) {
            throw new WCMException(I18NMessage.get(AuthServer.class, "AuthServer.label1", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u6821\u9a8c\u7684\u7528\u6237\uff01"));
        }
        if (_currUser.isAdministrator()) {
            return true;
        }
        int nStstisticMaxIndex = WCMRightTypes.getStatisticMaxIndex();
        int nSysMinIndex = WCMRightTypes.getSysMinIndex();
        if (_index < nSysMinIndex || _index > nStstisticMaxIndex) {
            return false;
        }
        RightValue rightValue = new RightValue();
        rightValue.load(_currUser, 1, 3);
        return rightValue.isHasRight(_index);
    }

    public static boolean hasAttributeRight(User _currUser) throws WCMException {
        if (_currUser == null) {
            throw new WCMException(I18NMessage.get(AuthServer.class, "AuthServer.label1", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u6821\u9a8c\u7684\u7528\u6237\uff01"));
        }
        if (_currUser.isAdministrator()) {
            return true;
        }
        int nSysMinIndex = WCMRightTypes.getSysMinIndex();
        int nSysMaxIndex = WCMRightTypes.getSysMaxIndex();
        for (int i = nSysMinIndex; i <= nSysMaxIndex; ++i) {
            if (!AuthServer.hasAttributeRight(_currUser, i)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasExtendedRight(User _currUser) throws WCMException {
        int nExtMinIndex;
        if (_currUser == null) {
            throw new WCMException(I18NMessage.get(AuthServer.class, "AuthServer.label1", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u6821\u9a8c\u7684\u7528\u6237\uff01"));
        }
        if (_currUser.isAdministrator()) {
            return true;
        }
        int nExtMaxIndex = WCMRightTypes.getExtMaxIndex();
        for (int i = nExtMinIndex = WCMRightTypes.getExtMinIndex(); i <= nExtMaxIndex; ++i) {
            if (!AuthServer.hasAttributeRight(_currUser, i)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasExtendedRight(User _currUser, int _nRightIndex) throws WCMException {
        if (_currUser == null) {
            throw new WCMException(I18NMessage.get(AuthServer.class, "AuthServer.label1", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u6821\u9a8c\u7684\u7528\u6237\uff01"));
        }
        if (_currUser.isAdministrator()) {
            return true;
        }
        if (_nRightIndex < 53 || _nRightIndex > 60) {
            return false;
        }
        return AuthServer.hasAttributeRight(_currUser, _nRightIndex);
    }

    public static boolean hasStatisticRight(User _currUser) throws WCMException {
        int nStatisticMinIndex;
        if (_currUser == null) {
            throw new WCMException("");
        }
        if (_currUser.isAdministrator()) {
            return true;
        }
        int nStatiticMaxIndex = WCMRightTypes.getStatisticMaxIndex();
        for (int i = nStatisticMinIndex = WCMRightTypes.getStatisticMinIndex(); i <= nStatiticMaxIndex; ++i) {
            if (!AuthServer.hasStatisticAttributeRight(_currUser, i)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasStatisticRight(User _currUser, int _nRightIndex) throws WCMException {
        if (_currUser == null) {
            throw new WCMException(I18NMessage.get(AuthServer.class, "AuthServer.label1", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u6821\u9a8c\u7684\u7528\u6237\uff01"));
        }
        if (_currUser.isAdministrator()) {
            return true;
        }
        if (_nRightIndex < 60 || _nRightIndex > 60) {
            return false;
        }
        return AuthServer.hasStatisticAttributeRight(_currUser, _nRightIndex);
    }

    public static boolean hasRightOnSelf(User _currUser, int _nObjType, int _nObjId, int _index) throws WCMException {
        if (_currUser == null) {
            throw new WCMException("\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u6821\u9a8c\u7684\u7528\u6237\uff01");
        }
        if (_currUser.isAdministrator()) {
            return true;
        }
        RightValue rightValue = new RightValue();
        rightValue.load(_currUser, _nObjType, _nObjId);
        return rightValue.isHasRight(_index);
    }

    public static boolean hasRightOnSelfExcludeSuper(User _currUser, CMSObj _objCurrent, int _index) throws WCMException {
        if (_index == -1) {
            return true;
        }
        if (_currUser == null) {
            throw new WCMException(I18NMessage.get(AuthServer.class, "AuthServer.label1", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u6821\u9a8c\u7684\u7528\u6237\uff01"));
        }
        if (_currUser.isSystem()) {
            logger.warn((Object)I18NMessage.get(AuthServer.class, "AuthServer.label2", "\u5f53\u524d\u5224\u65ad\u6743\u9650\u7528\u6237\u4e3aSystem!"));
            return false;
        }
        if (_objCurrent == null) {
            return _currUser.isAdministrator();
        }
        BaseObjs roles = null;
        BaseObjs groups = null;
        RightCacheMgr rightCacheMgr = (RightCacheMgr)DreamFactory.createObjectById("RightCacheMgr");
        try {
            Role role;
            int i;
            long lRightValue = rightCacheMgr.getRightValue(_objCurrent.getWCMType(), _objCurrent.getId(), 204, _currUser.getId(), -1L);
            if (lRightValue != -1L) {
                boolean bl = AuthServer.hasRight(lRightValue, _index);
                return bl;
            }
            roles = _currUser.getRoles();
            for (i = 0; i < roles.size(); ++i) {
                role = (Role)roles.getAt(i);
                if (role == null) {
                    logger.error((Object)("The cache is error? The role[ID=" + roles.getIdAt(i) + "] of user[" + _currUser.getName() + "] not exists!"));
                    continue;
                }
                if (role.isSystemRole() || (lRightValue = rightCacheMgr.getRightValue(_objCurrent.getWCMType(), _objCurrent.getId(), 203, roles.getIdAt(i), -1L)) == -1L || !AuthServer.hasRight(lRightValue, _index)) continue;
                boolean bl = true;
                return bl;
            }
            roles = roleUserCacheMgr.getRoles(_currUser, RightValue.getSite(_objCurrent.getWCMType(), _objCurrent.getId()));
            for (i = 0; i < roles.size(); ++i) {
                role = (Role)roles.getAt(i);
                if (role == null) {
                    logger.error((Object)("The cache is error? The role[ID=" + roles.getIdAt(i) + "] of user[" + _currUser.getName() + "] not exists!"));
                    continue;
                }
                lRightValue = role.isSystemRole() ? role.getRightValue() : rightCacheMgr.getRightValue(_objCurrent.getWCMType(), _objCurrent.getId(), 203, roles.getIdAt(i), -1L);
                if (lRightValue == -1L || !AuthServer.hasRight(lRightValue, _index)) continue;
                boolean bl = true;
                return bl;
            }
            groups = _currUser.getGroups();
            block13: for (i = 0; i < groups.size(); ++i) {
                Group group = (Group)groups.getAt(i);
                if (group == null) continue;
                lRightValue = rightCacheMgr.getRightValue(_objCurrent.getWCMType(), _objCurrent.getId(), 201, groups.getIdAt(i), -1L);
                if (lRightValue == -1L) {
                    String isPermit = ConfigServer.getServer().getSysConfigValue("SUBGROUP_IS_INHERITS_PARENTGROUP_RIGHTS", "true");
                    if (!isPermit.equalsIgnoreCase("true")) continue;
                    for (Group parentGroup = group.getParent(); parentGroup != null && groups.indexOf(parentGroup.getId()) < 0; parentGroup = parentGroup.getParent()) {
                        lRightValue = rightCacheMgr.getRightValue(_objCurrent.getWCMType(), _objCurrent.getId(), 201, parentGroup.getId(), -1L);
                        if (lRightValue == -1L) continue;
                        if (!AuthServer.hasRight(lRightValue, _index)) continue block13;
                        boolean bl = true;
                        return bl;
                    }
                    continue;
                }
                if (!AuthServer.hasRight(lRightValue, _index)) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(AuthServer.class, "AuthServer.label3", "\u53d6\u7528\u6237\u6743\u9650\u503c\u65f6\u5931\u8d25(RightValue.load)"), ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(AuthServer.class, "AuthServer.label3", "\u53d6\u7528\u6237\u6743\u9650\u503c\u65f6\u5931\u8d25(RightValue.load)"), ex);
        }
        finally {
            if (roles != null) {
                roles.clear();
            }
            if (groups != null) {
                groups.clear();
            }
        }
        return false;
    }

    public static boolean hasRightOnSelf(User _currUser, CMSObj _objCurrent, int _index) throws WCMException {
        if (_index == -1) {
            return true;
        }
        if (_currUser == null) {
            throw new WCMException(I18NMessage.get(AuthServer.class, "AuthServer.label1", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u6821\u9a8c\u7684\u7528\u6237\uff01"));
        }
        if (_currUser.isSystem()) {
            logger.warn((Object)I18NMessage.get(AuthServer.class, "AuthServer.label2", "\u5f53\u524d\u5224\u65ad\u6743\u9650\u7528\u6237\u4e3aSystem!"));
            return false;
        }
        if (_objCurrent == null) {
            return _currUser.isAdministrator();
        }
        if (AuthServer.hasSuperRight(_currUser, _objCurrent)) {
            return true;
        }
        return AuthServer.hasRightOnSelfExcludeSuper(_currUser, _objCurrent, _index);
    }

    public static boolean hasRight(CMSObj _operator, CMSObj _currObj, int _nRightIndex) throws WCMException {
        if (_operator instanceof User) {
            return AuthServer.hasRight((User)_operator, _currObj, _nRightIndex);
        }
        RightValue aRightValue = AuthServer.getRightMgr().getRightValue(_currObj, _operator);
        return AuthServer.hasRight(aRightValue, _nRightIndex);
    }

    public static boolean hasRight(RightValue aRightValue, int _index) throws WCMException {
        if (aRightValue == null) {
            throw new WCMException(20, I18NMessage.get(AuthServer.class, "AuthServer.label4", "\u6743\u9650\u503c\u5f02\u5e38\uff0c\u65e0\u6cd5\u9a8c\u8bc1\u6743\u9650\uff01"));
        }
        if (_index == 64 && aRightValue.getValue() > 0L) {
            return true;
        }
        if (aRightValue.isHasRight(_index)) {
            return true;
        }
        return AuthServer.hasSimlarRight(aRightValue, _index);
    }

    public static boolean hasRight(long _lRightValue, int _index) {
        if (_index == 64 && _lRightValue > 0L) {
            return true;
        }
        CMyBitsValue bitesValue = new CMyBitsValue(_lRightValue);
        if (bitesValue.getBit(_index)) {
            return true;
        }
        return AuthServer.hasSimlarRight(bitesValue, _index);
    }

    private static boolean hasSimlarRight(CMyBitsValue aRightValue, int _nRightIndex) {
        int[] pSimilarIndex = AuthServer.getRightConfigServer().getSimilarIndexs(_nRightIndex);
        for (int i = 0; i < pSimilarIndex.length; ++i) {
            int nSimilarIndex = pSimilarIndex[i];
            if (nSimilarIndex == 0) {
                return false;
            }
            if (!aRightValue.getBit(nSimilarIndex)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasRight(User _currUser, CMSObj _currObj) throws WCMException {
        return AuthServer.hasRight(_currUser, _currObj, 64);
    }

    public static boolean hasSuperRight(User _currUser, CMSObj _currObj) throws WCMException {
        if (_currUser == null) {
            throw new WCMException(10, I18NMessage.get(AuthServer.class, "AuthServer.label5", "\u4f20\u5165\u7684\u5bf9\u8c61\u4e3a\u7a7a,\u65e0\u6cd5\u6821\u9a8c\u6743\u9650!"));
        }
        if (AuthServer.isUserObj(_currObj) || AuthServer.isGroupObj(_currObj) || AuthServer.isRoleObj(_currObj)) {
            return _currUser.isSecurityAdmin();
        }
        if (_currUser.isAdministrator()) {
            return true;
        }
        return _currObj != null && _currUser.getName().equalsIgnoreCase(_currObj.getCrUserName());
    }

    public static boolean setSystemMgrRights(int _nObjId, List _currRightList) throws WCMException {
        if (!ContextHelper.getLoginUser().isAdministrator()) {
            throw new WCMException(1002, I18NMessage.get(AuthServer.class, "AuthServer.label6", "\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u6ca1\u6709\u6743\u9650\u8bbe\u7f6e\u7cfb\u7edf\u5c5e\u6027\u7684\u6743\u9650\uff01"));
        }
        AuthServer.deleteAttributeRights(WCMObjHelper.toIdsString(_currRightList), _nObjId);
        if (_currRightList == null || _currRightList.isEmpty()) {
            return true;
        }
        for (int i = 0; i < _currRightList.size(); ++i) {
            Right currRight = (Right)_currRightList.get(i);
            if (currRight == null) {
                logger.error((Object)I18NMessage.get(AuthServer.class, "AuthServer.label7", "\u4ece\u6743\u9650\u96c6\u5408\u5217\u8868\u4e2d\u53d6\u5f97\u5355\u72ec\u7684\u6743\u9650\u4e3a\u7a7a\uff01"));
                continue;
            }
            if (AuthServer.saveAttributeRight(currRight, _nObjId)) continue;
            logger.error((Object)I18NMessage.get(AuthServer.class, "AuthServer.label8", "\u4ece\u6743\u9650\u96c6\u5408\u4e2d\u4fdd\u5b58\u4e00\u4e2a\u6743\u9650\u65f6\u53d1\u751f\u9519\u8bef"));
        }
        return true;
    }

    public static IRightHost makeRightHost(int _nHostType, int _nHostId) throws WCMException {
        IRightHost host = null;
        try {
            host = (IRightHost)((Object)BaseObj.findById(_nHostType, _nHostId));
        }
        catch (ClassCastException ex) {
            throw new WCMException(I18NMessage.get(AuthServer.class, "AuthServer.label9", "\u6307\u5b9a\u7684\u5143\u7d20\u5bf9\u8c61[HostType=") + _nHostType + ",HostId=" + _nHostId + I18NMessage.get(AuthServer.class, "AuthServer.label10", "]\u4e0d\u662fIRightHost\u7684\u5b9e\u73b0\uff01"));
        }
        return host;
    }

    private static boolean deleteAttributeRights(String _sCurrentRightIds, int _nObjId) throws WCMException {
        String sWhere = "OBJTYPE=1 and OBJID= " + _nObjId;
        if (_sCurrentRightIds.length() > 0) {
            sWhere = sWhere + " and RIGHTID not in (" + _sCurrentRightIds + ")";
        }
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        Rights delRights = Rights.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        delRights.removeAll(true);
        return true;
    }

    private static IRightMgr getRightMgr() throws WCMException {
        IRightMgr aMgr = (IRightMgr)DreamFactory.createObjectById("IRightMgr");
        if (aMgr == null) {
            throw new WCMException(1400, I18NMessage.get(AuthServer.class, "AuthServer.label11", "IRightMgr\u5728\u5de5\u5382\u4e2d\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        return aMgr;
    }

    private static boolean saveAttributeRight(Right _aRight, int _nObjId) throws WCMException {
        if (_aRight == null) {
            return false;
        }
        if (_aRight.getObjType() == 0) {
            _aRight.setObject(1, _nObjId);
        }
        _aRight.save(ContextHelper.getLoginUser());
        return true;
    }

    public static RightValue getRightValue(CMSObj _currObj, User _currOpUser) throws WCMException {
        return AuthServer.getRightMgr().getRightValue(_currObj, _currOpUser);
    }

    public static RightValue getRightValue(CMSObj _currObj, CMSObj _currOperator) throws WCMException {
        return AuthServer.getRightMgr().getRightValue(_currObj, _currOperator);
    }

    public static String getLogicalRightValue(CMSObj _currObj, User _currOpUser, int[] _rightIndexes) throws WCMException {
        int i;
        if (_rightIndexes == null || _rightIndexes.length <= 0) {
            return "0";
        }
        if (_currOpUser != null && (_currOpUser.isAdministrator() || _currOpUser.equals(_currObj.getCrUser())) && _currObj.getWCMType() != 605) {
            return "1";
        }
        Arrays.sort(_rightIndexes);
        int nBufferLength = _rightIndexes[_rightIndexes.length - 1] + 1;
        StringBuffer sbRightValue = new StringBuffer(nBufferLength);
        sbRightValue.setLength(nBufferLength);
        for (i = 0; i < nBufferLength; ++i) {
            sbRightValue.setCharAt(i, '0');
        }
        for (i = 0; i < _rightIndexes.length; ++i) {
            int nIndex = _rightIndexes[i];
            if (nIndex < 0) continue;
            sbRightValue.setCharAt(nIndex, AuthServer.hasRight(_currOpUser, _currObj, nIndex) ? (char)'1' : '0');
        }
        sbRightValue = sbRightValue.reverse();
        return sbRightValue.toString();
    }

    private static RightConfigServer getRightConfigServer() {
        if (s_oRightConfigServer == null) {
            s_oRightConfigServer = RightConfigServer.getInstance();
        }
        return s_oRightConfigServer;
    }

    public static boolean isManagerOfUser(User _loginUser, User _dstUser) throws WCMException {
        if (_loginUser.isSecurityAdmin() || _loginUser.getName().equalsIgnoreCase(_dstUser.getCrUserName())) {
            return true;
        }
        User owner = _dstUser.getCrUser();
        if (owner == null) {
            return false;
        }
        if (owner.isSecurityAdmin()) {
            return false;
        }
        String sQueryMgrGroupsWhere = "select GroupId from WCMGrpUser where UserId=? and IsAdministrator=1";
        String sMgrSameGroupSQL = "select GroupId from WCMGrpUser where UserId=? and IsAdministrator=1 and GroupId in(select GroupId from WCMGrpUser where UserId=? and IsAdministrator=1)";
        int[] pParametors = new int[]{_loginUser.getId(), owner.getId()};
        int nResult = DBManager.getDBManager().sqlExecuteIntQuery(sMgrSameGroupSQL, pParametors);
        return nResult > 0;
    }

    public static boolean hasMgrDocSourceRight(User _currUser) throws WCMException {
        WebSites oWebSites = WebSites.openWCMObjs(_currUser, null);
        int nLen = oWebSites.size();
        for (int i = 0; i < nLen; ++i) {
            boolean bEditSite;
            WebSite currWebSite = (WebSite)oWebSites.getAt(i);
            if (currWebSite == null || !(bEditSite = AuthServer.hasRight(_currUser, (CMSObj)currWebSite, 1))) continue;
            return true;
        }
        return false;
    }

    public static boolean isUserObj(CMSObj _currObj) throws WCMException {
        return _currObj instanceof User;
    }

    public static boolean isGroupObj(CMSObj _currObj) throws WCMException {
        return _currObj instanceof Group;
    }

    public static boolean isRoleObj(CMSObj _currObj) throws WCMException {
        return _currObj instanceof Role;
    }

    static {
        roleUserCacheMgr = (RoleUserCacheMgr)DreamFactory.createObjectById("RoleUserCacheMgr");
    }
}

