/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.controler.servlet;

import com.trs.cms.ContextHelper;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.IExpectError;
import com.trs.infra.persistent.InjectSQLHelper;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.context.ServiceContext;
import com.trs.webframework.controler.servlet.LoginValidatorFactory;
import com.trs.webframework.entity.RedirectObject;
import com.trs.webframework.exception.ServiceInvocationException;
import com.trs.webframework.xmlserver.parser.ServletInputStreamWrapper;
import com.trs.webframework.xmlserver.parser.StreamBuddy;
import com.trs.webframework.xmlserver.server.IRequestProcessor;
import com.trs.webframework.xmlserver.server.RequestParamsProcessor;
import com.trs.webframework.xmlserver.server.RequestXMLDataProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ServiceControler
extends HttpServlet {
    private static Logger logger = Logger.getLogger(ServiceControler.class);
    private static final long serialVersionUID = -6830625166991280397L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServiceContext oServiceContext = null;
        String sServiceId = null;
        IRequestProcessor processor = null;
        try {
            if (!response.containsHeader("SelfDefinedContentType")) {
                response.setContentType("text/xml;charset=UTF-8");
            }
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", -1L);
            response.setDateHeader("max-age", 0L);
            String sMethodName = request.getMethod();
            request.setCharacterEncoding("ISO-8859-1");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"============== service begin! ===========");
            }
            String isFormData = request.getHeader("formdata");
            InputStream reqStream = null;
            if ("POST".equalsIgnoreCase(sMethodName) && !"1".equals(isFormData)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"============== copyRequestInputStream... ===========");
                }
                reqStream = StreamBuddy.copyRequestInputStream((InputStream)request.getInputStream());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"============== copyRequestInputStream end===========");
                }
            }
            oServiceContext = new ServiceContext(request, response);
            oServiceContext.setInputStreamWrapper(new ServletInputStreamWrapper(reqStream));
            sServiceId = oServiceContext.getParameterValue("ServiceId");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"============== isLogin... ===========");
            }
            if (!LoginValidatorFactory.createLoginValidator().isLogin(request)) {
                response.setHeader("TRSNotLogin", "true");
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"============== isLogin end! ===========");
            }
            if (sServiceId == null || (sServiceId = sServiceId.trim()).length() == 0) {
                InputStream streamTmp = reqStream;
                processor = new RequestXMLDataProcessor(oServiceContext, streamTmp);
            } else {
                processor = new RequestParamsProcessor(oServiceContext);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("============== do[" + processor + "] begin! ==========="));
            }
            Object result = null;
            result = processor.excute();
            if (result != null && result instanceof RedirectObject) {
                this.forword((RedirectObject)result, request, response);
                return;
            }
            if (oServiceContext.isReturnJSON()) {
                response.setContentType("text/javascript;charset=UTF-8");
                response.setHeader("ReturnJSON", "true");
            } else if (oServiceContext.isReturnHTML()) {
                response.setContentType("text/html;charset=UTF-8");
                response.setHeader("ReturnHTML", "true");
            }
            PrintWriter wirter = response.getWriter();
            if (result == null) {
                ((Writer)wirter).write("");
            } else if (result instanceof String) {
                ((Writer)wirter).write((String)result);
            } else {
                ((Writer)wirter).write(I18NMessage.get(ServiceControler.class, "ServiceControler.label1", "<result>\u4e0d\u652f\u6301\u5904\u7406\u7684\u7c7b\u578b[") + result.getClass() + "]\uff01</result>");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("============== do[" + processor + "] end! ==========="));
            }
        }
        catch (Throwable ex) {
            if (processor != null) {
                MethodConfig oMethodConfig = processor.getCurrentMethodConfig();
                String sMethodName = null;
                if (oMethodConfig != null) {
                    sMethodName = oMethodConfig.getName();
                }
                MethodContext oMethodContext = processor.getCurrentMethodContext();
                String sParameters = null;
                if (oMethodContext != null) {
                    sParameters = oMethodContext.getValues().toString();
                }
                logger.error((Object)("Failt to execute[" + sServiceId == null ? "" : (sServiceId + "." + sMethodName == null ? "" : (sMethodName + "]Parameters=[" + sParameters == null ? "" : sParameters + "]User=[" + ContextHelper.getLoginUser() + "]"))), ex);
            } else {
                logger.error((Object)("Failt to execute[" + sServiceId == null ? "" : sServiceId + "]"), ex);
            }
            response.setContentType("text/xml;charset=utf-8");
            PrintWriter wirter = response.getWriter();
            response.setHeader("TRSException", "true");
            if (ex instanceof IExpectError) {
                this.writeFault(wirter, ((IExpectError)((Object)ex)).getErrorCode(), ex.getMessage(), null, "");
            } else {
                this.writeFault(wirter, "5000", "\u7cfb\u7edf\u9519\u8bef\uff01\u8bf7\u548c\u7ba1\u7406\u5458\u8054\u7cfb\uff01", null, "");
            }
            ((Writer)wirter).flush();
            ((Writer)wirter).close();
        }
        finally {
            ContextHelper.clear();
        }
    }

    private void forword(RedirectObject oRedirectObj, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String sRedirectUri = null;
        if (oRedirectObj == null || (sRedirectUri = oRedirectObj.getTarget()) == null) {
            return;
        }
        if (!oRedirectObj.isWithinDomain()) {
            response.sendRedirect(sRedirectUri);
            return;
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(sRedirectUri);
        if (dispatcher == null) {
            throw new ServiceInvocationException(I18NMessage.get(ServiceControler.class, "ServiceControler.label2", "\u65e0\u6cd5\u83b7\u53d6\u9875\u9762[") + sRedirectUri + "]!");
        }
        try {
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (ServletException ex) {
            throw ex;
        }
        finally {
            ContextHelper.clear();
        }
    }

    private void writeFault(Writer _wirter, String _sCode, String _sMessage, Object _detail, String _sSuggestion) throws IOException {
        Element element;
        boolean bShowDetailInfo = false;
        try {
            bShowDetailInfo = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("SHOW_ERROR_DETAILINFO", "false"));
        }
        catch (Exception e) {
            logger.error((Object)"Fail to get config value[SHOW_ERROR_DETAILINFO]", (Throwable)e);
        }
        Element root = DocumentHelper.createElement((String)"fault");
        root.addCDATA(_sCode);
        if (_sCode != null) {
            element = root.addElement("code");
            element.addCDATA(_sCode);
        }
        if (_sMessage != null) {
            if (!bShowDetailInfo && InjectSQLHelper.containsInjectInfoSQL(_sMessage)) {
                _sMessage = "\u7cfb\u7edf\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u548c\u6280\u672f\u8fd0\u7ef4\u4eba\u5458\u8054\u7cfb!";
            }
            element = root.addElement("message");
            if (CMyString.containsCDATAStr(_sMessage)) {
                element.addText(_sMessage);
            } else {
                element.addCDATA(_sMessage);
            }
        }
        if (_detail != null && bShowDetailInfo) {
            String sDetail = "";
            sDetail = _detail instanceof Throwable && ConfigServer.getServer().isShowDetailErrorInfo() ? CMyException.getStackTraceText((Throwable)_detail) : _detail.toString();
            Element element2 = root.addElement("detail");
            if (CMyString.containsCDATAStr(sDetail)) {
                element2.addText(sDetail);
            } else {
                element2.addCDATA(sDetail);
            }
        }
        if (_sSuggestion != null) {
            element = root.addElement("suggestion");
            if (CMyString.containsCDATAStr(_sSuggestion)) {
                element.addText(_sSuggestion);
            } else {
                element.addCDATA(_sSuggestion);
            }
        }
        _wirter.write(root.asXML());
    }
}

