/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.trsserver.task;

import com.eprobiti.trs.TRSConnection;
import com.eprobiti.trs.TRSDataBase;
import com.eprobiti.trs.TRSDataBaseColumn;
import com.eprobiti.trs.TRSException;
import com.trs.cms.auth.persistent.User;
import com.trs.gateway.client.GWConnection;
import com.trs.gateway.client.GWManager;
import com.trs.gateway.client.GWTaskStatus;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.ConnectPasswordEncrypter;
import com.trs.infra.persistent.db.DBConnectionConfig;
import com.trs.infra.persistent.db.DBManager;
import com.trs.wcm.trsserver.task.DBHelper;
import com.trs.wcm.trsserver.task.ISearchTaskMgr;
import com.trs.wcm.trsserver.task.SearchTaskConstants;
import com.trs.wcm.trsserver.task.persistent.SearchTask;
import com.trs.wcm.trsserver.task.persistent.SearchTasks;
import com.trs.wcm.trsserver.task.persistent.TRSGateway;
import com.trs.wcm.trsserver.task.persistent.TRSServer;
import java.util.HashMap;
import java.util.Properties;

public class SearchTaskMgr
implements ISearchTaskMgr {
    @Override
    public SearchTasks queryTasks(WCMFilter _filter) throws WCMException {
        return SearchTasks.openWCMObjs(null, _filter);
    }

    @Override
    public SearchTask saveTask(User _oCurrUser, SearchTask _oSearchTask) throws WCMException {
        String sCurrViewName = _oSearchTask.getViewName().trim();
        String sNewViewName = this.createDBViewNameNotUsed(_oSearchTask.getViewType(), sCurrViewName);
        if (!sNewViewName.equalsIgnoreCase(sCurrViewName) && _oSearchTask.isAddMode()) {
            _oSearchTask.setViewName(sNewViewName);
        }
        this.createViewOnDB(_oSearchTask);
        this.createTableOnTRSServerFrom(_oSearchTask);
        String sGatewayTaskName = this.createTaskOnGateway(_oSearchTask);
        _oSearchTask.setTRSGWTaskName(sGatewayTaskName);
        _oSearchTask.save(_oCurrUser);
        return _oSearchTask;
    }

    @Override
    public void createViewOnDB(SearchTask _oSearchTask) throws WCMException {
        String sSQL = this.createDBViewSQL(_oSearchTask);
        DBManager dbManager = DBManager.getDBManager();
        dbManager.sqlExecuteUpdate(sSQL);
    }

    @Override
    public void deleteViewOnDB(SearchTask _oSearchTask) throws WCMException {
        String sSQL = "drop view " + _oSearchTask.getViewName();
        DBManager dbManager = DBManager.getDBManager();
        dbManager.sqlExecuteUpdate(sSQL);
    }

    @Override
    public int queryTaskStatus(SearchTask _oSearchTask) throws WCMException {
        TRSGateway gateway = _oSearchTask.getTRSGateway();
        try {
            Properties properties = new Properties();
            properties.setProperty("property_gw_host", gateway.getIP());
            properties.setProperty("property_gw_port", String.valueOf(gateway.getPort()));
            properties.setProperty("property_gw_username", gateway.getUserName());
            properties.setProperty("property_gw_password", gateway.getPassword());
            GWConnection gwconnection = GWManager.getConnection((Properties)properties);
            GWTaskStatus status = gwconnection.getTaskStatus(_oSearchTask.getTRSGWTaskName());
            return status.isRunning() ? 2 : 3;
        }
        catch (Exception e) {
            throw new WCMException("\u521b\u5efaGateway\u8fde\u63a5\u5931\u8d25\uff01", e);
        }
    }

    @Override
    public boolean deleteTask(SearchTask _oSearchTask) throws WCMException {
        this.deleteTaskOnGateway(_oSearchTask);
        this.deleteTableOnTRSServerFrom(_oSearchTask);
        this.deleteViewOnDB(_oSearchTask);
        return true;
    }

    @Override
    public String createDBViewSQL(SearchTask _oSearchTask) throws WCMException {
        String sSearchFields = null;
        sSearchFields = !_oSearchTask.isAddMode() && _oSearchTask.isChangeProperty("FIELDS") ? _oSearchTask.getNewPropertyAsString("FIELDS") : _oSearchTask.getFields();
        String[] pSearchFields = sSearchFields.split(",");
        StringBuffer sbSelect = new StringBuffer(sSearchFields.length() + 100);
        for (int i = 0; i < pSearchFields.length; ++i) {
            String sSearchField = pSearchFields[i];
            if ((sSearchField = sSearchField.trim()).length() == 0) continue;
            if (!_oSearchTask.getMainTableName().equalsIgnoreCase("wcmchnldoc")) {
                sbSelect.append(SearchTaskMgr.createSelectExpress(sSearchField));
            } else {
                sbSelect.append(sSearchField);
            }
            sbSelect.append(",");
        }
        sbSelect.setLength(sbSelect.length() - 1);
        String sSQL = "create";
        if (!_oSearchTask.isAddMode()) {
            String sTemp = "drop view " + _oSearchTask.getViewName();
            DBManager dbManager = DBManager.getDBManager();
            dbManager.sqlExecuteUpdate(sTemp);
        }
        sSQL = sSQL + " view " + _oSearchTask.getViewName() + " as \nselect  " + sbSelect + "\n from " + _oSearchTask.getFrom() + "\n where " + _oSearchTask.getWhere();
        return sSQL;
    }

    @Override
    public String createDBViewNameNotUsed(int _nViewType, String _sCurrViewName) throws WCMException {
        String sViewNamePre = _sCurrViewName;
        DBManager dbManager = DBManager.getDBManager();
        String sViewName = sViewNamePre;
        int nCount = 1;
        while (true) {
            ++nCount;
            WCMFilter filter = new WCMFilter("", "TName=?", "");
            filter.addSearchValues(sViewName);
            SearchTasks tasks = SearchTasks.openWCMObjs(null, filter);
            if (tasks.isEmpty()) {
                try {
                    dbManager.sqlExecuteIntQuery("select 1 from " + sViewName);
                }
                catch (Exception e) {
                    return sViewName;
                }
            }
            sViewName = sViewNamePre + nCount;
        }
    }

    public static final String createSelectExpress(String _sFieldName) {
        String sFieldName = _sFieldName.trim();
        for (int i = 0; i < SearchTaskConstants.LOGIC_FIELDS.length; ++i) {
            if (!SearchTaskConstants.LOGIC_FIELDS[i].equalsIgnoreCase(sFieldName)) continue;
            return SearchTaskConstants.LOGIC_FIELD_SELECT_EXPRESS[i];
        }
        return _sFieldName;
    }

    @Override
    public String createTaskOnGateway(SearchTask _oSearchTask) throws WCMException {
        DBConnectionConfig dbConfig = DBManager.getDBManager().getDBConnConfig();
        TRSServer oTRSServerConfig = _oSearchTask.getTRSServer();
        TRSGateway gateway = _oSearchTask.getTRSGateway();
        try {
            String taskname;
            Properties properties = new Properties();
            properties.setProperty("property_gw_host", gateway.getIP());
            properties.setProperty("property_gw_port", String.valueOf(gateway.getPort()));
            properties.setProperty("property_gw_username", gateway.getUserName());
            properties.setProperty("property_gw_password", gateway.getPassword());
            System.out.println(properties);
            GWConnection gwconnection = null;
            gwconnection = GWManager.getConnection((Properties)properties);
            Properties taskProperties = new Properties();
            taskProperties.put("property_rdb_url", dbConfig.getConnectionURL());
            taskProperties.put("property_product_name", "wcm");
            taskProperties.put("property_rdb_username", dbConfig.getConnectionUser());
            taskProperties.put("property_rdb_password", ConnectPasswordEncrypter.deEncrypt(dbConfig.getConnectionPassword()));
            taskProperties.put("property_rdb_viewname", _oSearchTask.getViewName());
            taskProperties.put("property_rdb_view_primarykey", _oSearchTask.getViewIDName());
            taskProperties.put("property_rdb_tablename", _oSearchTask.getMainTableName());
            taskProperties.put("property_rdb_primarykey", _oSearchTask.getMainIDName());
            taskProperties.put("property_trs_host", oTRSServerConfig.getIP());
            taskProperties.put("property_trs_port", String.valueOf(oTRSServerConfig.getPort()));
            taskProperties.put("property_trs_username", oTRSServerConfig.getUserName());
            taskProperties.put("property_trs_password", oTRSServerConfig.getPassword());
            taskProperties.put("property_trs_database", _oSearchTask.getViewName());
            System.out.println(taskProperties);
            HashMap fieldsMap = new HashMap();
            if (!_oSearchTask.isAddMode()) {
                String sGWName = _oSearchTask.getTRSGWTaskName();
                gwconnection.deleteTask(sGWName);
            }
            if ((taskname = gwconnection.createTask(taskProperties, fieldsMap)) != null) {
                System.out.println("\u521b\u5efa\u4efb\u52a1\uff1a" + taskname);
            }
            return taskname;
        }
        catch (Exception e) {
            throw new WCMException("\u521b\u5efaGateway\u8fde\u63a5\u5931\u8d25\uff01", e);
        }
    }

    @Override
    public void deleteTaskOnGateway(SearchTask _oSearchTask) throws WCMException {
        TRSGateway gateway = _oSearchTask.getTRSGateway();
        try {
            Properties properties = new Properties();
            properties.setProperty("property_gw_host", gateway.getIP());
            properties.setProperty("property_gw_port", String.valueOf(gateway.getPort()));
            properties.setProperty("property_gw_username", gateway.getUserName());
            properties.setProperty("property_gw_password", gateway.getPassword());
            GWConnection gwconnection = null;
            gwconnection = GWManager.getConnection((Properties)properties);
            gwconnection.deleteTask(_oSearchTask.getTRSGWTaskName());
        }
        catch (Exception e) {
            throw new WCMException("\u5220\u9664Gateway\u4efb\u52a1\u5931\u8d25\uff01", e);
        }
    }

    @Override
    public void createTableOnTRSServerFrom(SearchTask _oSearchTask) throws WCMException {
        TRSServer server = null;
        if (_oSearchTask.isAddMode()) {
            server = _oSearchTask.getTRSServer();
        } else {
            server = TRSServer.findById(_oSearchTask.getNewPropertyAsInt("TRSERVERID", 0));
            if (server == null) {
                throw new WCMException("\u6307\u5b9a\u7684TRSServer\u4e0d\u5b58\u5728[ID=" + _oSearchTask.getNewPropertyAsInt("TRSERVERID", 0) + "]");
            }
        }
        TRSConnection connection = null;
        try {
            connection = new TRSConnection();
            connection.connect(server.getIP(), String.valueOf(server.getPort()), server.getUserName(), server.getPassword());
            String sTRSTableName = _oSearchTask.getViewName();
            TRSDataBase base = new TRSDataBase(connection, _oSearchTask.getViewName());
            if (!_oSearchTask.isAddMode()) {
                base.delete();
                base = new TRSDataBase(connection, _oSearchTask.getViewName());
            }
            base.setProperty("FIRSTTEXTCOL", _oSearchTask.getDefaultSearchName());
            String sViewIdName = _oSearchTask.getViewIDName();
            DBHelper.DBFieldInfo[] pDBFieldInfos = DBHelper.queryDBFields(_oSearchTask.getViewName());
            TRSDataBaseColumn[] cols = new TRSDataBaseColumn[pDBFieldInfos.length];
            for (int i = 0; i < pDBFieldInfos.length; ++i) {
                cols[i] = this.makeTRSColumn(sTRSTableName, sViewIdName, pDBFieldInfos[i]);
            }
            base.addColumn(cols);
            base.create();
        }
        catch (Exception e) {
            throw new WCMException("\u64cd\u4f5cTRSserver\u5931\u8d25\uff01TaskId=" + _oSearchTask.getId(), e);
        }
        finally {
            if (connection != null) {
                connection.close();
                connection = null;
            }
        }
    }

    @Override
    public void deleteTableOnTRSServerFrom(SearchTask _oSearchTask) throws WCMException {
        TRSServer server = _oSearchTask.getTRSServer();
        TRSConnection connection = null;
        try {
            connection = new TRSConnection();
            connection.connect(server.getIP(), String.valueOf(server.getPort()), server.getUserName(), server.getPassword());
            TRSDataBase[] dbs = connection.getDataBases(_oSearchTask.getViewName());
            dbs[0].delete();
        }
        catch (Exception e) {
            throw new WCMException("\u64cd\u4f5cTRSserver\u5931\u8d25\uff01TaskId=" + _oSearchTask.getId(), e);
        }
        finally {
            if (connection != null) {
                connection.close();
                connection = null;
            }
        }
    }

    private TRSDataBaseColumn makeTRSColumn(String _sTRSTableName, String _sIdName, DBHelper.DBFieldInfo _oDbFieldInfo) throws TRSException {
        TRSDataBaseColumn trscol = new TRSDataBaseColumn(_sTRSTableName, _oDbFieldInfo.getName());
        switch (_oDbFieldInfo.getType()) {
            case 2005: {
                trscol.setIntProperty("TYPE", 68);
                trscol.setIntProperty("RELEVANCE", 1);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                trscol.setIntProperty("TYPE", 64);
                trscol.setIntProperty("CACHEDATA", 1);
                break;
            }
            case -5: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 16: {
                trscol.setIntProperty("TYPE", 65);
                if (!_oDbFieldInfo.getName().equalsIgnoreCase(_sIdName)) break;
                trscol.setIntProperty("UNIQUEVALUE", 1);
                break;
            }
            default: {
                if (_oDbFieldInfo.getName().equalsIgnoreCase("CHNLNAME") || _oDbFieldInfo.getName().equalsIgnoreCase("SITENAME") || _oDbFieldInfo.getName().equalsIgnoreCase("DOCPUBURL")) {
                    trscol.setIntProperty("TYPE", 66);
                } else {
                    trscol.setIntProperty("TYPE", 67);
                }
                trscol.setIntProperty("RELEVANCE", 1);
                if (!_oDbFieldInfo.getName().equalsIgnoreCase("DOCKEYWORDS")) break;
                trscol.setIntProperty("MULTIVALUE", 1);
            }
        }
        return trscol;
    }
}

