/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.crawler.impl;

import com.trs.scm.sdk.IMicroContentMgr;
import com.trs.scm.sdk.crawler.IWeiboVisitor;
import com.trs.scm.sdk.crawler.impl.SCMWeiboCrawler;
import com.trs.scm.sdk.impl.TencentMicroContentMgr;
import com.trs.scm.sdk.model.ExtraParams;
import com.trs.scm.sdk.model.MicroContent;
import com.trs.scm.sdk.model.MicroContentWrapper;
import com.trs.scm.sdk.model.OAuth;
import java.util.List;
import org.apache.log4j.Logger;

public class TencentWeiboCrawler
extends SCMWeiboCrawler {
    private static Logger logger = Logger.getLogger(TencentWeiboCrawler.class);
    private final int TENCENT_TYPE_ORIGINAL = 1;
    private final int TENCENT_TYPE_REPOSTED = 2;
    private IMicroContentMgr m_oTencentMicroContentMgr;
    public static int SLEEP_MILLISECONDS_IN_EVERY_REQUEST = 1000;
    public static int MAX_REQUEST_RETRY_TIMES = 3;
    private int m_nCurrRetryTimes = 0;

    public TencentWeiboCrawler(OAuth oOauth) {
        super(oOauth);
        this.m_oTencentMicroContentMgr = new TencentMicroContentMgr(oOauth);
    }

    @Override
    public void execute(IWeiboVisitor visitor) {
        ExtraParams extraParams = this.getExtraParams();
        int nPageIndex = extraParams.getParamAsInt("PageIndex", 0);
        int nPageSize = extraParams.getParamAsInt("PageSize", 70);
        if (nPageSize > 70) {
            nPageSize = 70;
        }
        int nPageNum = extraParams.getParamAsInt("PageNum", 10);
        int nPageFlag = extraParams.getParamAsInt("PageFlag", 0);
        boolean bIsSetNum = false;
        int nDestPageNum = nPageIndex + nPageNum;
        if (nPageFlag == 2) {
            bIsSetNum = true;
        }
        while (true) {
            this.m_nCurrRetryTimes = 0;
            MicroContentWrapper oMicroContentWrapper = this.getWeiboInPage(nPageIndex, nPageSize);
            if (oMicroContentWrapper == null) {
                return;
            }
            List<MicroContent> oMicroContentList = oMicroContentWrapper.getMicroContents();
            for (int i = 0; i < oMicroContentList.size(); ++i) {
                MicroContent oMicroContent = oMicroContentList.get(i);
                if (oMicroContent == null) continue;
                visitor.visit(oMicroContent);
            }
            long lTotalNumber = oMicroContentWrapper.getTotalNumber();
            if ((long)((++nPageIndex - 1) * nPageSize) > lTotalNumber || bIsSetNum && nPageIndex >= nDestPageNum) {
                return;
            }
            try {
                Thread.sleep(SLEEP_MILLISECONDS_IN_EVERY_REQUEST);
                continue;
            }
            catch (InterruptedException e) {
                logger.debug((Object)"\u5c1d\u8bd5\u7ebf\u7a0b\u7761\u7720\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private MicroContentWrapper getWeiboInPage(int pageIndex, int pageSize) {
        ExtraParams extraParams = this.getExtraParams();
        int nType = extraParams.getParamAsInt("type", this.TENCENT_TYPE_ORIGINAL | this.TENCENT_TYPE_REPOSTED);
        try {
            return this.m_oTencentMicroContentMgr.getUserTimelineByType(nType, pageIndex, pageSize, extraParams);
        }
        catch (Exception e) {
            if (this.m_nCurrRetryTimes > MAX_REQUEST_RETRY_TIMES) {
                logger.error((Object)("\u8bf7\u6c42\u8d85\u51fa\u4e86\u5c1d\u8bd5\u7684\u6700\u5927\u6b21\u6570[" + MAX_REQUEST_RETRY_TIMES + "]"), (Throwable)e);
                return null;
            }
            ++this.m_nCurrRetryTimes;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.getWeiboInPage(pageIndex, pageSize);
        }
    }
}

