/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.util;

import com.trs.infra.config.TRSConfigServer;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;

public final class LoginPasswordEncrypter {
    private static final String ENCRYPTED_PREFIX = "Encrypted";
    private static final char[] ENCODE_ARRAY;
    private static final byte[] DECODE_ARRAY;

    public static String encrypt(String _original) {
        if (_original == null) {
            throw new NullPointerException("The original password is null.");
        }
        if (LoginPasswordEncrypter.isEncrypted(_original)) {
            return _original;
        }
        String encrypted = ENCRYPTED_PREFIX + LoginPasswordEncrypter.encode(_original.getBytes());
        try {
            LoginPasswordEncrypter.processConf(_original, encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encrypted;
    }

    public static String deEncrypt(String _encrypted) {
        if (_encrypted == null) {
            throw new NullPointerException("The deecncrypted password is null.");
        }
        if (LoginPasswordEncrypter.isEncrypted(_encrypted)) {
            String enccrypted = _encrypted.substring(ENCRYPTED_PREFIX.length(), _encrypted.length());
            return new String(LoginPasswordEncrypter.decode(enccrypted.getBytes()));
        }
        final String encrypted = _encrypted;
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LoginPasswordEncrypter.encrypt(encrypted);
            }
        };
        t.start();
        return _encrypted;
    }

    public static boolean isEncrypted(String _encrypted) {
        return _encrypted.indexOf(ENCRYPTED_PREFIX) == 0;
    }

    private static void processConf(String _original, String _encrypted) throws Exception {
        if (_original.equals(_encrypted)) {
            return;
        }
        String sPath = TRSConfigServer.getConfigRootPath() + "domain" + File.separatorChar;
        String resource = sPath + "config.xml";
        String original = "connectionPassword=\"" + _original + "\"";
        String encrypted = "connectionPassword=\"" + _encrypted + "\"";
        String file = CMyFile.readFile(resource);
        String newFile = CMyString.replaceStr(file, original, encrypted);
        CMyFile.writeFile(resource, newFile);
    }

    private static String encode(byte[] inbuf) {
        if (inbuf.length == 0) {
            return "";
        }
        byte[] outbuf = new byte[(inbuf.length + 2) / 3 * 4];
        int inpos = 0;
        int outpos = 0;
        for (int size = inbuf.length; size > 0; size -= 3) {
            byte c;
            byte b;
            byte a;
            if (size == 1) {
                a = inbuf[inpos++];
                b = 0;
                c = 0;
                outbuf[outpos++] = (byte)ENCODE_ARRAY[a >>> 2 & 0x3F];
                outbuf[outpos++] = (byte)ENCODE_ARRAY[(a << 4 & 0x30) + (b >>> 4 & 0xF)];
                outbuf[outpos++] = 46;
                outbuf[outpos++] = 46;
                continue;
            }
            if (size == 2) {
                a = inbuf[inpos++];
                b = inbuf[inpos++];
                c = 0;
                outbuf[outpos++] = (byte)ENCODE_ARRAY[a >>> 2 & 0x3F];
                outbuf[outpos++] = (byte)ENCODE_ARRAY[(a << 4 & 0x30) + (b >>> 4 & 0xF)];
                outbuf[outpos++] = (byte)ENCODE_ARRAY[(b << 2 & 0x3C) + (c >>> 6 & 3)];
                outbuf[outpos++] = 46;
                continue;
            }
            a = inbuf[inpos++];
            b = inbuf[inpos++];
            c = inbuf[inpos++];
            outbuf[outpos++] = (byte)ENCODE_ARRAY[a >>> 2 & 0x3F];
            outbuf[outpos++] = (byte)ENCODE_ARRAY[(a << 4 & 0x30) + (b >>> 4 & 0xF)];
            outbuf[outpos++] = (byte)ENCODE_ARRAY[(b << 2 & 0x3C) + (c >>> 6 & 3)];
            outbuf[outpos++] = (byte)ENCODE_ARRAY[c & 0x3F];
        }
        return new String(outbuf);
    }

    private static byte[] decode(byte[] inbuf) {
        int size = inbuf.length / 4 * 3;
        if (size == 0) {
            return inbuf;
        }
        if (inbuf[inbuf.length - 1] == 46) {
            --size;
            if (inbuf[inbuf.length - 2] == 46) {
                --size;
            }
        }
        byte[] outbuf = new byte[size];
        int inpos = 0;
        int outpos = 0;
        for (size = inbuf.length; size > 0; size -= 4) {
            byte a = DECODE_ARRAY[inbuf[inpos++] & 0xFF];
            byte b = DECODE_ARRAY[inbuf[inpos++] & 0xFF];
            outbuf[outpos++] = (byte)(a << 2 & 0xFC | b >>> 4 & 3);
            if (inbuf[inpos] == 46) {
                return outbuf;
            }
            a = b;
            b = DECODE_ARRAY[inbuf[inpos++] & 0xFF];
            outbuf[outpos++] = (byte)(a << 4 & 0xF0 | b >>> 2 & 0xF);
            if (inbuf[inpos] == 46) {
                return outbuf;
            }
            a = b;
            b = DECODE_ARRAY[inbuf[inpos++] & 0xFF];
            outbuf[outpos++] = (byte)(a << 6 & 0xC0 | b & 0x3F);
        }
        return outbuf;
    }

    public static void main(String[] args) {
        String sPassword = "test";
        String sEncryptePassword = LoginPasswordEncrypter.encrypt(sPassword);
        System.out.println(sEncryptePassword);
        System.out.println(LoginPasswordEncrypter.deEncrypt(sEncryptePassword));
    }

    static {
        int i;
        ENCODE_ARRAY = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
        DECODE_ARRAY = new byte[256];
        for (i = 0; i < 255; ++i) {
            LoginPasswordEncrypter.DECODE_ARRAY[i] = -1;
        }
        for (i = 0; i < ENCODE_ARRAY.length; ++i) {
            LoginPasswordEncrypter.DECODE_ARRAY[LoginPasswordEncrypter.ENCODE_ARRAY[i]] = (byte)i;
        }
    }
}

