/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.util;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.components.stat.UserLoginInfo;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyKeyGenerator;
import com.trs.infra.util.CMySign;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.RemoteAddrUtil;
import com.trs.presentation.locale.LocaleServer;
import com.trs.presentation.login.SessionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class LoginHelper {
    private static Logger logger = Logger.getLogger(LoginHelper.class);
    private boolean m_bForceKick = false;
    private static Hashtable htUserNameToSessions = new Hashtable();
    private static Hashtable htIdToSession = new Hashtable();
    private HttpServletRequest m_oRequest;
    private HttpSession m_oSession;
    private User m_oLoginUser;
    private boolean m_bRecordUsedTime = true;
    private static LoginErrNumRecs m_errNumRecs = null;
    public static int ERRNUM_MAX = 20;
    public static final int ERR_USER_NOTEXIST = -8;
    public static final int ERR_USER_LOCKED = -2;
    public static final int ERR_PWD_WRONG = -1;
    public static final int ERR_USER_LOGINED = -3;
    public static final int ERR_USER_NOREG = 0;
    public static final int ERR_USER_FORBID = 20;
    public static final int ERR_USER_DELETED = 10;
    public static final int RESULT_OK = 30;
    public static final int ERR_USERDEF_FROM = -11;
    public static final String SESSION_NAME_USER = "WCM52.loginUser";
    public static final String ONLINE_USER_VERSION = "OnlineUsersListVersion";
    private static final int SESSION_EXPIRE = 60;
    private static final String PARAM_NAME_ENCODE = "RandomInfo";
    public static final String KEY_PRIVATE_LOGIN = "private_login.key";
    public static final String KEY_PUBLIC_LOGIN = "public_login.key";
    public static final String KEY_PRIVATE_PLATFORM_LOGIN;
    public static final String KEY_PUBLIC_PLATFORM_LOGIN;
    public static final String LOGIN_SUCCESS = "\u6210\u529f";
    public static final String LOGIN_FAILD = "\u5931\u8d25";

    public LoginHelper() {
    }

    public LoginHelper(HttpServletRequest _request, ServletContext _servletContext) {
        this.m_oRequest = _request;
        this.m_oSession = _request.getSession();
        Object userKey = this.m_oSession.getAttribute(SESSION_NAME_USER);
        if (userKey != null) {
            try {
                this.m_oLoginUser = User.findByKey(userKey);
            }
            catch (WCMException ex) {
                logger.debug((Object)"create LoginHelper fail:", (Throwable)ex);
            }
        } else {
            userKey = this.m_oSession.getAttribute("loginUser");
            if (userKey != null && userKey instanceof String) {
                try {
                    this.m_oLoginUser = User.findByName((String)userKey);
                }
                catch (Exception ex) {
                    logger.debug((Object)"create LoginHelper fail:", (Throwable)ex);
                }
            }
        }
        if (m_errNumRecs == null) {
            m_errNumRecs = new LoginErrNumRecs();
        }
    }

    public boolean checkLogin() {
        return this.checkLogin(false);
    }

    public boolean checkPluginLogin() {
        return this.checkEncodeInfoFromKey(KEY_PUBLIC_PLATFORM_LOGIN);
    }

    public boolean checkLogin(boolean _bCheckEncodeInfo) {
        if (_bCheckEncodeInfo) {
            return this.checkEncodeInfoFromKey();
        }
        return this.m_oLoginUser != null;
    }

    public User getLoginUser() {
        return this.m_oLoginUser;
    }

    public static final String getErrorMsg(int _nError) {
        return LoginHelper.getErrorMsg(_nError, null);
    }

    public static final String getErrorMsg(int _nError, String _sDefault) {
        switch (_nError) {
            case -8: 
            case -1: {
                return I18NMessage.get(LoginHelper.class, "LoginHelper.label25", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            }
            case -3: {
                return I18NMessage.get(LoginHelper.class, "LoginHelper.label2", "\u7528\u6237\u5df2\u7ecf\u767b\u5f55");
            }
            case -2: {
                return I18NMessage.get(LoginHelper.class, "LoginHelper.label3", "\u7528\u6237\u5df2\u9501\u5b9a");
            }
            case 0: 
            case 10: 
            case 20: {
                return I18NMessage.get(LoginHelper.class, "LoginHelper.label26", "\u5e10\u53f7\u5904\u4e8e\u975e\u5f00\u901a\u72b6\u6001\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb");
            }
        }
        return _sDefault != null ? _sDefault : I18NMessage.get(LoginHelper.class, "LoginHelper.label8", "\u672a\u77e5\u9519\u8bef[") + _nError + "]";
    }

    public boolean isRecordUsedTime() {
        return this.m_bRecordUsedTime;
    }

    public void setRecordUsedTime(boolean _bRecord) {
        this.m_bRecordUsedTime = _bRecord;
    }

    public int login(String _sUserName, String _sPassword) throws WCMException {
        boolean bIsSameIp;
        if (this.m_oLoginUser != null && this.m_oLoginUser.getName().equalsIgnoreCase(_sUserName)) {
            return 30;
        }
        Object keyUtil = null;
        String sRemoteAddr = "";
        User aUser = User.findByName(_sUserName);
        try {
            sRemoteAddr = RemoteAddrUtil.getRemoteAddr(this.m_oRequest);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            throw new WCMException(e.getMessage());
        }
        int nMaxUserCount = 0;
        String sPreLoginIp = "";
        if (aUser != null) {
            sPreLoginIp = CMyString.showNull(aUser.getLoginIP());
        }
        boolean bl = bIsSameIp = !CMyString.isEmpty(sPreLoginIp) && sPreLoginIp.equals(sRemoteAddr);
        if (nMaxUserCount > 0 && LoginHelper.getOnlineUserCount() >= nMaxUserCount) {
            throw new WCMException(I18NMessage.get(LoginHelper.class, "LoginHelper.label9", "\u60a8\u7cfb\u7edf\u53ea\u5141\u8bb8\u3010") + nMaxUserCount + I18NMessage.get(LoginHelper.class, "LoginHelper.label10", "\u3011\u4e2a\u7528\u6237\u540c\u65f6\u5728\u7ebf\uff01\u8bf7\u548cTRS\u516c\u53f8\u8d2d\u4e70\u7533\u8bf7\u66f4\u591a\u7684\u8bb8\u53ef\uff01\u611f\u8c22\u60a8\u4f7f\u7528TRS\u4ea7\u54c1\uff01"));
        }
        boolean bAllowRepeatLogin = bIsSameIp || nMaxUserCount == 0 && "true".equals(ConfigServer.getServer().getSysConfigValue("REPEAT_LOGIN_ALLOWED", "false"));
        int nResult = -1;
        long lStartId = 0L;
        try {
            if (aUser == null) {
                aUser = new User();
                aUser.setName(_sUserName);
            } else {
                this.m_oLoginUser = aUser;
            }
            ContextHelper.setArg(LogServer.CONTEXT_INDEX_IP, sRemoteAddr);
            String sDesc = CMyString.format(I18NMessage.get(LoginHelper.class, "LoginHelper.label11", "\u7528\u6237({0})\u4e8e{1}\u4ece [{2}]\u767b\u5f55\u7cfb\u7edf."), new String[]{aUser.toString(), CMyDateTime.now().toString(), sRemoteAddr});
            lStartId = LogServer.startRecord(_sUserName, "USER_LOGIN", sDesc, aUser);
            if (this.m_oLoginUser == null) {
                nResult = -8;
            } else if (!bAllowRepeatLogin && LoginHelper.getSessionByUser(this.m_oLoginUser) != null && LoginHelper.getSessionByUser(this.m_oLoginUser).size() != 0) {
                if (this.canReLogin(this.m_oLoginUser, _sPassword, sRemoteAddr) || this.isForceKick()) {
                    this.kickOffSelf(this.m_oLoginUser);
                    this.m_oLoginUser = null;
                    int n = this.login(_sUserName, _sPassword);
                    return n;
                }
                nResult = !this.m_oLoginUser.passwordIs(_sPassword) ? -1 : -3;
            } else {
                int nErrNum = m_errNumRecs.getErrNum(this.m_oLoginUser);
                if (this.isOverMaxErrNum(nErrNum)) {
                    nResult = 20;
                } else {
                    nResult = this.m_oLoginUser.login(_sPassword, sRemoteAddr);
                    if (nResult == -1) {
                        nErrNum = m_errNumRecs.incErrNum(this.m_oLoginUser);
                        if (this.isOverMaxErrNum(nErrNum)) {
                            this.forbidUser(this.m_oLoginUser);
                            if (this.m_oLoginUser.isForbidden()) {
                                m_errNumRecs.clearErrNum(this.m_oLoginUser);
                            }
                        }
                    } else if (nResult == 30 && nErrNum > 0) {
                        m_errNumRecs.clearErrNum(this.m_oLoginUser);
                    }
                }
            }
        }
        catch (WCMException ex) {
            LogServer.endRecordFailedOperation(lStartId, ex);
            lStartId = 0L;
            throw new WCMException(1100, I18NMessage.get(LoginHelper.class, "LoginHelper.label14", "\u7528\u6237\u767b\u5f55\u5931\u8d25(loginHelper.login)"), ex);
        }
        finally {
            if (lStartId > 0L) {
                if (nResult == 30) {
                    LogServer.endRecordSucceedOperation(lStartId);
                } else {
                    LogServer.endRecordFailedOperation(lStartId, null);
                }
            }
        }
        if (nResult == 30) {
            SessionListener sessionListener = new SessionListener(this.m_oLoginUser.getKey());
            this.m_oSession.setAttribute("listener", (Object)sessionListener);
            this.m_oSession.setAttribute(SESSION_NAME_USER, (Object)this.m_oLoginUser.getKey());
            this.m_oSession.setMaxInactiveInterval(3600);
            ContextHelper.initContext(this.m_oLoginUser);
        }
        if (nResult == 30) {
            if (!"system".equals(_sUserName)) {
                CMyDateTime loginTime = new CMyDateTime();
                loginTime.setDateTimeWithCurrentTime();
                aUser.setProperty("LOGINTIME", loginTime);
                int nLoginTimes = aUser.getLoginTimes();
                aUser.setProperty("LOGINTIMES", nLoginTimes + 1);
                aUser.setAttribute("LoginIP", sRemoteAddr);
                try {
                    aUser.save();
                }
                catch (Exception ex) {
                    logger.warn((Object)"set user login info failed.", (Throwable)ex);
                }
            }
            this.addUserLoginInfo();
        }
        return nResult;
    }

    public int loginByIDS(String _sUserName) throws WCMException {
        int nResult = -1;
        long lStartId = 0L;
        String sRemoteAddr = "";
        User aUser = User.findByName(_sUserName);
        try {
            sRemoteAddr = RemoteAddrUtil.getRemoteAddr(this.m_oRequest);
            ContextHelper.setArg(LogServer.CONTEXT_INDEX_IP, sRemoteAddr);
            String sDesc = CMyString.format(I18NMessage.get(LoginHelper.class, "LoginHelper.label11", "\u7528\u6237({0})\u4e8e{1}\u4ece [{2}]\u767b\u5f55\u7cfb\u7edf."), new String[]{_sUserName, CMyDateTime.now().toString(), sRemoteAddr});
            lStartId = LogServer.startRecord(_sUserName, "USER_LOGIN", sDesc, aUser);
            this.m_oLoginUser = User.findByName(_sUserName);
            nResult = 30;
        }
        catch (Throwable ex) {
            LogServer.endRecordFailedOperation(lStartId, ex);
            lStartId = 0L;
            throw new WCMException(1100, I18NMessage.get(LoginHelper.class, "LoginHelper.label14", "\u7528\u6237\u767b\u5f55\u5931\u8d25(loginHelper.login)"), ex);
        }
        finally {
            if (lStartId > 0L && nResult == 30) {
                LogServer.endRecordSucceedOperation(lStartId);
            } else {
                LogServer.endRecordFailedOperation(lStartId, null);
            }
        }
        if (nResult == 30) {
            SessionListener sessionListener = new SessionListener(this.m_oLoginUser.getKey());
            this.m_oSession.setAttribute("listener", (Object)sessionListener);
            this.m_oSession.setAttribute(SESSION_NAME_USER, (Object)this.m_oLoginUser.getKey());
            this.m_oSession.setMaxInactiveInterval(3600);
            this.m_oLoginUser.setAttribute("LoginIP", sRemoteAddr);
            ContextHelper.initContext(this.m_oLoginUser);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("login ok:" + this.m_oLoginUser + ":" + sRemoteAddr));
            }
            try {
                Object sLocale = this.m_oSession.getAttribute("locale");
                if (sLocale == null && !User.getSystem().getName().equals(this.m_oLoginUser.getName())) {
                    this.m_oSession.setAttribute("locale", (Object)"zh_CN");
                    LocaleServer.setFavorLanguage(this.m_oLoginUser, "zh_CN");
                }
            }
            catch (Exception e) {
                logger.warn((Object)"set favor lang failed.", (Throwable)e);
            }
            if (!"system".equals(_sUserName)) {
                CMyDateTime loginTime = new CMyDateTime();
                loginTime.setDateTimeWithCurrentTime();
                aUser.setProperty("LOGINTIME", loginTime);
                int nLoginTimes = aUser.getLoginTimes();
                aUser.setProperty("LOGINTIMES", nLoginTimes + 1);
                aUser.setAttribute("LoginIP", sRemoteAddr);
                try {
                    aUser.save();
                }
                catch (Exception ex) {
                    logger.warn((Object)"set user login info failed.", (Throwable)ex);
                }
            }
        }
        return nResult;
    }

    public void logout() {
        if (this.getLoginUser() == null) {
            return;
        }
        String sDesc = I18NMessage.get(LoginHelper.class, "LoginHelper.label15", "\u7528\u6237[") + this.getLoginUser() + I18NMessage.get(LoginHelper.class, "LoginHelper.label16", "]\u9000\u51fa\u7cfb\u7edf");
        long lStartId = LogServer.startRecord(this.getLoginUser().getName(), "USER_LOGOUT", sDesc, this.getLoginUser());
        this.getLoginUser().logout();
        LogServer.endRecordSucceedOperation(lStartId);
        if (this.m_oSession != null) {
            this.m_oSession.invalidate();
        }
    }

    private void forbidUser(User _user) {
        if (_user.getStatus() == 20) {
            return;
        }
        User opUser = User.getSystem();
        if (!_user.canEdit(opUser)) {
            return;
        }
        try {
            _user.setStatus(20);
            _user.update(opUser);
        }
        catch (Exception ex) {
            _user.cancelUpdate(opUser);
        }
    }

    public int getLoginErrNum(User _user) {
        if (_user == null) {
            return 0;
        }
        return m_errNumRecs.getErrNum(_user);
    }

    public static final void clearLoginErrNum(User _user) {
        if (_user != null) {
            m_errNumRecs.clearErrNum(_user);
        }
    }

    public boolean isOverMaxErrNum(int _errNum) throws WCMException {
        int iSysErrNum;
        String sysErrNum = ConfigServer.getServer().getSysConfigValue("LOGIN_ERRNUM_MAX", String.valueOf(ERRNUM_MAX));
        try {
            iSysErrNum = Integer.parseInt(sysErrNum);
        }
        catch (Exception e) {
            iSysErrNum = ERRNUM_MAX;
        }
        return iSysErrNum > 0 && _errNum >= iSysErrNum;
    }

    public boolean checkOnlineUserUpdate() {
        int nSessionListenerVersion = SessionListener.getVersion();
        String sVersion = (String)this.m_oSession.getAttribute(ONLINE_USER_VERSION);
        if (sVersion == null) {
            this.m_oSession.setAttribute(ONLINE_USER_VERSION, (Object)String.valueOf(nSessionListenerVersion));
            return true;
        }
        int nCurrVersion = Integer.parseInt(sVersion);
        if (nCurrVersion == nSessionListenerVersion) {
            return false;
        }
        this.m_oSession.setAttribute(ONLINE_USER_VERSION, (Object)String.valueOf(nSessionListenerVersion));
        return true;
    }

    public static Users getOnlineUsers() {
        Vector vOnlineUsers = SessionListener.getOnlineUsers();
        Users aOnlineUsers = new Users(User.getSystem());
        int nCount = vOnlineUsers.size();
        Integer iUserId = null;
        for (int i = 0; i < nCount; ++i) {
            iUserId = (Integer)vOnlineUsers.get(i);
            aOnlineUsers.addElement(iUserId);
        }
        return aOnlineUsers;
    }

    public static int getOnlineUserCount() {
        return SessionListener.getCount();
    }

    public String createEncodeUserInfo() {
        return this.createEncodeUserInfo(this.getLoginUser(), KEY_PRIVATE_LOGIN);
    }

    public String createPluginEncodeUserInfo() {
        try {
            return this.createEncodeUserInfo(User.findById(1), KEY_PRIVATE_PLATFORM_LOGIN);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String createPluginEncodeUserInfo(String parameters) {
        try {
            return this.createEncodeUserInfo(User.findById(1), KEY_PRIVATE_PLATFORM_LOGIN, parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String createEncodeUserInfo(User _loginUser, String _sPrivateKeyFile) {
        return this.createEncodeUserInfo(_loginUser, _sPrivateKeyFile, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createEncodeUserInfo(User _loginUser, String _sPrivateKeyFile, String _sParam) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("_sPrivateKeyFile:" + _sPrivateKeyFile));
        }
        if (_loginUser == null) {
            return "";
        }
        ByteArrayOutputStream bos = null;
        FilterOutputStream dos = null;
        try {
            CMySign su = CMySign.getSign(_sPrivateKeyFile);
            bos = new ByteArrayOutputStream(1024);
            dos = new DataOutputStream(bos);
            ((DataOutputStream)dos).writeInt(_loginUser.getId());
            ((DataOutputStream)dos).writeUTF(_loginUser.getName());
            String param = CMyString.showEmpty(_sParam);
            ((DataOutputStream)dos).writeUTF(param);
            ((DataOutputStream)dos).flush();
            byte[] buff = su.sign(bos.toByteArray());
            ((DataOutputStream)dos).writeInt(buff.length);
            dos.write(buff);
            ((DataOutputStream)dos).flush();
            String sDataWithSign = su.encodeRadix64(bos.toByteArray());
            String string = "RandomInfo=" + sDataWithSign;
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (Exception exception) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception exception) {}
            }
        }
        return "";
    }

    private boolean checkEncodeInfoFromKey() {
        String sPublicKey = KEY_PUBLIC_LOGIN;
        return this.checkEncodeInfoFromKey(sPublicKey);
    }

    public String getPluginParams() {
        try {
            String sEncodeInfo = CMyString.getStr(this.m_oRequest.getParameter(PARAM_NAME_ENCODE));
            byte[] buff = sEncodeInfo.getBytes();
            CMySign verify = CMySign.getVerify(KEY_PUBLIC_PLATFORM_LOGIN);
            buff = verify.decodeRadix64(buff);
            DataInputStream is = new DataInputStream(new ByteArrayInputStream(buff));
            is.readInt();
            is.readUTF();
            return is.readUTF();
        }
        catch (Exception ex) {
            return "";
        }
    }

    public boolean checkEncodeInfoFromKey(String sPublicKey) {
        String sEncodeInfo = CMyString.getStr(this.m_oRequest.getParameter(PARAM_NAME_ENCODE));
        if (sEncodeInfo == null) {
            return this.m_oLoginUser != null;
        }
        return this.checkEncodeInfo(sPublicKey, sEncodeInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkEncodeInfo(String sPublicKey, String sEncodeInfo) {
        logger.debug((Object)("sPublicKey:" + sPublicKey));
        User currUser = null;
        String sParam = "";
        try {
            int nSignLen;
            byte[] buff = sEncodeInfo.getBytes();
            CMySign verify = CMySign.getVerify(sPublicKey);
            buff = verify.decodeRadix64(buff);
            ByteArrayInputStream baoins = new ByteArrayInputStream(buff);
            DataInputStream dataInputStream = new DataInputStream(baoins);
            int nUserId = dataInputStream.readInt();
            String sUserName = dataInputStream.readUTF();
            sParam = dataInputStream.readUTF();
            if (sParam == null) {
                sParam = "";
            }
            if (!verify.verify(buff, nSignLen = dataInputStream.readInt())) {
                logger.error((Object)"Invalid random info: Signature doesn't matched.");
                return false;
            }
            currUser = User.findById(nUserId);
            if (currUser == null) {
                currUser = User.findById(1);
                if (currUser == null) {
                    logger.error((Object)"No such user: default admin.");
                    return false;
                }
            } else if (nUserId != 1 && !currUser.getName().equals(sUserName)) {
                logger.error((Object)("Invalid user: " + sUserName));
                return false;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to check login.", (Throwable)ex);
            return false;
        }
        if (this.m_oLoginUser != null && this.m_oLoginUser.equals(currUser)) {
            return true;
        }
        long lStartId = 0L;
        try {
            String sDesc = CMyString.format(I18NMessage.get(LoginHelper.class, "LoginHelper.label20", "\u7528\u6237\u4e8e{0}\u4ece [{1}]\u901a\u8fc7\u7b7e\u540d\u767b\u9646\u7cfb\u7edf."), new String[]{CMyDateTime.now().toString(), this.m_oRequest.getRemoteAddr()});
            User aUser = new User();
            aUser.setName(I18NMessage.get(LoginHelper.class, "LoginHelper.label21", "\u533f\u540d"));
            lStartId = LogServer.startRecord(I18NMessage.get(LoginHelper.class, "LoginHelper.label21", "\u533f\u540d"), "USER_LOGGIN", sDesc, aUser);
            this.m_oSession.setAttribute(SESSION_NAME_USER, (Object)currUser.getKey());
            this.m_oLoginUser = currUser;
            LogServer.endRecordSucceedOperation(lStartId);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.error((Object)I18NMessage.get(LoginHelper.class, "LoginHelper.label22", "\u6821\u9a8c\u5931\u8d25\uff01"), (Throwable)ex);
            LogServer.endRecordFailedOperation(lStartId, ex);
            lStartId = 0L;
        }
        finally {
            if (lStartId > 0L) {
                LogServer.endRecordSucceedOperation(lStartId);
            }
        }
        return false;
    }

    public static void putSession(Integer _oUserKey, HttpSession _session) {
        if (_session == null) {
            return;
        }
        ArrayList hsList = new ArrayList();
        if (htUserNameToSessions.containsKey(_oUserKey)) {
            hsList = (ArrayList)htUserNameToSessions.get(_oUserKey);
            hsList.add(_session);
            htUserNameToSessions.put(_oUserKey, hsList);
        } else {
            hsList.add(_session);
            htUserNameToSessions.put(_oUserKey, hsList);
        }
        htIdToSession.put(_session.getId(), _session);
    }

    public static ArrayList getSessionByUser(User _oUser) {
        if (_oUser == null) {
            return null;
        }
        return (ArrayList)htUserNameToSessions.get(_oUser.getKey());
    }

    public static HttpSession getSessionById(String _sessionId) {
        if (_sessionId == null || (_sessionId = _sessionId.trim()).length() <= 0) {
            return null;
        }
        return (HttpSession)htIdToSession.get(_sessionId);
    }

    public static void removeSession(HttpSession _session, Integer _oUserKey) {
        if (_session == null) {
            return;
        }
        String sSessionId = _session.getId();
        htUserNameToSessions.remove(_oUserKey);
        htIdToSession.remove(sSessionId);
    }

    public static void kickUser(User _operUser, User user) throws WCMException {
        if (_operUser == null) {
            return;
        }
        ArrayList sessions = LoginHelper.getSessionByUser(user);
        if (sessions == null || sessions.size() == 0) {
            return;
        }
        try {
            for (int i = 0; i < sessions.size(); ++i) {
                HttpSession session = (HttpSession)sessions.get(i);
                session.invalidate();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void kickOffSelf(User _loginUser) {
        if (_loginUser == null) {
            return;
        }
        ArrayList sessions = LoginHelper.getSessionByUser(_loginUser);
        if (sessions == null || sessions.size() == 0) {
            return;
        }
        try {
            for (int i = 0; i < sessions.size(); ++i) {
                HttpSession session = (HttpSession)sessions.get(i);
                session.invalidate();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public boolean canReLogin(User _loginUser, String _sPassword, String _sRemoteAddr) {
        if (_loginUser == null || !_loginUser.passwordIs(_sPassword)) {
            return false;
        }
        ArrayList sessions = LoginHelper.getSessionByUser(_loginUser);
        if (sessions == null || sessions.size() == 0) {
            return true;
        }
        String previousLoginAddr = _loginUser.getLoginIP();
        return previousLoginAddr == null || previousLoginAddr.equals(_sRemoteAddr);
    }

    private static void createPlatformKey() {
        try {
            if (!CMyFile.fileExists(KEY_PRIVATE_PLATFORM_LOGIN)) {
                logger.info((Object)("create " + KEY_PRIVATE_PLATFORM_LOGIN + " file.."));
                CMyKeyGenerator.generatorKey(KEY_PRIVATE_PLATFORM_LOGIN, KEY_PUBLIC_PLATFORM_LOGIN);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final boolean isForceKick() {
        return this.m_bForceKick;
    }

    public final void setForceKick(boolean forceKick) {
        this.m_bForceKick = forceKick;
    }

    private void addUserLoginInfo() {
        try {
            UserLoginInfo userLoginInfo = UserLoginInfo.createNewInstance();
            userLoginInfo.setUserId(this.m_oLoginUser.getId());
            userLoginInfo.setLoginTime(this.m_oLoginUser.getLoginTime());
            userLoginInfo.setIpAddress(this.m_oLoginUser.getLoginIP());
            userLoginInfo.save(this.m_oLoginUser);
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
    }

    public boolean isLoginWithVerifyCode() throws WCMException {
        String sLoginWithVerifyCode = ConfigServer.getServer().getSysConfigValue("LOGIN_WITH_VERIFYCODE", "false");
        return "true".equalsIgnoreCase(sLoginWithVerifyCode);
    }

    public static boolean isWorkTime() throws WCMException {
        String sLoginTime = ConfigServer.getServer().getSysConfigValue("PERMIT_LOGIN_TIME", "false");
        if ("false".equalsIgnoreCase(sLoginTime) || "".equalsIgnoreCase(sLoginTime.trim())) {
            return true;
        }
        try {
            Date tNowTime;
            Date tEndTime;
            Date tBeginTime;
            String[] aLoginTime = sLoginTime.split(",");
            if (aLoginTime.length != 3) {
                return true;
            }
            String sBeginTime = aLoginTime[0];
            String sEndTime = aLoginTime[1];
            String isWeekend = aLoginTime[2];
            CMyDateTime currTime = CMyDateTime.now();
            if ("false".equalsIgnoreCase(isWeekend) && "17".indexOf(String.valueOf(currTime.getDayOfWeek())) > -1) {
                return false;
            }
            SimpleDateFormat sFormat = new SimpleDateFormat("HH:mm");
            String sNowTime = sFormat.format(new Date());
            try {
                tBeginTime = sFormat.parse(sBeginTime);
                tEndTime = sFormat.parse(sEndTime);
                tNowTime = sFormat.parse(sNowTime);
            }
            catch (Exception e) {
                return true;
            }
            long beginTime = tBeginTime.getTime();
            long endTime = tEndTime.getTime();
            long nowTime = tNowTime.getTime();
            if (beginTime < endTime && beginTime < nowTime && nowTime < endTime) {
                return true;
            }
            return beginTime > endTime && (beginTime < nowTime || nowTime < endTime);
        }
        catch (Exception e) {
            return true;
        }
    }

    static {
        CMyKeyGenerator.generatorKey(KEY_PRIVATE_LOGIN, KEY_PUBLIC_LOGIN);
        KEY_PRIVATE_PLATFORM_LOGIN = ConfigConstants.DIR_APPROOT + "private_platform_log.key";
        KEY_PUBLIC_PLATFORM_LOGIN = ConfigConstants.DIR_APPROOT + "public_platform_log.key";
        LoginHelper.createPlatformKey();
    }

    private class LoginErrNumRecs {
        private Hashtable m_recs = new Hashtable();

        private Object key(User _user) {
            return new Integer(_user.getId());
        }

        private void setRec(User _user, int _nErrNum) {
            this.m_recs.put(this.key(_user), new Integer(_nErrNum));
        }

        public int getErrNum(User _user) {
            Integer iRec = (Integer)this.m_recs.get(this.key(_user));
            return iRec == null ? 0 : iRec;
        }

        public int incErrNum(User _user) {
            int nNum = this.getErrNum(_user) + 1;
            this.setRec(_user, nNum);
            return nNum;
        }

        public void clearErrNum(User _user) {
            this.setRec(_user, 0);
        }
    }
}

